/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.inline;

import com.intellij.codeInsight.ChangeContextUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PlatformPatterns;
import com.intellij.patterns.PsiElementPattern;
import com.intellij.patterns.PsiJavaPatterns;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiArrayInitializerExpression;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiCall;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassInitializer;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiEllipsisType;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.impl.source.codeStyle.CodeEditUtil;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.ProjectScope;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.refactoring.inline.InlineMethodHandler;
import com.intellij.refactoring.inline.InlineMethodProcessor;
import com.intellij.refactoring.util.RefactoringUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ProcessingContext;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.Nullable;

class InlineToAnonymousConstructorProcessor {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.refactoring.inline.InlineToAnonymousConstructorProcessor");
    private static final Key<PsiAssignmentExpression> ourAssignmentKey = Key.create((String)"assignment");
    private static final Key<PsiCallExpression> ourCallKey = Key.create((String)"call");
    public static final ElementPattern ourNullPattern = PlatformPatterns.psiElement(PsiLiteralExpression.class).withText("null");
    private static final ElementPattern ourAssignmentPattern = PsiJavaPatterns.psiExpressionStatement().withChild((ElementPattern)PlatformPatterns.psiElement(PsiAssignmentExpression.class).save(ourAssignmentKey));
    private static final ElementPattern ourSuperCallPattern = PsiJavaPatterns.psiExpressionStatement().withFirstChild((ElementPattern)((PsiElementPattern.Capture)PlatformPatterns.psiElement(PsiMethodCallExpression.class).save(ourCallKey)).withFirstChild((ElementPattern)PlatformPatterns.psiElement().withText("super")));
    private static final ElementPattern ourThisCallPattern = PsiJavaPatterns.psiExpressionStatement().withFirstChild((ElementPattern)PlatformPatterns.psiElement(PsiMethodCallExpression.class).withFirstChild((ElementPattern)PlatformPatterns.psiElement().withText("this")));
    private final PsiClass myClass;
    private final PsiNewExpression myNewExpression;
    private final PsiType mySuperType;
    private final Map<String, PsiExpression> myFieldInitializers = new HashMap<String, PsiExpression>();
    private final Map<PsiParameter, PsiVariable> myLocalsForParameters = new HashMap<PsiParameter, PsiVariable>();
    private final PsiStatement myNewStatement;
    private final PsiElementFactory myElementFactory;
    private PsiMethod myConstructor;
    private PsiExpressionList myConstructorArguments;
    private PsiParameterList myConstructorParameters;

    public InlineToAnonymousConstructorProcessor(PsiClass aClass, PsiNewExpression psiNewExpression, PsiType superType) {
        this.myClass = aClass;
        this.myNewExpression = psiNewExpression;
        this.mySuperType = superType;
        this.myNewStatement = (PsiStatement)PsiTreeUtil.getParentOfType((PsiElement)this.myNewExpression, PsiStatement.class);
        this.myElementFactory = JavaPsiFacade.getInstance((Project)this.myClass.getProject()).getElementFactory();
    }

    public void run() throws IncorrectOperationException {
        this.checkInlineChainingConstructor();
        JavaResolveResult classResolveResult = this.myNewExpression.getClassReference().advancedResolve(false);
        JavaResolveResult methodResolveResult = this.myNewExpression.resolveMethodGenerics();
        this.myConstructor = (PsiMethod)methodResolveResult.getElement();
        this.myConstructorArguments = this.myNewExpression.getArgumentList();
        PsiSubstitutor classResolveSubstitutor = classResolveResult.getSubstitutor();
        PsiType substType = classResolveSubstitutor.substitute(this.mySuperType);
        PsiTypeParameter[] typeParams = this.myClass.getTypeParameters();
        PsiType[] substitutedParameters = new PsiType[typeParams.length];
        for (int i = 0; i < typeParams.length; ++i) {
            substitutedParameters[i] = classResolveSubstitutor.substitute(typeParams[i]);
        }
        StringBuilder builder = new StringBuilder("new ");
        builder.append(substType.getCanonicalText());
        builder.append("() {}");
        PsiNewExpression superNewExpressionTemplate = (PsiNewExpression)this.myElementFactory.createExpressionFromText(builder.toString(), (PsiElement)this.myNewExpression.getContainingFile());
        PsiClassInitializer initializerBlock = this.myElementFactory.createClassInitializer();
        PsiVariable outerClassLocal = null;
        if (this.myNewExpression.getQualifier() != null && this.myClass.getContainingClass() != null) {
            outerClassLocal = this.generateOuterClassLocal();
        }
        if (this.myConstructor != null) {
            this.myConstructorParameters = this.myConstructor.getParameterList();
            PsiExpressionList argumentList = superNewExpressionTemplate.getArgumentList();
            assert (argumentList != null);
            if (this.myNewStatement != null) {
                this.generateLocalsForArguments();
            }
            this.analyzeConstructor(initializerBlock.getBody());
            this.addSuperConstructorArguments(argumentList);
        }
        ChangeContextUtil.encodeContextInfo(this.myClass.getNavigationElement(), true);
        PsiClass classCopy = (PsiClass)this.myClass.getNavigationElement().copy();
        ChangeContextUtil.clearContextInfo((PsiElement)this.myClass);
        PsiAnonymousClass anonymousClass = superNewExpressionTemplate.getAnonymousClass();
        assert (anonymousClass != null);
        int fieldCount = this.myClass.getFields().length;
        int processedFields = 0;
        PsiJavaToken token = anonymousClass.getRBrace();
        if (initializerBlock.getBody().getStatements().length > 0 && fieldCount == 0) {
            this.insertInitializerBefore(initializerBlock, (PsiClass)anonymousClass, token);
        }
        for (PsiElement child : classCopy.getChildren()) {
            if (child instanceof PsiMethod && !((PsiMethod)child).isConstructor() || child instanceof PsiClassInitializer || child instanceof PsiClass) {
                if (!this.myFieldInitializers.isEmpty() || !this.myLocalsForParameters.isEmpty() || classResolveSubstitutor != PsiSubstitutor.EMPTY || outerClassLocal != null) {
                    this.replaceReferences((PsiMember)child, substitutedParameters, outerClassLocal);
                }
                child = anonymousClass.addBefore(child, (PsiElement)token);
                continue;
            }
            if (!(child instanceof PsiField)) continue;
            PsiField field = (PsiField)child;
            this.replaceReferences((PsiMember)field, substitutedParameters, outerClassLocal);
            PsiExpression initializer = this.myFieldInitializers.get(field.getName());
            field = (PsiField)anonymousClass.addBefore((PsiElement)field, (PsiElement)token);
            if (initializer != null) {
                field.setInitializer(initializer);
            }
            if (++processedFields != fieldCount || initializerBlock.getBody().getStatements().length <= 0) continue;
            this.insertInitializerBefore(initializerBlock, (PsiClass)anonymousClass, token);
        }
        if (PsiTreeUtil.getChildrenOfType((PsiElement)anonymousClass, PsiMember.class) == null) {
            anonymousClass.deleteChildRange((PsiElement)anonymousClass.getLBrace(), (PsiElement)anonymousClass.getRBrace());
        }
        PsiNewExpression superNewExpression = (PsiNewExpression)this.myNewExpression.replace((PsiElement)superNewExpressionTemplate);
        superNewExpression = (PsiNewExpression)ChangeContextUtil.decodeContextInfo((PsiElement)superNewExpression, (PsiClass)superNewExpression.getAnonymousClass(), null);
        JavaCodeStyleManager.getInstance((Project)superNewExpression.getProject()).shortenClassReferences((PsiElement)superNewExpression);
    }

    private void insertInitializerBefore(PsiClassInitializer initializerBlock, PsiClass anonymousClass, PsiJavaToken token) throws IncorrectOperationException {
        anonymousClass.addBefore(CodeEditUtil.createLineFeed(token.getManager()), (PsiElement)token);
        anonymousClass.addBefore((PsiElement)initializerBlock, (PsiElement)token);
        anonymousClass.addBefore(CodeEditUtil.createLineFeed(token.getManager()), (PsiElement)token);
    }

    private void checkInlineChainingConstructor() {
        PsiMethod constructor;
        while ((constructor = this.myNewExpression.resolveConstructor()) != null && InlineMethodHandler.isChainingConstructor(constructor)) {
            InlineMethodProcessor.inlineConstructorCall((PsiCall)this.myNewExpression);
        }
    }

    private void analyzeConstructor(PsiCodeBlock initializerBlock) throws IncorrectOperationException {
        PsiCodeBlock body = this.myConstructor.getBody();
        assert (body != null);
        for (PsiElement child : body.getChildren()) {
            if (child instanceof PsiStatement) {
                PsiStatement stmt = (PsiStatement)child;
                ProcessingContext context = new ProcessingContext();
                if (ourAssignmentPattern.accepts((Object)stmt, context)) {
                    PsiAssignmentExpression expression = (PsiAssignmentExpression)context.get(ourAssignmentKey);
                    if (!this.processAssignmentInConstructor(expression)) continue;
                    initializerBlock.addBefore(this.replaceParameterReferences((PsiElement)stmt, null, false), (PsiElement)initializerBlock.getRBrace());
                    continue;
                }
                if (ourSuperCallPattern.accepts((Object)stmt) || ourThisCallPattern.accepts((Object)stmt)) continue;
                this.replaceParameterReferences((PsiElement)stmt, new ArrayList<PsiReferenceExpression>(), false);
                initializerBlock.addBefore((PsiElement)stmt, (PsiElement)initializerBlock.getRBrace());
                continue;
            }
            if (!(child instanceof PsiComment)) continue;
            if (child.getPrevSibling() instanceof PsiWhiteSpace) {
                initializerBlock.addBefore(child.getPrevSibling(), (PsiElement)initializerBlock.getRBrace());
            }
            initializerBlock.addBefore(child, (PsiElement)initializerBlock.getRBrace());
        }
    }

    private boolean processAssignmentInConstructor(PsiAssignmentExpression expression) {
        if (expression.getLExpression() instanceof PsiReferenceExpression) {
            PsiReferenceExpression lExpr = (PsiReferenceExpression)expression.getLExpression();
            PsiExpression rExpr = expression.getRExpression();
            if (rExpr == null) {
                return false;
            }
            PsiElement psiElement = lExpr.resolve();
            if (psiElement instanceof PsiField) {
                PsiField field = (PsiField)psiElement;
                if (this.myClass.getManager().areElementsEquivalent((PsiElement)field.getContainingClass(), (PsiElement)this.myClass)) {
                    PsiExpression initializer;
                    ArrayList<PsiReferenceExpression> localVarRefs = new ArrayList<PsiReferenceExpression>();
                    try {
                        initializer = (PsiExpression)this.replaceParameterReferences((PsiElement)((PsiExpression)rExpr.copy()), localVarRefs, false);
                    }
                    catch (IncorrectOperationException e) {
                        LOG.error((Throwable)e);
                        return false;
                    }
                    if (!localVarRefs.isEmpty()) {
                        return true;
                    }
                    this.myFieldInitializers.put(field.getName(), initializer);
                }
            } else if (psiElement instanceof PsiVariable) {
                return true;
            }
        }
        return false;
    }

    public static boolean isConstant(PsiExpression expr) {
        Object constantValue = JavaPsiFacade.getInstance((Project)expr.getProject()).getConstantEvaluationHelper().computeConstantExpression((PsiElement)expr);
        return constantValue != null || ourNullPattern.accepts((Object)expr);
    }

    private PsiVariable generateOuterClassLocal() {
        PsiClass outerClass = this.myClass.getContainingClass();
        assert (outerClass != null);
        return this.generateLocal(StringUtil.decapitalize((String)outerClass.getName()), (PsiType)this.myElementFactory.createType(outerClass), this.myNewExpression.getQualifier());
    }

    private PsiVariable generateLocal(String baseName, PsiType type, PsiExpression initializer) {
        String localName;
        JavaCodeStyleManager codeStyleManager = JavaCodeStyleManager.getInstance((Project)this.myClass.getProject());
        String baseNameForIndex = baseName;
        int index = 0;
        while (this.myClass.findFieldByName(localName = codeStyleManager.suggestUniqueVariableName(baseNameForIndex, (PsiElement)this.myNewExpression, true), false) != null) {
            baseNameForIndex = baseName + ++index;
        }
        try {
            PsiDeclarationStatement declaration = this.myElementFactory.createVariableDeclarationStatement(localName, type, initializer);
            PsiVariable variable = (PsiVariable)declaration.getDeclaredElements()[0];
            PsiUtil.setModifierProperty((PsiModifierListOwner)variable, (String)"final", (boolean)true);
            this.myNewStatement.getParent().addBefore((PsiElement)declaration, (PsiElement)this.myNewStatement);
            return variable;
        }
        catch (IncorrectOperationException e) {
            LOG.error((Throwable)e);
            return null;
        }
    }

    private void generateLocalsForArguments() {
        PsiExpression[] expressions = this.myConstructorArguments.getExpressions();
        for (int i = 0; i < expressions.length; ++i) {
            PsiExpression expr = expressions[i];
            PsiParameter parameter = this.myConstructorParameters.getParameters()[i];
            if (parameter.isVarArgs()) {
                PsiEllipsisType ellipsisType = (PsiEllipsisType)parameter.getType();
                PsiType baseType = ellipsisType.getComponentType();
                StringBuilder exprBuilder = new StringBuilder("new ");
                exprBuilder.append(baseType.getCanonicalText());
                exprBuilder.append("[] { }");
                try {
                    PsiNewExpression newExpr = (PsiNewExpression)this.myElementFactory.createExpressionFromText(exprBuilder.toString(), (PsiElement)this.myClass);
                    PsiArrayInitializerExpression arrayInitializer = newExpr.getArrayInitializer();
                    assert (arrayInitializer != null);
                    for (int j = i; j < expressions.length; ++j) {
                        arrayInitializer.add((PsiElement)expressions[j]);
                    }
                    PsiVariable variable = this.generateLocal(parameter.getName(), ellipsisType.toArrayType(), (PsiExpression)newExpr);
                    this.myLocalsForParameters.put(parameter, variable);
                }
                catch (IncorrectOperationException e) {
                    LOG.error((Throwable)e);
                }
                break;
            }
            if (InlineToAnonymousConstructorProcessor.isConstant(expr)) continue;
            PsiVariable variable = this.generateLocal(parameter.getName(), parameter.getType(), expr);
            this.myLocalsForParameters.put(parameter, variable);
        }
    }

    private void addSuperConstructorArguments(PsiExpressionList argumentList) throws IncorrectOperationException {
        PsiCodeBlock body = this.myConstructor.getBody();
        assert (body != null);
        PsiStatement[] statements = body.getStatements();
        if (statements.length == 0) {
            return;
        }
        ProcessingContext context = new ProcessingContext();
        if (!ourSuperCallPattern.accepts((Object)statements[0], context)) {
            return;
        }
        PsiExpressionList superArguments = ((PsiCallExpression)context.get(ourCallKey)).getArgumentList();
        if (superArguments != null) {
            for (PsiExpression argument : superArguments.getExpressions()) {
                PsiElement superArgument = this.replaceParameterReferences(argument.copy(), new ArrayList<PsiReferenceExpression>(), true);
                argumentList.add(superArgument);
            }
        }
    }

    private PsiElement replaceParameterReferences(PsiElement argument, final @Nullable List<PsiReferenceExpression> localVarRefs, final boolean replaceFieldsWithInitializers) throws IncorrectOperationException {
        PsiElement element;
        if (argument instanceof PsiReferenceExpression && (element = ((PsiReferenceExpression)argument).resolve()) instanceof PsiParameter) {
            PsiParameter parameter = (PsiParameter)element;
            if (this.myLocalsForParameters.containsKey(parameter)) {
                return argument.replace((PsiElement)this.getParameterReference(parameter));
            }
            int index = this.myConstructorParameters.getParameterIndex(parameter);
            return argument.replace((PsiElement)this.myConstructorArguments.getExpressions()[index]);
        }
        final ArrayList parameterReferences = new ArrayList();
        final HashMap<PsiElement, PsiElement> elementsToReplace = new HashMap<PsiElement, PsiElement>();
        argument.accept((PsiElementVisitor)new JavaRecursiveElementWalkingVisitor(){

            public void visitReferenceExpression(PsiReferenceExpression expression) {
                super.visitReferenceExpression(expression);
                PsiElement psiElement = expression.resolve();
                if (psiElement instanceof PsiParameter) {
                    parameterReferences.add(new Pair((Object)expression, (Object)((PsiParameter)psiElement)));
                } else if ((psiElement instanceof PsiField || psiElement instanceof PsiMethod) && ((PsiMember)psiElement).getContainingClass() == InlineToAnonymousConstructorProcessor.this.myClass.getSuperClass()) {
                    PsiMember member = (PsiMember)psiElement;
                    if (member.hasModifierProperty("static") && expression.getQualifierExpression() == null) {
                        String qualifiedText = InlineToAnonymousConstructorProcessor.this.myClass.getSuperClass().getQualifiedName() + "." + member.getName();
                        try {
                            PsiExpression replacement = InlineToAnonymousConstructorProcessor.this.myElementFactory.createExpressionFromText(qualifiedText, (PsiElement)InlineToAnonymousConstructorProcessor.this.myClass);
                            elementsToReplace.put(expression, replacement);
                        }
                        catch (IncorrectOperationException e) {
                            LOG.error((Throwable)e);
                        }
                    }
                } else if (psiElement instanceof PsiVariable) {
                    PsiExpression initializer;
                    if (localVarRefs != null) {
                        localVarRefs.add(expression);
                    }
                    if (replaceFieldsWithInitializers && psiElement instanceof PsiField && ((PsiField)psiElement).getContainingClass() == InlineToAnonymousConstructorProcessor.this.myClass && InlineToAnonymousConstructorProcessor.isConstant(initializer = ((PsiField)psiElement).getInitializer())) {
                        elementsToReplace.put(expression, initializer);
                    }
                }
            }
        });
        for (Pair pair : parameterReferences) {
            PsiReferenceExpression ref = (PsiReferenceExpression)pair.first;
            PsiParameter param = (PsiParameter)pair.second;
            if (this.myLocalsForParameters.containsKey(param)) {
                ref.replace((PsiElement)this.getParameterReference(param));
                continue;
            }
            int index = this.myConstructorParameters.getParameterIndex(param);
            if (ref == argument) {
                argument = argument.replace((PsiElement)this.myConstructorArguments.getExpressions()[index]);
                continue;
            }
            ref.replace((PsiElement)this.myConstructorArguments.getExpressions()[index]);
        }
        return RefactoringUtil.replaceElementsWithMap(argument, elementsToReplace);
    }

    private PsiExpression getParameterReference(PsiParameter parameter) throws IncorrectOperationException {
        PsiVariable variable = this.myLocalsForParameters.get(parameter);
        return this.myElementFactory.createExpressionFromText(variable.getName(), (PsiElement)this.myClass);
    }

    private void replaceReferences(final PsiMember method, final PsiType[] substitutedParameters, final PsiVariable outerClassLocal) throws IncorrectOperationException {
        final HashMap<PsiElement, PsiElement> elementsToReplace = new HashMap<PsiElement, PsiElement>();
        method.accept((PsiElementVisitor)new JavaRecursiveElementWalkingVisitor(){

            public void visitReferenceExpression(PsiReferenceExpression expression) {
                super.visitReferenceExpression(expression);
                PsiElement element = expression.resolve();
                if (element instanceof PsiField) {
                    try {
                        PsiField field = (PsiField)element;
                        if (InlineToAnonymousConstructorProcessor.this.myClass.getContainingClass() != null && field.getContainingClass() == InlineToAnonymousConstructorProcessor.this.myClass.getContainingClass() && outerClassLocal != null) {
                            PsiReferenceExpression expr = (PsiReferenceExpression)expression.copy();
                            PsiExpression qualifier = InlineToAnonymousConstructorProcessor.this.myElementFactory.createExpressionFromText(outerClassLocal.getName(), (PsiElement)field.getContainingClass());
                            expr.setQualifierExpression(qualifier);
                            elementsToReplace.put(expression, expr);
                        }
                    }
                    catch (IncorrectOperationException e) {
                        LOG.error((Throwable)e);
                    }
                }
            }

            public void visitTypeParameter(PsiTypeParameter classParameter) {
                PsiJavaCodeReferenceElement[] referenceElements;
                super.visitTypeParameter(classParameter);
                PsiReferenceList list = classParameter.getExtendsList();
                for (PsiJavaCodeReferenceElement reference : referenceElements = list.getReferenceElements()) {
                    PsiElement psiElement = reference.resolve();
                    if (!(psiElement instanceof PsiTypeParameter)) continue;
                    this.checkReplaceTypeParameter((PsiElement)reference, (PsiTypeParameter)psiElement);
                }
            }

            public void visitTypeElement(PsiTypeElement typeElement) {
                PsiClassType classType;
                PsiClass psiClass;
                super.visitTypeElement(typeElement);
                if (typeElement.getType() instanceof PsiClassType && (psiClass = (classType = (PsiClassType)typeElement.getType()).resolve()) instanceof PsiTypeParameter) {
                    this.checkReplaceTypeParameter((PsiElement)typeElement, (PsiTypeParameter)psiClass);
                }
            }

            private void checkReplaceTypeParameter(PsiElement element, PsiTypeParameter target) {
                PsiClass containingClass = method.getContainingClass();
                PsiTypeParameter[] psiTypeParameters = containingClass.getTypeParameters();
                for (int i = 0; i < psiTypeParameters.length; ++i) {
                    if (psiTypeParameters[i] != target) continue;
                    PsiType substType = substitutedParameters[i];
                    if (substType == null) {
                        substType = PsiType.getJavaLangObject((PsiManager)element.getManager(), (GlobalSearchScope)ProjectScope.getAllScope((Project)element.getProject()));
                    }
                    if (element instanceof PsiJavaCodeReferenceElement) {
                        LOG.assertTrue(substType instanceof PsiClassType);
                        elementsToReplace.put(element, InlineToAnonymousConstructorProcessor.this.myElementFactory.createReferenceElementByType((PsiClassType)substType));
                        continue;
                    }
                    elementsToReplace.put(element, InlineToAnonymousConstructorProcessor.this.myElementFactory.createTypeElement(substType));
                }
            }
        });
        RefactoringUtil.replaceElementsWithMap((PsiElement)method, elementsToReplace);
    }
}

