/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.introduceparameterobject;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationParameterList;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.codeStyle.VariableKind;
import com.intellij.psi.javadoc.PsiDocComment;
import com.intellij.refactoring.introduceparameterobject.ParameterSpec;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.NonNls;

class ParameterObjectBuilder {
    private String className = null;
    private String packageName = null;
    private final List<ParameterSpec> fields = new ArrayList<ParameterSpec>(5);
    private final List<PsiTypeParameter> typeParams = new ArrayList<PsiTypeParameter>();
    private Project myProject;
    private JavaCodeStyleManager myJavaCodeStyleManager;
    private String myVisibility;

    ParameterObjectBuilder() {
    }

    public void setClassName(String className) {
        this.className = className;
    }

    public void setPackageName(String packageName) {
        this.packageName = packageName;
    }

    public void addField(PsiParameter variable, String name, PsiType type, boolean setterRequired) {
        ParameterSpec field = new ParameterSpec(variable, name, type, setterRequired);
        this.fields.add(field);
    }

    public void setTypeArguments(List<PsiTypeParameter> typeParams) {
        this.typeParams.clear();
        this.typeParams.addAll(typeParams);
    }

    public void setProject(Project project) {
        this.myProject = project;
        this.myJavaCodeStyleManager = JavaCodeStyleManager.getInstance((Project)this.myProject);
    }

    public String buildBeanClass() {
        StringBuffer out = new StringBuffer(1024);
        if (this.packageName.length() > 0) {
            out.append("package " + this.packageName + ';');
        }
        out.append('\n');
        out.append(this.myVisibility + " class " + this.className);
        if (!this.typeParams.isEmpty()) {
            out.append('<');
            boolean first = true;
            for (PsiTypeParameter typeParam : this.typeParams) {
                if (!first) {
                    out.append(',');
                }
                out.append(typeParam.getText());
                first = false;
            }
            out.append('>');
        }
        out.append('\n');
        out.append('{');
        this.outputFields(out);
        this.outputConstructor(out);
        this.outputGetters(out);
        this.outputSetters(out);
        out.append("}\n");
        return out.toString();
    }

    private void outputSetters(StringBuffer out) {
        for (ParameterSpec field : this.fields) {
            this.outputSetter(field, out);
        }
    }

    private void outputGetters(StringBuffer out) {
        for (ParameterSpec field : this.fields) {
            this.outputGetter(field, out);
        }
    }

    private void outputFields(StringBuffer out) {
        for (ParameterSpec field : this.fields) {
            this.outputField(field, out);
        }
    }

    private void outputSetter(ParameterSpec field, @NonNls StringBuffer out) {
        if (!field.isSetterRequired()) {
            return;
        }
        PsiParameter parameter = field.getParameter();
        PsiType type = field.getType();
        String typeText = parameter.isVarArgs() ? ((PsiArrayType)type).getComponentType().getCanonicalText() + "..." : type.getCanonicalText();
        String name = this.calculateStrippedName(field.getName());
        String capitalizedName = StringUtil.capitalize((String)name);
        String parameterName = this.myJavaCodeStyleManager.propertyNameToVariableName(name, VariableKind.PARAMETER);
        out.append("\tpublic void set" + capitalizedName + '(');
        this.outputAnnotationString(parameter, out);
        out.append(CodeStyleSettingsManager.getSettings((Project)this.myProject).GENERATE_FINAL_PARAMETERS ? "final " : "");
        out.append(' ' + typeText + ' ' + parameterName + ")\n");
        out.append("\t{\n");
        String fieldName = this.myJavaCodeStyleManager.propertyNameToVariableName(name, VariableKind.FIELD);
        ParameterObjectBuilder.generateFieldAssignment(out, parameterName, fieldName);
        out.append("\t}\n");
    }

    private static void generateFieldAssignment(StringBuffer out, String parameterName, String fieldName) {
        if (fieldName.equals(parameterName)) {
            out.append("\t\tthis." + fieldName + " = " + parameterName + ";\n");
        } else {
            out.append("\t\t" + fieldName + " = " + parameterName + ";\n");
        }
    }

    @NonNls
    private String calculateStrippedName(String name) {
        return this.myJavaCodeStyleManager.variableNameToPropertyName(name, VariableKind.PARAMETER);
    }

    private void outputGetter(ParameterSpec field, @NonNls StringBuffer out) {
        PsiParameter parameter = field.getParameter();
        PsiType type = field.getType();
        String typeText = parameter.isVarArgs() ? ((PsiArrayType)type).getComponentType().getCanonicalText() + "[]" : type.getCanonicalText();
        String name = this.calculateStrippedName(field.getName());
        String capitalizedName = StringUtil.capitalize((String)name);
        if (PsiType.BOOLEAN.equals(type)) {
            out.append('\t');
            this.outputAnnotationString(parameter, out);
            out.append(" public " + typeText + " is" + capitalizedName + "()\n");
        } else {
            out.append('\t');
            this.outputAnnotationString(parameter, out);
            out.append(" public " + typeText + " get" + capitalizedName + "()\n");
        }
        out.append("\t{\n");
        String fieldName = this.myJavaCodeStyleManager.propertyNameToVariableName(name, VariableKind.FIELD);
        out.append("\t\treturn " + fieldName + ";\n");
        out.append("\t}\n");
    }

    private void outputConstructor(@NonNls StringBuffer out) {
        out.append("\t" + this.myVisibility + " " + this.className + '(');
        Iterator<ParameterSpec> iterator = this.fields.iterator();
        while (iterator.hasNext()) {
            ParameterSpec field = iterator.next();
            PsiParameter parameter = field.getParameter();
            this.outputAnnotationString(parameter, out);
            out.append(CodeStyleSettingsManager.getSettings((Project)this.myProject).GENERATE_FINAL_PARAMETERS ? " final " : "");
            PsiType type = field.getType();
            String typeText = parameter.isVarArgs() ? ((PsiArrayType)type).getComponentType().getCanonicalText() + "..." : type.getCanonicalText();
            String name = this.calculateStrippedName(field.getName());
            String parameterName = this.myJavaCodeStyleManager.propertyNameToVariableName(name, VariableKind.PARAMETER);
            out.append(' ' + typeText + ' ' + parameterName);
            if (!iterator.hasNext()) continue;
            out.append(", ");
        }
        out.append(")\n");
        out.append("\t{\n");
        for (ParameterSpec field : this.fields) {
            String name = this.calculateStrippedName(field.getName());
            String fieldName = this.myJavaCodeStyleManager.propertyNameToVariableName(name, VariableKind.FIELD);
            String parameterName = this.myJavaCodeStyleManager.propertyNameToVariableName(name, VariableKind.PARAMETER);
            ParameterObjectBuilder.generateFieldAssignment(out, parameterName, fieldName);
        }
        out.append("\t}\n");
    }

    private void outputField(ParameterSpec field, StringBuffer out) {
        String typeText;
        PsiParameter parameter = field.getParameter();
        PsiDocComment docComment = ParameterObjectBuilder.getJavadocForVariable((PsiVariable)parameter);
        if (docComment != null) {
            out.append(docComment.getText());
            out.append('\n');
        }
        PsiType type = field.getType();
        if (parameter.isVarArgs()) {
            PsiType componentType = ((PsiArrayType)type).getComponentType();
            typeText = componentType.getCanonicalText() + "[]";
        } else {
            typeText = type.getCanonicalText();
        }
        String name = this.calculateStrippedName(field.getName());
        String modifierString = "private ";
        if (!field.isSetterRequired()) {
            modifierString = modifierString + "final ";
        }
        this.outputAnnotationString(parameter, out);
        out.append('\t' + modifierString + typeText + ' ' + this.myJavaCodeStyleManager.propertyNameToVariableName(name, VariableKind.FIELD) + ";\n");
    }

    private void outputAnnotationString(PsiParameter parameter, StringBuffer out) {
        PsiAnnotation[] annotations;
        PsiModifierList modifierList = parameter.getModifierList();
        for (PsiAnnotation annotation : annotations = modifierList.getAnnotations()) {
            PsiClass annotationClass;
            PsiJavaCodeReferenceElement reference = annotation.getNameReferenceElement();
            if (reference == null || (annotationClass = (PsiClass)reference.resolve()) == null) continue;
            PsiAnnotationParameterList parameterList = annotation.getParameterList();
            String annotationText = '@' + annotationClass.getQualifiedName() + parameterList.getText();
            out.append(annotationText);
        }
    }

    private static PsiDocComment getJavadocForVariable(PsiVariable variable) {
        PsiElement[] children;
        for (PsiElement child : children = variable.getChildren()) {
            if (!(child instanceof PsiDocComment)) continue;
            return (PsiDocComment)child;
        }
        return null;
    }

    public void setVisibility(String visibility) {
        this.myVisibility = visibility;
    }
}

