/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.memberPullUp;

import com.intellij.openapi.help.HelpManager;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.refactoring.JavaRefactoringSettings;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.classMembers.MemberInfoChange;
import com.intellij.refactoring.memberPullUp.JavaPullUpHandler;
import com.intellij.refactoring.memberPullUp.PullUpHelper;
import com.intellij.refactoring.ui.ClassCellRenderer;
import com.intellij.refactoring.ui.DocCommentPanel;
import com.intellij.refactoring.ui.MemberSelectionPanel;
import com.intellij.refactoring.ui.RefactoringDialog;
import com.intellij.refactoring.util.DocCommentPolicy;
import com.intellij.refactoring.util.RefactoringHierarchyUtil;
import com.intellij.refactoring.util.classMembers.InterfaceContainmentVerifier;
import com.intellij.refactoring.util.classMembers.MemberInfo;
import com.intellij.refactoring.util.classMembers.MemberInfoStorage;
import com.intellij.refactoring.util.classMembers.UsesAndInterfacesDependencyMemberInfoModel;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.usageView.UsageViewUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;

public class PullUpDialog
extends RefactoringDialog {
    private final Callback myCallback;
    private MemberSelectionPanel myMemberSelectionPanel;
    private MyMemberInfoModel myMemberInfoModel;
    private final PsiClass myClass;
    private final List<PsiClass> mySuperClasses;
    private final MemberInfoStorage myMemberInfoStorage;
    private List<MemberInfo> myMemberInfos;
    private DocCommentPanel myJavaDocPanel;
    private JComboBox myClassCombo;
    private final InterfaceContainmentVerifier myInterfaceContainmentVerifier = new InterfaceContainmentVerifier(){

        @Override
        public boolean checkedInterfacesContain(PsiMethod psiMethod) {
            return PullUpHelper.checkedInterfacesContain(PullUpDialog.this.myMemberInfos, psiMethod);
        }
    };

    public PullUpDialog(Project project, PsiClass aClass, List<PsiClass> superClasses, MemberInfoStorage memberInfoStorage, Callback callback) {
        super(project, true);
        this.myClass = aClass;
        this.mySuperClasses = superClasses;
        this.myMemberInfoStorage = memberInfoStorage;
        this.myMemberInfos = this.myMemberInfoStorage.getClassMemberInfos(aClass);
        this.myCallback = callback;
        this.setTitle(JavaPullUpHandler.REFACTORING_NAME);
        this.init();
    }

    public PsiClass getSuperClass() {
        if (this.myClassCombo != null) {
            return (PsiClass)this.myClassCombo.getSelectedItem();
        }
        return null;
    }

    public int getJavaDocPolicy() {
        return this.myJavaDocPanel.getPolicy();
    }

    public MemberInfo[] getSelectedMemberInfos() {
        ArrayList<MemberInfo> list = new ArrayList<MemberInfo>(this.myMemberInfos.size());
        for (MemberInfo info : this.myMemberInfos) {
            if (!info.isChecked() || !this.myMemberInfoModel.isMemberEnabled(info)) continue;
            list.add(info);
        }
        return list.toArray(new MemberInfo[list.size()]);
    }

    protected String getDimensionServiceKey() {
        return "#com.intellij.refactoring.memberPullUp.PullUpDialog";
    }

    InterfaceContainmentVerifier getContainmentVerifier() {
        return this.myInterfaceContainmentVerifier;
    }

    protected JComponent createNorthPanel() {
        JPanel panel = new JPanel();
        panel.setBorder(IdeBorderFactory.createBorder());
        panel.setLayout(new GridBagLayout());
        GridBagConstraints gbConstraints = new GridBagConstraints();
        gbConstraints.insets = new Insets(4, 8, 4, 8);
        gbConstraints.weighty = 1.0;
        gbConstraints.weightx = 1.0;
        gbConstraints.gridy = 0;
        gbConstraints.gridwidth = 0;
        gbConstraints.fill = 1;
        gbConstraints.anchor = 17;
        JLabel classComboLabel = new JLabel();
        panel.add((Component)classComboLabel, gbConstraints);
        this.myClassCombo = new JComboBox<Object>(this.mySuperClasses.toArray());
        this.myClassCombo.setRenderer(new ClassCellRenderer());
        classComboLabel.setText(RefactoringBundle.message((String)"pull.up.members.to", (Object[])new Object[]{UsageViewUtil.getLongName((PsiElement)this.myClass)}));
        classComboLabel.setLabelFor(this.myClassCombo);
        PsiClass nearestBase = RefactoringHierarchyUtil.getNearestBaseClass(this.myClass, false);
        int indexToSelect = 0;
        if (nearestBase != null) {
            indexToSelect = this.mySuperClasses.indexOf(nearestBase);
        }
        this.myClassCombo.setSelectedIndex(indexToSelect);
        this.myClassCombo.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    PullUpDialog.this.updateMemberInfo();
                    if (PullUpDialog.this.myMemberSelectionPanel != null) {
                        PullUpDialog.this.myMemberInfoModel.setSuperClass(PullUpDialog.this.getSuperClass());
                        PullUpDialog.this.myMemberSelectionPanel.getTable().setMemberInfos(PullUpDialog.this.myMemberInfos);
                        PullUpDialog.this.myMemberSelectionPanel.getTable().fireExternalDataChange();
                    }
                }
            }
        });
        ++gbConstraints.gridy;
        panel.add((Component)this.myClassCombo, gbConstraints);
        return panel;
    }

    protected void doHelpAction() {
        HelpManager.getInstance().invokeHelp("refactoring.pullMembersUp");
    }

    private void updateMemberInfo() {
        PsiClass targetClass = (PsiClass)this.myClassCombo.getSelectedItem();
        this.myMemberInfos = this.myMemberInfoStorage.getMemberInfosList(targetClass);
    }

    @Override
    protected void doAction() {
        if (!this.myCallback.checkConflicts(this)) {
            return;
        }
        JavaRefactoringSettings.getInstance().PULL_UP_MEMBERS_JAVADOC = this.myJavaDocPanel.getPolicy();
        this.invokeRefactoring(new PullUpHelper(this.myClass, this.getSuperClass(), this.getSelectedMemberInfos(), new DocCommentPolicy(this.getJavaDocPolicy())));
        this.close(0);
    }

    protected JComponent createCenterPanel() {
        JPanel panel = new JPanel(new BorderLayout());
        this.myMemberSelectionPanel = new MemberSelectionPanel(RefactoringBundle.message((String)"members.to.be.pulled.up"), this.myMemberInfos, RefactoringBundle.message((String)"make.abstract"));
        this.myMemberInfoModel = new MyMemberInfoModel();
        this.myMemberInfoModel.memberInfoChanged(new MemberInfoChange(this.myMemberInfos));
        this.myMemberSelectionPanel.getTable().setMemberInfoModel(this.myMemberInfoModel);
        this.myMemberSelectionPanel.getTable().addMemberInfoChangeListener(this.myMemberInfoModel);
        panel.add((Component)this.myMemberSelectionPanel, "Center");
        this.myJavaDocPanel = new DocCommentPanel(RefactoringBundle.message((String)"javadoc.for.abstracts"));
        this.myJavaDocPanel.setPolicy(JavaRefactoringSettings.getInstance().PULL_UP_MEMBERS_JAVADOC);
        panel.add((Component)this.myJavaDocPanel, "East");
        return panel;
    }

    private class MyMemberInfoModel
    extends UsesAndInterfacesDependencyMemberInfoModel {
        public MyMemberInfoModel() {
            super(PullUpDialog.this.myClass, PullUpDialog.this.getSuperClass(), false, PullUpDialog.this.myInterfaceContainmentVerifier);
        }

        @Override
        public boolean isMemberEnabled(MemberInfo member) {
            PsiClass currentSuperClass = PullUpDialog.this.getSuperClass();
            if (currentSuperClass == null) {
                return true;
            }
            if (PullUpDialog.this.myMemberInfoStorage.getDuplicatedMemberInfos(currentSuperClass).contains((Object)member)) {
                return false;
            }
            if (PullUpDialog.this.myMemberInfoStorage.getExtending(currentSuperClass).contains(member.getMember())) {
                return false;
            }
            if (!currentSuperClass.isInterface()) {
                return true;
            }
            PsiElement element = member.getMember();
            if (element instanceof PsiClass && ((PsiClass)element).isInterface()) {
                return true;
            }
            if (element instanceof PsiField) {
                return ((PsiModifierListOwner)element).hasModifierProperty("static");
            }
            if (element instanceof PsiMethod) {
                return !((PsiModifierListOwner)element).hasModifierProperty("static");
            }
            return true;
        }

        @Override
        public boolean isAbstractEnabled(MemberInfo member) {
            PsiClass currentSuperClass = PullUpDialog.this.getSuperClass();
            return currentSuperClass == null || !currentSuperClass.isInterface();
        }

        @Override
        public boolean isAbstractWhenDisabled(MemberInfo member) {
            PsiClass currentSuperClass = PullUpDialog.this.getSuperClass();
            if (currentSuperClass == null) {
                return false;
            }
            return currentSuperClass.isInterface() && member.getMember() instanceof PsiMethod;
        }

        @Override
        public int checkForProblems(@NotNull MemberInfo member) {
            if (member == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/refactoring/memberPullUp/PullUpDialog$MyMemberInfoModel.checkForProblems must not be null");
            }
            if (member.isChecked()) {
                return 0;
            }
            PsiClass currentSuperClass = PullUpDialog.this.getSuperClass();
            if (currentSuperClass != null && currentSuperClass.isInterface()) {
                PsiElement element = member.getMember();
                if (element instanceof PsiModifierListOwner && ((PsiModifierListOwner)element).hasModifierProperty("static")) {
                    return super.checkForProblems(member);
                }
                return 0;
            }
            return super.checkForProblems(member);
        }

        @Override
        public Boolean isFixedAbstract(MemberInfo member) {
            return Boolean.TRUE;
        }
    }

    public static interface Callback {
        public boolean checkConflicts(PullUpDialog var1);
    }
}

