/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.rename.naming;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.refactoring.JavaRefactoringSettings;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.rename.naming.AutomaticParametersRenamer;
import com.intellij.refactoring.rename.naming.AutomaticRenamer;
import com.intellij.refactoring.rename.naming.AutomaticRenamerFactory;
import com.intellij.usageView.UsageInfo;
import java.util.Collection;

public class AutomaticParametersRenamerFactory
implements AutomaticRenamerFactory {
    @Override
    public boolean isApplicable(PsiElement element) {
        return element instanceof PsiParameter && ((PsiParameter)element).getDeclarationScope() instanceof PsiMethod;
    }

    @Override
    public String getOptionName() {
        return RefactoringBundle.message((String)"rename.parameters.hierarchy");
    }

    @Override
    public boolean isEnabled() {
        return JavaRefactoringSettings.getInstance().isRenameParameterInHierarchy();
    }

    @Override
    public void setEnabled(boolean enabled) {
        JavaRefactoringSettings.getInstance().setRenameParameterInHierarchy(enabled);
    }

    @Override
    public AutomaticRenamer createRenamer(PsiElement element, String newName, Collection<UsageInfo> usages) {
        return new AutomaticParametersRenamer((PsiParameter)element, newName);
    }
}

