/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.ui;

import com.intellij.refactoring.RefactoringBundle;
import com.intellij.ui.IdeBorderFactory;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.EventListener;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

public class VisibilityPanel
extends JPanel {
    private JRadioButton myRbAsIs;
    private JRadioButton myRbEscalate;
    private final JRadioButton myRbPrivate;
    private final JRadioButton myRbProtected;
    private final JRadioButton myRbPackageLocal;
    private final JRadioButton myRbPublic;

    public VisibilityPanel(boolean hasAsIs, boolean hasEscalate) {
        this.setBorder(IdeBorderFactory.createTitledBorder((String)RefactoringBundle.message((String)"visibility.border.title")));
        this.setLayout(new BoxLayout(this, 1));
        ButtonGroup bg = new ButtonGroup();
        ItemListener listener = new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    VisibilityPanel.this.fireStateChanged();
                }
            }
        };
        if (hasEscalate) {
            this.myRbEscalate = new JRadioButton();
            this.myRbEscalate.setText(RefactoringBundle.getEscalateVisibility());
            this.myRbEscalate.addItemListener(listener);
            this.add(this.myRbEscalate);
            bg.add(this.myRbEscalate);
        }
        if (hasAsIs) {
            this.myRbAsIs = new JRadioButton();
            this.myRbAsIs.setText(RefactoringBundle.getVisibilityAsIs());
            this.myRbAsIs.addItemListener(listener);
            this.add(this.myRbAsIs);
            bg.add(this.myRbAsIs);
        }
        this.myRbPrivate = new JRadioButton();
        this.myRbPrivate.setText(RefactoringBundle.getVisibilityPrivate());
        this.myRbPrivate.addItemListener(listener);
        this.myRbPrivate.setFocusable(false);
        this.add(this.myRbPrivate);
        bg.add(this.myRbPrivate);
        this.myRbPackageLocal = new JRadioButton();
        this.myRbPackageLocal.setText(RefactoringBundle.getVisibilityPackageLocal());
        this.myRbPackageLocal.addItemListener(listener);
        this.myRbPackageLocal.setFocusable(false);
        this.add(this.myRbPackageLocal);
        bg.add(this.myRbPackageLocal);
        this.myRbProtected = new JRadioButton();
        this.myRbProtected.setText(RefactoringBundle.getVisibilityProtected());
        this.myRbProtected.addItemListener(listener);
        this.myRbProtected.setFocusable(false);
        this.add(this.myRbProtected);
        bg.add(this.myRbProtected);
        this.myRbPublic = new JRadioButton();
        this.myRbPublic.setText(RefactoringBundle.getVisibilityPublic());
        this.myRbPublic.addItemListener(listener);
        this.myRbPublic.setFocusable(false);
        this.add(this.myRbPublic);
        bg.add(this.myRbPublic);
    }

    public String getVisibility() {
        if (this.myRbPublic.isSelected()) {
            return "public";
        }
        if (this.myRbPackageLocal.isSelected()) {
            return "packageLocal";
        }
        if (this.myRbProtected.isSelected()) {
            return "protected";
        }
        if (this.myRbPrivate.isSelected()) {
            return "private";
        }
        if (this.myRbEscalate != null && this.myRbEscalate.isSelected()) {
            return "EscalateVisible";
        }
        return null;
    }

    public void setVisibility(String visibility) {
        if ("public".equals(visibility)) {
            this.myRbPublic.setSelected(true);
        } else if ("protected".equals(visibility)) {
            this.myRbProtected.setSelected(true);
        } else if ("packageLocal".equals(visibility)) {
            this.myRbPackageLocal.setSelected(true);
        } else if ("private".equals(visibility)) {
            this.myRbPrivate.setSelected(true);
        } else if (this.myRbEscalate != null) {
            this.myRbEscalate.setSelected(true);
        } else if (this.myRbAsIs != null) {
            this.myRbAsIs.setSelected(true);
        }
    }

    public void disableAllButPublic() {
        this.myRbPrivate.setEnabled(false);
        this.myRbProtected.setEnabled(false);
        this.myRbPackageLocal.setEnabled(false);
        if (this.myRbEscalate != null) {
            this.myRbEscalate.setEnabled(false);
        }
        if (this.myRbAsIs != null) {
            this.myRbAsIs.setEnabled(false);
        }
        this.myRbPublic.setEnabled(true);
        this.myRbPublic.setSelected(true);
    }

    public void addStateChangedListener(StateChanged l) {
        this.listenerList.add(StateChanged.class, l);
    }

    private void fireStateChanged() {
        Object[] list;
        for (Object obj : list = this.listenerList.getListenerList()) {
            if (!(obj instanceof StateChanged)) continue;
            ((StateChanged)obj).visibilityChanged();
        }
    }

    public static interface StateChanged
    extends EventListener {
        public void visibilityChanged();
    }
}

