/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework;

import com.intellij.ide.DataManager;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.editor.actionSystem.EditorActionManager;
import com.intellij.openapi.editor.actionSystem.TypedAction;
import junit.framework.Assert;

public class EditorTestUtil {
    public static final char BACKSPACE_FAKE_CHAR = '\uffff';
    public static final char SMART_ENTER_FAKE_CHAR = '\ufffe';

    public static void performTypingAction(Editor editor, char c) {
        EditorActionManager actionManager = EditorActionManager.getInstance();
        if (c == '\uffff') {
            EditorActionHandler actionHandler = actionManager.getActionHandler("EditorBackSpace");
            actionHandler.execute(editor, DataManager.getInstance().getDataContext());
        } else if (c == '\ufffe') {
            EditorActionHandler actionHandler = actionManager.getActionHandler("EditorCompleteStatement");
            actionHandler.execute(editor, DataManager.getInstance().getDataContext());
        } else if (c == '\n') {
            EditorActionHandler actionHandler = actionManager.getActionHandler("EditorEnter");
            actionHandler.execute(editor, DataManager.getInstance().getDataContext());
        } else {
            TypedAction action = actionManager.getTypedAction();
            action.actionPerformed(editor, c, DataManager.getInstance().getDataContext());
        }
    }

    public static void performReferenceCopy(DataContext dataContext) {
        ActionManager actionManager = ActionManager.getInstance();
        AnAction action = actionManager.getAction("CopyReference");
        AnActionEvent event = new AnActionEvent(null, dataContext, "", action.getTemplatePresentation(), ActionManager.getInstance(), 0);
        action.update(event);
        Assert.assertTrue((boolean)event.getPresentation().isEnabled());
        action.actionPerformed(event);
    }

    public static void performPaste(Editor editor) {
        EditorActionManager actionManager = EditorActionManager.getInstance();
        EditorActionHandler actionHandler = actionManager.getActionHandler("EditorPaste");
        actionHandler.execute(editor, DataManager.getInstance().getDataContext());
    }
}

