/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testIntegration;

import com.intellij.codeInsight.TestUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.codeStyle.NameUtil;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.PsiShortNamesCache;
import com.intellij.testIntegration.TestFinder;
import com.intellij.testIntegration.TestIntegrationUtils;
import com.intellij.util.containers.HashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;

public class JavaTestFinder
implements TestFinder {
    public PsiClass findSourceElement(PsiElement element) {
        return TestIntegrationUtils.findOuterClass(element);
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public Collection<PsiElement> findClassesForTest(PsiElement element) {
        Collection<Object> collection;
        PsiClass klass = this.findSourceElement(element);
        if (klass == null) {
            collection = Collections.emptySet();
            if (collection == null) throw new IllegalStateException("@NotNull method com/intellij/testIntegration/JavaTestFinder.findClassesForTest must not return null");
            return collection;
        }
        Module module = JavaTestFinder.getModule(element);
        GlobalSearchScope scope = module != null ? GlobalSearchScope.moduleWithDependenciesScope((Module)module) : GlobalSearchScope.projectScope((Project)element.getProject());
        PsiShortNamesCache cache = JavaPsiFacade.getInstance((Project)element.getProject()).getShortNamesCache();
        ArrayList<Pair> classesWithWeights = new ArrayList<Pair>();
        for (Pair<String, Integer> eachNameWithWeight : this.collectPossibleClassNamesWithWeights(klass.getName())) {
            for (PsiClass eachClass : cache.getClassesByName((String)eachNameWithWeight.first, scope)) {
                if (!this.isTestSubjectClass(eachClass)) continue;
                classesWithWeights.add(new Pair((Object)eachClass, eachNameWithWeight.second));
            }
        }
        Collections.sort(classesWithWeights, new Comparator<Pair<PsiClass, Integer>>(){

            @Override
            public int compare(Pair<PsiClass, Integer> o1, Pair<PsiClass, Integer> o2) {
                int result = ((Integer)o2.second).compareTo((Integer)o1.second);
                if (result == 0) {
                    result = ((PsiClass)o1.first).getName().compareTo(((PsiClass)o2.first).getName());
                }
                return result;
            }
        });
        ArrayList<Object> result = new ArrayList<Object>();
        for (Pair each : classesWithWeights) {
            result.add(each.first);
        }
        collection = result;
        if (collection != null) return collection;
        throw new IllegalStateException("@NotNull method com/intellij/testIntegration/JavaTestFinder.findClassesForTest must not return null");
    }

    private boolean isTestSubjectClass(PsiClass klass) {
        return !klass.isEnum() && !klass.isInterface() && !klass.isAnnotationType() && !TestUtil.isTestClass((PsiClass)klass);
    }

    private List<Pair<String, Integer>> collectPossibleClassNamesWithWeights(String testName) {
        String[] words = NameUtil.splitNameIntoWords((String)testName);
        ArrayList<Pair<String, Integer>> result = new ArrayList<Pair<String, Integer>>();
        for (int from = 0; from < words.length; ++from) {
            for (int to = from; to < words.length; ++to) {
                result.add((Pair<String, Integer>)new Pair((Object)StringUtil.join((String[])words, (int)from, (int)(to + 1), (String)""), (Object)(words.length - from + to)));
            }
        }
        return result;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public Collection<PsiElement> findTestsForClass(PsiElement element) {
        Collection<Object> collection;
        PsiClass klass = this.findSourceElement(element);
        if (klass == null) {
            collection = Collections.emptySet();
            if (collection == null) throw new IllegalStateException("@NotNull method com/intellij/testIntegration/JavaTestFinder.findTestsForClass must not return null");
            return collection;
        }
        Module module = JavaTestFinder.getModule(element);
        GlobalSearchScope scope = module != null ? GlobalSearchScope.moduleWithDependentsScope((Module)module) : GlobalSearchScope.projectScope((Project)element.getProject());
        PsiShortNamesCache cache = JavaPsiFacade.getInstance((Project)element.getProject()).getShortNamesCache();
        String klassName = klass.getName();
        Pattern pattern = Pattern.compile(".*" + klassName + ".*");
        ArrayList<Pair> classesWithProximities = new ArrayList<Pair>();
        HashSet names = new HashSet();
        cache.getAllClassNames(names);
        for (String eachName : names) {
            if (!pattern.matcher(eachName).matches()) continue;
            for (PsiClass eachClass : cache.getClassesByName(eachName, scope)) {
                if (!TestUtil.isTestClass((PsiClass)eachClass)) continue;
                classesWithProximities.add(new Pair((Object)eachClass, (Object)this.calcTestNameProximity(klassName, eachName)));
            }
        }
        Collections.sort(classesWithProximities, new Comparator<Pair<PsiClass, Integer>>(){

            @Override
            public int compare(Pair<PsiClass, Integer> o1, Pair<PsiClass, Integer> o2) {
                int result = ((Integer)o1.second).compareTo((Integer)o2.second);
                if (result == 0) {
                    result = ((PsiClass)o1.first).getName().compareTo(((PsiClass)o2.first).getName());
                }
                return result;
            }
        });
        ArrayList<Object> result = new ArrayList<Object>();
        for (Pair each : classesWithProximities) {
            result.add(each.first);
        }
        collection = result;
        if (collection != null) return collection;
        throw new IllegalStateException("@NotNull method com/intellij/testIntegration/JavaTestFinder.findTestsForClass must not return null");
    }

    private Integer calcTestNameProximity(String klassName, String testName) {
        int posProximity = testName.indexOf(klassName);
        int sizeProximity = testName.length() - klassName.length();
        return posProximity + sizeProximity;
    }

    private static Module getModule(PsiElement element) {
        ProjectFileIndex index = ProjectRootManager.getInstance((Project)element.getProject()).getFileIndex();
        return index.getModuleForFile(element.getContainingFile().getVirtualFile());
    }

    public boolean isTest(PsiElement element) {
        return TestIntegrationUtils.isTest(element);
    }
}

