/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testIntegration.createTest;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.CodeInsightUtil;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightNamesUtil;
import com.intellij.codeInsight.intention.PsiElementBaseIntentionAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.fileEditor.ex.IdeDocumentHistory;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaDirectoryService;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.impl.source.PostprocessReformattingAspect;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.util.classMembers.MemberInfo;
import com.intellij.testIntegration.TestFrameworkDescriptor;
import com.intellij.testIntegration.TestIntegrationUtils;
import com.intellij.testIntegration.createTest.CreateTestDialog;
import com.intellij.util.IncorrectOperationException;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CreateTestAction
extends PsiElementBaseIntentionAction {
    @NotNull
    public String getText() {
        String string = CodeInsightBundle.message((String)"intention.create.test", (Object[])new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/testIntegration/createTest/CreateTestAction.getText must not return null");
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = this.getText();
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/testIntegration/createTest/CreateTestAction.getFamilyName must not return null");
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, @Nullable PsiElement element) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/testIntegration/createTest/CreateTestAction.isAvailable must not be null");
        }
        if (element == null) {
            return false;
        }
        if (((TestFrameworkDescriptor[])Extensions.getExtensions((ExtensionPointName)TestFrameworkDescriptor.EXTENSION_NAME)).length == 0) {
            return false;
        }
        if (!this.isAvailableForElement(element)) {
            return false;
        }
        PsiClass psiClass = this.getContainingClass(element);
        PsiJavaToken leftBrace = psiClass.getLBrace();
        if (leftBrace == null) {
            return false;
        }
        if (element.getTextOffset() >= leftBrace.getTextOffset()) {
            return false;
        }
        TextRange declarationRange = HighlightNamesUtil.getClassDeclarationTextRange(psiClass);
        return declarationRange.contains(element.getTextRange());
    }

    public boolean isAvailableForElement(PsiElement element) {
        if (element == null) {
            return false;
        }
        PsiClass psiClass = this.getContainingClass(element);
        if (psiClass == null) {
            return false;
        }
        Module srcModule = ModuleUtil.findModuleForPsiElement((PsiElement)psiClass);
        if (srcModule == null) {
            return false;
        }
        return !psiClass.isAnnotationType() && !psiClass.isInterface() && !psiClass.isEnum() && !(psiClass instanceof PsiAnonymousClass) && PsiTreeUtil.getParentOfType((PsiElement)psiClass, PsiClass.class) == null && !this.isUnderTestSources(psiClass);
    }

    private boolean isUnderTestSources(PsiClass c) {
        ProjectRootManager rm = ProjectRootManager.getInstance((Project)c.getProject());
        VirtualFile f = c.getContainingFile().getVirtualFile();
        if (f == null) {
            return false;
        }
        return rm.getFileIndex().isInTestSourceContent(f);
    }

    public void invoke(final @NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/testIntegration/createTest/CreateTestAction.invoke must not be null");
        }
        PsiElement element = file.findElementAt(editor.getCaretModel().getOffset());
        Module srcModule = ModuleUtil.findModuleForPsiElement((PsiElement)file);
        PsiClass srcClass = this.getContainingClass(element);
        if (srcClass == null) {
            return;
        }
        PsiDirectory srcDir = file.getContainingDirectory();
        PsiPackage srcPackage = JavaDirectoryService.getInstance().getPackage(srcDir);
        final CreateTestDialog d = new CreateTestDialog(project, this.getText(), srcClass, srcPackage, srcModule);
        d.show();
        if (!d.isOK()) {
            return;
        }
        PostprocessReformattingAspect.getInstance(project).postponeFormattingInside(new Runnable(){

            @Override
            public void run() {
                ApplicationManager.getApplication().runWriteAction(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            IdeDocumentHistory.getInstance(project).includeCurrentPlaceAsChangePlace();
                            PsiClass targetClass = JavaDirectoryService.getInstance().createClass(d.getTargetDirectory(), d.getClassName());
                            CreateTestAction.this.addSuperClass(targetClass, project, d.getSuperClassName());
                            Editor editor = CodeInsightUtil.positionCursor(project, targetClass.getContainingFile(), (PsiElement)targetClass.getLBrace());
                            CreateTestAction.this.addTestMethods(editor, targetClass, d.getSelectedTestFrameworkDescriptor(), d.getSelectedMethods(), d.shouldGeneratedBefore(), d.shouldGeneratedAfter());
                        }
                        catch (IncorrectOperationException e) {
                            CreateTestAction.this.showErrorLater(project, d.getClassName());
                        }
                    }
                });
            }
        });
    }

    private void showErrorLater(final Project project, final String targetClassName) {
        ApplicationManager.getApplication().invokeLater(new Runnable(){

            @Override
            public void run() {
                Messages.showErrorDialog((Project)project, (String)CodeInsightBundle.message((String)"intention.error.cannot.create.class.message", (Object[])new Object[]{targetClassName}), (String)CodeInsightBundle.message((String)"intention.error.cannot.create.class.title", (Object[])new Object[0]));
            }
        });
    }

    private void addSuperClass(PsiClass targetClass, Project project, String superClassName) throws IncorrectOperationException {
        if (superClassName == null) {
            return;
        }
        PsiElementFactory ef = JavaPsiFacade.getInstance((Project)project).getElementFactory();
        PsiClass superClass = this.findClass(project, superClassName);
        PsiJavaCodeReferenceElement superClassRef = superClass != null ? ef.createClassReferenceElement(superClass) : ef.createFQClassNameReferenceElement(superClassName, GlobalSearchScope.allScope((Project)project));
        targetClass.getExtendsList().add((PsiElement)superClassRef);
    }

    private PsiClass findClass(Project project, String fqName) {
        GlobalSearchScope scope = GlobalSearchScope.allScope((Project)project);
        return JavaPsiFacade.getInstance((Project)project).findClass(fqName, scope);
    }

    private void addTestMethods(Editor editor, PsiClass targetClass, TestFrameworkDescriptor descriptor, Collection<MemberInfo> methods, boolean generateBefore, boolean generateAfter) throws IncorrectOperationException {
        if (generateBefore) {
            this.generateMethod(TestIntegrationUtils.MethodKind.SET_UP, descriptor, targetClass, editor, "setUp");
        }
        if (generateAfter) {
            this.generateMethod(TestIntegrationUtils.MethodKind.TEAR_DOWN, descriptor, targetClass, editor, "tearUp");
        }
        for (MemberInfo m : methods) {
            this.generateMethod(TestIntegrationUtils.MethodKind.TEST, descriptor, targetClass, editor, ((PsiMember)m.getMember()).getName());
        }
    }

    private void generateMethod(TestIntegrationUtils.MethodKind methodKind, TestFrameworkDescriptor descriptor, PsiClass targetClass, Editor editor, String name) {
        PsiMethod method = (PsiMethod)targetClass.add((PsiElement)TestIntegrationUtils.createDummyMethod(targetClass.getProject()));
        PsiDocumentManager.getInstance((Project)targetClass.getProject()).doPostponedOperationsAndUnblockDocument(editor.getDocument());
        TestIntegrationUtils.runTestMethodTemplate(methodKind, descriptor, editor, targetClass, method, name, true);
    }

    private PsiClass getContainingClass(PsiElement element) {
        return (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)element, PsiClass.class, (boolean)false);
    }

    public boolean startInWriteAction() {
        return false;
    }
}

