/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.ui.CaptionPanel;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.popup.AbstractPopup;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import javax.swing.JComponent;

public class MoveComponentListener
extends MouseAdapter
implements MouseMotionListener {
    private final CaptionPanel myComponent;
    private Point myStartPoint = null;

    public MoveComponentListener(CaptionPanel component) {
        this.myComponent = component;
    }

    private void endOperation() {
        AbstractPopup.setDefaultCursor((JComponent)this.myComponent);
        this.myStartPoint = null;
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.myStartPoint = new RelativePoint(e).getScreenPoint();
        Point titleOffset = RelativePoint.getNorthWestOf((JComponent)this.myComponent).getScreenPoint();
        this.myStartPoint.x -= titleOffset.x;
        this.myStartPoint.y -= titleOffset.y;
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        this.endOperation();
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.endOperation();
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        if (e.isConsumed()) {
            return;
        }
        AbstractPopup.setDefaultCursor((JComponent)this.myComponent);
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        if (e.isConsumed()) {
            return;
        }
        AbstractPopup.setDefaultCursor((JComponent)this.myComponent);
        if (this.myStartPoint != null) {
            Point draggedTo = new RelativePoint(e).getScreenPoint();
            draggedTo.x -= this.myStartPoint.x;
            draggedTo.y -= this.myStartPoint.y;
            AbstractPopup.moveTo((JComponent)this.myComponent, draggedTo, null);
            e.consume();
        }
    }
}

