/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.debugger.extensions;

import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.projectView.TreeStructureProvider;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.ide.util.treeView.AbstractTreeStructureBase;
import com.intellij.ide.util.treeView.AlphaComparator;
import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.ui.Splitter;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.util.objectTree.ObjectNode;
import com.intellij.openapi.util.objectTree.ObjectTree;
import com.intellij.openapi.util.objectTree.ObjectTreeListener;
import com.intellij.openapi.vcs.history.TextTransferrable;
import com.intellij.ui.debugger.UiDebuggerExtension;
import com.intellij.ui.speedSearch.ElementFilter;
import com.intellij.ui.tabs.JBTabs;
import com.intellij.ui.tabs.TabInfo;
import com.intellij.ui.tabs.TabsListener;
import com.intellij.ui.tabs.impl.JBTabsImpl;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.ui.treeStructure.filtered.FilteringTreeBuilder;
import com.intellij.util.ui.update.MergingUpdateQueue;
import gnu.trove.THashSet;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.HeadlessException;
import java.awt.Toolkit;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.text.DefaultCaret;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DisposerDebugger
implements UiDebuggerExtension,
Disposable {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.ui.debugger.extensions.DisposerDebugger");
    private JComponent myComponent;
    private JBTabsImpl myTreeTabs;

    private void initUi() {
        this.myComponent = new JPanel();
        this.myTreeTabs = new JBTabsImpl(null, null, (Disposable)this);
        Splitter splitter = new Splitter(true);
        JBTabsImpl bottom = new JBTabsImpl(null, null, (Disposable)this);
        AllocationPanel allocations = new AllocationPanel((JBTabs)this.myTreeTabs);
        bottom.addTab(new TabInfo((JComponent)allocations).setText("Allocation")).setActions(allocations.getActions(), "unknown");
        splitter.setFirstComponent((JComponent)this.myTreeTabs);
        splitter.setSecondComponent((JComponent)bottom);
        this.myComponent.setLayout(new BorderLayout());
        this.myComponent.add((Component)splitter, "Center");
        JLabel countLabel = new JLabel("Total disposable count: " + Disposer.getTree().size());
        this.myComponent.add((Component)countLabel, "South");
        this.addTree(new DisposerTree(this), "All", false);
        this.addTree(new DisposerTree(this), "Watch", true);
    }

    private void addTree(DisposerTree tree, String name, boolean canClear) {
        DefaultActionGroup group = new DefaultActionGroup();
        if (canClear) {
            group.add((AnAction)new ClearAction(tree));
        }
        this.myTreeTabs.addTab(new TabInfo((JComponent)tree).setText(name).setObject((Object)tree).setActions((ActionGroup)group, "unknown"));
    }

    @Override
    public JComponent getComponent() {
        if (this.myComponent == null) {
            this.initUi();
        }
        return this.myComponent;
    }

    @Override
    public String getName() {
        return "Disposer";
    }

    public void dispose() {
    }

    @Override
    public void disposeUiResources() {
        this.myComponent = null;
    }

    private static class DisposerNode
    extends AbstractTreeNode<ObjectNode> {
        private DisposerTree myTree;

        private DisposerNode(DisposerTree tree, ObjectNode value) {
            super(null, (Object)value);
            this.myTree = tree;
        }

        /*
         * Enabled aggressive block sorting
         */
        @NotNull
        public Collection<? extends AbstractTreeNode> getChildren() {
            ArrayList<DisposerNode> arrayList;
            ObjectNode value = (ObjectNode)this.getValue();
            if (value != null) {
                Collection subnodes = value.getChildren();
                ArrayList<DisposerNode> children = new ArrayList<DisposerNode>(subnodes.size());
                Iterator iterator = subnodes.iterator();
                while (iterator.hasNext()) {
                    children.add(new DisposerNode(this.myTree, (ObjectNode)iterator.next()));
                }
                arrayList = children;
                if (arrayList == null) throw new IllegalStateException("@NotNull method com/intellij/ui/debugger/extensions/DisposerDebugger$DisposerNode.getChildren must not return null");
                return arrayList;
            }
            ObjectTree tree = Disposer.getTree();
            THashSet root = tree.getRootObjects();
            ArrayList<DisposerNode> children = new ArrayList<DisposerNode>(root.size());
            for (Disposable each : root) {
                children.add(new DisposerNode(this.myTree, tree.getNode((Object)each)));
            }
            arrayList = children;
            if (arrayList != null) return arrayList;
            throw new IllegalStateException("@NotNull method com/intellij/ui/debugger/extensions/DisposerDebugger$DisposerNode.getChildren must not return null");
        }

        @Nullable
        public Throwable getAllocation() {
            return this.getValue() != null ? ((ObjectNode)this.getValue()).getAllocation() : null;
        }

        protected boolean shouldUpdateData() {
            return true;
        }

        protected void update(PresentationData presentation) {
            if (this.getValue() != null) {
                String fqNameClass;
                String fqNameObject;
                int dogIndex;
                Object object = ((ObjectNode)this.getValue()).getObject();
                String classString = object.getClass().toString();
                String objectString = object.toString();
                presentation.setPresentableText(objectString);
                if (((ObjectNode)this.getValue()).getOwnModification() < this.myTree.myModificationToFilter) {
                    presentation.setForcedTextForeground(Color.gray);
                }
                if (objectString != null && (dogIndex = objectString.lastIndexOf("@")) >= 0 && (fqNameObject = objectString.substring(0, dogIndex)).equals(fqNameClass = classString.substring("class ".length()))) {
                    return;
                }
                presentation.setLocationString(classString);
            }
        }
    }

    private static class DisposerStructure
    extends AbstractTreeStructureBase {
        private DisposerNode myRoot;

        private DisposerStructure(DisposerTree tree) {
            super(null);
            this.myRoot = new DisposerNode(tree, null);
        }

        @Override
        public List<TreeStructureProvider> getProviders() {
            return null;
        }

        public Object getRootElement() {
            return this.myRoot;
        }

        public void commit() {
        }

        public boolean hasSomethingToCommit() {
            return false;
        }
    }

    private static class DisposerTree
    extends JPanel
    implements Disposable,
    ObjectTreeListener,
    ElementFilter<DisposerNode> {
        private FilteringTreeBuilder myTreeBuilder;
        private Tree myTree;
        private long myModificationToFilter = -1L;

        private DisposerTree(Disposable parent) {
            final DisposerStructure structure = new DisposerStructure(this);
            DefaultTreeModel model = new DefaultTreeModel(new DefaultMutableTreeNode());
            Tree tree = new Tree((TreeModel)model);
            tree.setRootVisible(false);
            tree.setShowsRootHandles(true);
            tree.getSelectionModel().setSelectionMode(1);
            this.myTreeBuilder = new FilteringTreeBuilder(null, tree, this, structure, AlphaComparator.INSTANCE){

                public boolean isAutoExpandNode(NodeDescriptor nodeDescriptor) {
                    return structure.getRootElement() == this.getOriginalNode(nodeDescriptor);
                }
            };
            this.myTreeBuilder.setFilteringMerge(200, MergingUpdateQueue.ANY_COMPONENT);
            Disposer.register((Disposable)this, (Disposable)this.myTreeBuilder);
            this.myTree = tree;
            this.setLayout(new BorderLayout());
            this.add((Component)new JScrollPane((Component)this.myTree), "Center");
            Disposer.getTree().addListener((ObjectTreeListener)this);
            Disposer.register((Disposable)parent, (Disposable)this);
        }

        public boolean shouldBeShowing(DisposerNode value) {
            return ((ObjectNode)value.getValue()).getModification() > this.myModificationToFilter;
        }

        public void objectRegistered(Object node) {
            this.queueUpdate();
        }

        public void objectExecuted(Object node) {
            this.queueUpdate();
        }

        private void queueUpdate() {
            this.myTreeBuilder.refilter();
        }

        public void dispose() {
            Disposer.getTree().removeListener((ObjectTreeListener)this);
        }

        @Nullable
        public DisposerNode getSelectedNode() {
            Set nodes = this.myTreeBuilder.getSelectedElements(DisposerNode.class);
            return nodes.size() == 1 ? (DisposerNode)((Object)nodes.iterator().next()) : null;
        }

        public Tree getTree() {
            return this.myTree;
        }

        public void clear() {
            this.myModificationToFilter = Disposer.getTree().getModification();
            this.myTreeBuilder.refilter();
        }
    }

    private static class AllocationPanel
    extends JPanel
    implements TreeSelectionListener {
        private JEditorPane myAllocation;
        private DefaultActionGroup myActions;
        private JBTabs myTreeTabs;

        private AllocationPanel(JBTabs treeTabs) {
            this.myTreeTabs = treeTabs;
            this.myAllocation = new JEditorPane();
            DefaultCaret caret = new DefaultCaret();
            this.myAllocation.setCaret(caret);
            caret.setUpdatePolicy(1);
            this.myAllocation.setEditable(false);
            this.setLayout(new BorderLayout());
            this.add((Component)new JScrollPane(this.myAllocation), "Center");
            treeTabs.addListener((TabsListener)new TabsListener.Adapter(){

                public void selectionChanged(TabInfo oldSelection, TabInfo newSelection) {
                    AllocationPanel.this.updateText();
                }

                public void beforeSelectionChanged(TabInfo oldSelection, TabInfo newSelection) {
                    AllocationPanel.this.removeListener(oldSelection);
                    AllocationPanel.this.addListener(newSelection);
                }
            });
            this.myActions = new DefaultActionGroup();
            this.myActions.add((AnAction)new CopyAllocationAction());
        }

        private void addListener(TabInfo info) {
            if (info == null) {
                return;
            }
            ((DisposerTree)info.getObject()).getTree().getSelectionModel().addTreeSelectionListener(this);
        }

        private void removeListener(TabInfo info) {
            if (info == null) {
                return;
            }
            ((DisposerTree)info.getObject()).getTree().getSelectionModel().removeTreeSelectionListener(this);
        }

        @Override
        public void valueChanged(TreeSelectionEvent e) {
            this.updateText();
        }

        private void updateText() {
            Throwable allocation;
            if (this.myTreeTabs.getSelectedInfo() == null) {
                return;
            }
            DisposerTree tree = (DisposerTree)this.myTreeTabs.getSelectedInfo().getObject();
            DisposerNode node = tree.getSelectedNode();
            if (node != null && (allocation = node.getAllocation()) != null) {
                StringWriter s = new StringWriter();
                PrintWriter writer = new PrintWriter(s);
                allocation.printStackTrace(writer);
                this.myAllocation.setText(s.toString());
                return;
            }
            this.myAllocation.setText(null);
        }

        public ActionGroup getActions() {
            return this.myActions;
        }

        private class CopyAllocationAction
        extends AnAction {
            public CopyAllocationAction() {
                super("Copy", "Copy allocation to clipboard", IconLoader.getIcon((String)"/actions/copy.png"));
            }

            public void update(AnActionEvent e) {
                e.getPresentation().setEnabled(AllocationPanel.this.myAllocation.getDocument().getLength() > 0);
            }

            public void actionPerformed(AnActionEvent e) {
                try {
                    Toolkit.getDefaultToolkit().getSystemClipboard().setContents(new TextTransferrable(AllocationPanel.this.myAllocation.getText(), AllocationPanel.this.myAllocation.getText()), null);
                }
                catch (HeadlessException e1) {
                    LOG.error((Throwable)e1);
                }
            }
        }
    }

    private class ClearAction
    extends AnAction {
        private DisposerTree myTree;

        private ClearAction(DisposerTree tree) {
            super("Clear");
            this.myTree = tree;
        }

        public void update(AnActionEvent e) {
            e.getPresentation().setIcon(IconLoader.getIcon((String)"/debugger/watch.png"));
        }

        public void actionPerformed(AnActionEvent e) {
            this.myTree.clear();
        }
    }
}

