/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.usageView;

import com.intellij.codeInsight.highlighting.HighlightUsagesDescriptionLocation;
import com.intellij.lang.findUsages.FindUsagesProvider;
import com.intellij.lang.findUsages.LanguageFindUsages;
import com.intellij.psi.ElementDescriptionLocation;
import com.intellij.psi.ElementDescriptionProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.meta.PsiPresentableMetaData;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlTag;
import com.intellij.usageView.UsageViewLongNameLocation;
import com.intellij.usageView.UsageViewShortNameLocation;
import org.jetbrains.annotations.NotNull;

public class XmlUsageViewDescriptionProvider
implements ElementDescriptionProvider {
    public String getElementDescription(@NotNull PsiElement element, @NotNull ElementDescriptionLocation location) {
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/usageView/XmlUsageViewDescriptionProvider.getElementDescription must not be null");
        }
        if (location == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/usageView/XmlUsageViewDescriptionProvider.getElementDescription must not be null");
        }
        if (location instanceof UsageViewShortNameLocation && element instanceof XmlAttributeValue) {
            return ((XmlAttributeValue)element).getValue();
        }
        if (location instanceof UsageViewLongNameLocation) {
            if (element instanceof XmlTag) {
                return ((XmlTag)element).getName();
            }
            if (element instanceof XmlAttributeValue) {
                return ((XmlAttributeValue)element).getValue();
            }
        }
        if (location instanceof HighlightUsagesDescriptionLocation) {
            if (element instanceof PsiPresentableMetaData) {
                return null;
            }
            if (element instanceof PsiFile) {
                return "File";
            }
            FindUsagesProvider provider = (FindUsagesProvider)LanguageFindUsages.INSTANCE.forLanguage(element.getLanguage());
            if (provider.canFindUsagesFor(element)) {
                return provider.getType(element);
            }
        }
        return null;
    }
}

