/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.fileIndex;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class FileIndexEntry {
    private final long myTimeStamp;

    public FileIndexEntry(long timestamp) {
        this.myTimeStamp = timestamp;
    }

    public FileIndexEntry(DataInputStream stream) throws IOException {
        this.myTimeStamp = stream.readLong();
    }

    public final long getTimeStamp() {
        return this.myTimeStamp;
    }

    public void write(DataOutputStream stream) throws IOException {
        stream.writeLong(this.myTimeStamp);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FileIndexEntry that = (FileIndexEntry)o;
        return this.myTimeStamp == that.myTimeStamp;
    }

    public int hashCode() {
        return (int)(this.myTimeStamp ^ this.myTimeStamp >>> 32);
    }
}

