/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing;

import java.util.Iterator;
import java.util.List;

public abstract class ValueContainer<Value> {
    private volatile boolean myNeedsCompacting = false;

    public abstract IntIterator getInputIdsIterator(Value var1);

    public abstract boolean isAssociated(Value var1, int var2);

    public abstract Iterator<Value> getValueIterator();

    public abstract int[] getInputIds(Value var1);

    public abstract List<Value> toValueList();

    public abstract int size();

    public final void forEach(ContainerAction<Value> action) {
        Iterator<Value> valueIterator = this.getValueIterator();
        while (valueIterator.hasNext()) {
            Value value = valueIterator.next();
            IntIterator intIterator = this.getInputIdsIterator(value);
            while (intIterator.hasNext()) {
                action.perform(intIterator.next(), value);
            }
        }
    }

    boolean needsCompacting() {
        return this.myNeedsCompacting;
    }

    void setNeedsCompacting(boolean value) {
        this.myNeedsCompacting = value;
    }

    public static interface ContainerAction<T> {
        public void perform(int var1, T var2);
    }

    static interface IntIterator {
        public boolean hasNext();

        public int next();

        public int size();
    }
}

