/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xml.impl;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.filters.ElementFilter;
import com.intellij.psi.meta.MetaDataRegistrar;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.containers.FactoryMap;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomFileDescription;
import com.intellij.util.xml.DomManager;
import com.intellij.util.xml.DomMetaData;
import gnu.trove.THashSet;
import java.util.Collection;
import java.util.Set;
import org.jetbrains.annotations.Nullable;

public class DomApplicationComponent {
    private final FactoryMap<String, Set<DomFileDescription>> myRootTagName2FileDescription = new FactoryMap<String, Set<DomFileDescription>>(){

        protected Set<DomFileDescription> create(String key) {
            return new THashSet();
        }
    };
    private final Set<DomFileDescription> myAcceptingOtherRootTagNamesDescriptions = new THashSet();

    public DomApplicationComponent() {
        for (DomFileDescription description : (DomFileDescription[])Extensions.getExtensions((ExtensionPointName)DomFileDescription.EP_NAME)) {
            this.registerFileDescription(description);
        }
        MetaDataRegistrar.getInstance().registerMetaData(new ElementFilter(){

            public boolean isAcceptable(Object element, PsiElement context) {
                XmlTag tag;
                DomElement domElement;
                if (element instanceof XmlTag && (domElement = DomManager.getDomManager((Project)(tag = (XmlTag)element).getProject()).getDomElement(tag)) != null) {
                    return domElement.getGenericInfo().getNameDomElement(domElement) != null;
                }
                return false;
            }

            public boolean isClassAcceptable(Class hintClass) {
                return XmlTag.class.isAssignableFrom(hintClass);
            }
        }, DomMetaData.class);
    }

    public static DomApplicationComponent getInstance() {
        return (DomApplicationComponent)ApplicationManager.getApplication().getComponent(DomApplicationComponent.class);
    }

    public final synchronized Set<DomFileDescription> getFileDescriptions(String rootTagName) {
        return (Set)this.myRootTagName2FileDescription.get((Object)rootTagName);
    }

    public final synchronized Set<DomFileDescription> getAcceptingOtherRootTagNameDescriptions() {
        return this.myAcceptingOtherRootTagNamesDescriptions;
    }

    public final synchronized void registerFileDescription(DomFileDescription description) {
        ((Set)this.myRootTagName2FileDescription.get((Object)description.getRootTagName())).add(description);
        if (description.acceptsOtherRootTagNames()) {
            this.myAcceptingOtherRootTagNamesDescriptions.add(description);
        }
    }

    @Nullable
    public final synchronized Set<DomFileDescription> getAllFileDescriptions() {
        THashSet set = new THashSet(this.myAcceptingOtherRootTagNamesDescriptions);
        for (Set descriptions : this.myRootTagName2FileDescription.values()) {
            set.addAll((Collection)descriptions);
        }
        return set;
    }

    @Nullable
    public final synchronized DomFileDescription findFileDescription(String className) {
        for (Set descriptions : this.myRootTagName2FileDescription.values()) {
            for (DomFileDescription description : descriptions) {
                if (!description.getClass().getName().equals(className)) continue;
                return description;
            }
        }
        for (DomFileDescription description : this.myAcceptingOtherRootTagNamesDescriptions) {
            if (!description.getClass().getName().equals(className)) continue;
            return description;
        }
        return null;
    }
}

