/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl;

import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.project.Project;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class XDebuggerHistoryManager {
    public static final int MAX_RECENT_EXPRESSIONS = 10;
    private final Map<String, LinkedList<String>> myRecentExpressions = new HashMap<String, LinkedList<String>>();

    public static XDebuggerHistoryManager getInstance(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/xdebugger/impl/XDebuggerHistoryManager.getInstance must not be null");
        }
        return (XDebuggerHistoryManager)ServiceManager.getService((Project)project, XDebuggerHistoryManager.class);
    }

    public void addRecentExpression(@NotNull @NonNls String id, @NotNull String expression) {
        if (id == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/xdebugger/impl/XDebuggerHistoryManager.addRecentExpression must not be null");
        }
        if (expression == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/xdebugger/impl/XDebuggerHistoryManager.addRecentExpression must not be null");
        }
        if (expression.trim().length() == 0) {
            return;
        }
        LinkedList<String> list = this.myRecentExpressions.get(id);
        if (list == null) {
            list = new LinkedList();
            this.myRecentExpressions.put(id, list);
        }
        if (list.size() == 10) {
            list.removeLast();
        }
        list.remove(expression);
        list.addFirst(expression);
    }

    public List<String> getRecentExpressions(@NonNls String id) {
        LinkedList<String> list = this.myRecentExpressions.get(id);
        return list != null ? list : Collections.emptyList();
    }
}

