/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.breakpoints;

import com.intellij.ide.startup.StartupManagerEx;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.event.DocumentAdapter;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.event.EditorEventMulticaster;
import com.intellij.openapi.editor.event.EditorMouseAdapter;
import com.intellij.openapi.editor.event.EditorMouseEvent;
import com.intellij.openapi.editor.event.EditorMouseEventArea;
import com.intellij.openapi.editor.event.EditorMouseListener;
import com.intellij.openapi.editor.markup.MarkupEditorFilterFactory;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.util.containers.BidirectionalMap;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.Update;
import com.intellij.xdebugger.XDebuggerManager;
import com.intellij.xdebugger.XDebuggerUtil;
import com.intellij.xdebugger.breakpoints.XBreakpoint;
import com.intellij.xdebugger.impl.breakpoints.XDependentBreakpointListener;
import com.intellij.xdebugger.impl.breakpoints.XDependentBreakpointManager;
import com.intellij.xdebugger.impl.breakpoints.XLineBreakpointImpl;
import gnu.trove.TIntHashSet;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class XLineBreakpointManager {
    private final BidirectionalMap<XLineBreakpointImpl, Document> myBreakpoints = new BidirectionalMap();
    private final MergingUpdateQueue myBreakpointsUpdateQueue;
    private final Project myProject;
    private final XDependentBreakpointManager myDependentBreakpointManager;
    private final StartupManagerEx myStartupManager;

    public XLineBreakpointManager(Project project, XDependentBreakpointManager dependentBreakpointManager, StartupManager startupManager) {
        this.myProject = project;
        this.myDependentBreakpointManager = dependentBreakpointManager;
        this.myStartupManager = (StartupManagerEx)startupManager;
        if (!this.myProject.isDefault()) {
            MyDocumentListener documentListener = new MyDocumentListener();
            MyEditorMouseListener editorMouseListener = new MyEditorMouseListener();
            EditorEventMulticaster editorEventMulticaster = EditorFactory.getInstance().getEventMulticaster();
            editorEventMulticaster.addDocumentListener((DocumentListener)documentListener, (Disposable)project);
            editorEventMulticaster.addEditorMouseListener((EditorMouseListener)editorMouseListener, (Disposable)project);
            final MyDependentBreakpointListener myDependentBreakpointListener = new MyDependentBreakpointListener();
            this.myDependentBreakpointManager.addListener(myDependentBreakpointListener);
            Disposer.register((Disposable)project, (Disposable)new Disposable(){

                public void dispose() {
                    XLineBreakpointManager.this.myDependentBreakpointManager.removeListener(myDependentBreakpointListener);
                }
            });
        }
        this.myBreakpointsUpdateQueue = new MergingUpdateQueue("XLine breakpoints", 300, true, null, (Disposable)project);
    }

    public void updateBreakpointsUI() {
        if (this.myProject.isDefault()) {
            return;
        }
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                for (XLineBreakpointImpl breakpoint : XLineBreakpointManager.this.myBreakpoints.keySet()) {
                    breakpoint.updateUI();
                }
            }
        };
        if (ApplicationManager.getApplication().isUnitTestMode() || this.myStartupManager.startupActivityPassed()) {
            runnable.run();
        } else {
            this.myStartupManager.registerPostStartupActivity(runnable);
        }
    }

    public void registerBreakpoint(XLineBreakpointImpl breakpoint, boolean initUI) {
        Document document;
        if (initUI) {
            breakpoint.updateUI();
        }
        if ((document = breakpoint.getDocument()) != null) {
            this.myBreakpoints.put((Object)breakpoint, (Object)document);
        }
    }

    public void unregisterBreakpoint(XLineBreakpointImpl breakpoint) {
        RangeHighlighter highlighter = breakpoint.getHighlighter();
        if (highlighter != null) {
            this.myBreakpoints.remove((Object)breakpoint);
        }
    }

    private void updateBreakpoints(Document document) {
        List breakpoints = this.myBreakpoints.getKeysByValue((Object)document);
        if (breakpoints == null) {
            return;
        }
        TIntHashSet lines = new TIntHashSet();
        final ArrayList<XLineBreakpointImpl> toRemove = new ArrayList<XLineBreakpointImpl>();
        for (XLineBreakpointImpl breakpoint : breakpoints) {
            breakpoint.updatePosition();
            if (breakpoint.isValid() && lines.add(breakpoint.getLine())) continue;
            toRemove.add(breakpoint);
        }
        new WriteAction(){

            protected void run(Result result) {
                for (XLineBreakpointImpl breakpoint : toRemove) {
                    XDebuggerManager.getInstance((Project)XLineBreakpointManager.this.myProject).getBreakpointManager().removeBreakpoint((XBreakpoint)breakpoint);
                }
            }
        }.execute();
    }

    public void breakpointChanged(XLineBreakpointImpl breakpoint) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        breakpoint.updateUI();
    }

    public void queueBreakpointUpdate(XBreakpoint<?> slave) {
        if (slave instanceof XLineBreakpointImpl) {
            this.queueBreakpointUpdate((XLineBreakpointImpl)slave);
        }
    }

    public void queueBreakpointUpdate(final @NotNull XLineBreakpointImpl<?> breakpoint) {
        if (breakpoint == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/xdebugger/impl/breakpoints/XLineBreakpointManager.queueBreakpointUpdate must not be null");
        }
        this.myBreakpointsUpdateQueue.queue(new Update(breakpoint){

            public void run() {
                breakpoint.updateUI();
            }
        });
    }

    public void queueAllBreakpointsUpdate() {
        this.myBreakpointsUpdateQueue.queue(new Update("all breakpoints"){

            public void run() {
                for (XLineBreakpointImpl breakpoint : XLineBreakpointManager.this.myBreakpoints.keySet()) {
                    breakpoint.updateUI();
                }
            }
        });
    }

    private class MyDependentBreakpointListener
    implements XDependentBreakpointListener {
        private MyDependentBreakpointListener() {
        }

        @Override
        public void dependencySet(XBreakpoint<?> slave, XBreakpoint<?> master) {
            XLineBreakpointManager.this.queueBreakpointUpdate(slave);
        }

        @Override
        public void dependencyCleared(XBreakpoint<?> breakpoint) {
            XLineBreakpointManager.this.queueBreakpointUpdate(breakpoint);
        }
    }

    private class MyEditorMouseListener
    extends EditorMouseAdapter {
        private MyEditorMouseListener() {
        }

        public void mouseClicked(EditorMouseEvent e) {
            final Editor editor = e.getEditor();
            final MouseEvent mouseEvent = e.getMouseEvent();
            if (mouseEvent.isPopupTrigger() || mouseEvent.getButton() != 1 || MarkupEditorFilterFactory.createIsDiffFilter().avaliableIn(editor) || e.getArea() != EditorMouseEventArea.LINE_MARKERS_AREA) {
                return;
            }
            PsiDocumentManager.getInstance((Project)XLineBreakpointManager.this.myProject).commitAndRunReadAction(new Runnable(){

                @Override
                public void run() {
                    final int line = editor.xyToLogicalPosition((Point)mouseEvent.getPoint()).line;
                    Document document = editor.getDocument();
                    final VirtualFile file = FileDocumentManager.getInstance().getFile(document);
                    if (line >= 0 && line < document.getLineCount() && file != null) {
                        ApplicationManager.getApplication().invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                if (!XLineBreakpointManager.this.myProject.isDisposed() && XLineBreakpointManager.this.myProject.isInitialized() && file.isValid()) {
                                    XDebuggerUtil.getInstance().toggleLineBreakpoint(XLineBreakpointManager.this.myProject, file, line);
                                }
                            }
                        });
                    }
                }
            });
        }
    }

    private class MyDocumentListener
    extends DocumentAdapter {
        private MyDocumentListener() {
        }

        public void documentChanged(DocumentEvent e) {
            final Document document = e.getDocument();
            List breakpoints = XLineBreakpointManager.this.myBreakpoints.getKeysByValue((Object)document);
            if (breakpoints != null && !breakpoints.isEmpty()) {
                XLineBreakpointManager.this.myBreakpointsUpdateQueue.queue(new Update(document){

                    public void run() {
                        XLineBreakpointManager.this.updateBreakpoints(document);
                    }
                });
            }
        }
    }
}

