/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xml.actions.xmlbeans;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiReference;
import com.intellij.psi.XmlRecursiveElementVisitor;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import com.intellij.psi.meta.PsiMetaData;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlDocument;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.xml.XmlElementDescriptor;
import com.intellij.xml.XmlNSDescriptor;
import com.intellij.xml.impl.schema.XmlNSDescriptorImpl;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.xmlbeans.SchemaType;
import org.apache.xmlbeans.SchemaTypeLoader;
import org.apache.xmlbeans.SchemaTypeSystem;
import org.apache.xmlbeans.XmlBeans;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlObject;
import org.apache.xmlbeans.XmlOptions;
import org.apache.xmlbeans.impl.tool.CommandLine;
import org.apache.xmlbeans.impl.xsd2inst.SampleXmlUtil;
import org.jetbrains.annotations.NotNull;

public class Xsd2InstanceUtils {
    public static String generate(String[] args) {
        HashSet<String> flags = new HashSet<String>();
        HashSet<String> opts = new HashSet<String>();
        flags.add("h");
        flags.add("help");
        flags.add("usage");
        flags.add("license");
        flags.add("version");
        flags.add("dl");
        flags.add("noupa");
        flags.add("nopvr");
        flags.add("partial");
        opts.add("name");
        CommandLine cl = new CommandLine(args, flags, opts);
        String[] badOpts = cl.getBadOpts();
        if (badOpts.length > 0) {
            throw new IllegalArgumentException("Unrecognized option: " + badOpts[0]);
        }
        boolean dl = cl.getOpt("dl") != null;
        boolean nopvr = cl.getOpt("nopvr") != null;
        boolean noupa = cl.getOpt("noupa") != null;
        File[] schemaFiles = cl.filesEndingWith(".xsd");
        String rootName = cl.getOpt("name");
        if (rootName == null) {
            throw new IllegalArgumentException("Required option \"-name\" must be present");
        }
        ArrayList<XmlObject> sdocs = new ArrayList<XmlObject>();
        for (int i = 0; i < schemaFiles.length; ++i) {
            try {
                sdocs.add(XmlObject.Factory.parse((File)schemaFiles[i], (XmlOptions)new XmlOptions().setLoadLineNumbers().setLoadMessageDigest()));
                continue;
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Can not load schema file: " + schemaFiles[i] + ": ");
            }
        }
        XmlObject[] schemas = sdocs.toArray(new XmlObject[sdocs.size()]);
        SchemaTypeSystem sts = null;
        if (schemas.length > 0) {
            ArrayList errors = new ArrayList();
            XmlOptions compileOptions = new XmlOptions();
            if (dl) {
                compileOptions.setCompileDownloadUrls();
            }
            if (nopvr) {
                compileOptions.setCompileNoPvrRule();
            }
            if (noupa) {
                compileOptions.setCompileNoUpaRule();
            }
            try {
                sts = XmlBeans.compileXsd((XmlObject[])schemas, (SchemaTypeLoader)XmlBeans.getBuiltinTypeSystem(), (XmlOptions)compileOptions);
            }
            catch (XmlException e) {
                String out = "Schema compilation errors: ";
                for (Object error : errors) {
                    out = out + "\n" + error;
                }
                throw new IllegalArgumentException(out);
            }
        }
        if (sts == null) {
            throw new IllegalArgumentException("No Schemas to process.");
        }
        SchemaType[] globalElems = sts.documentTypes();
        SchemaType elem = null;
        for (int i = 0; i < globalElems.length; ++i) {
            if (!rootName.equals(globalElems[i].getDocumentElementName().getLocalPart())) continue;
            elem = globalElems[i];
            break;
        }
        if (elem == null) {
            throw new IllegalArgumentException("Could not find a global element with name \"" + rootName + "\"");
        }
        return SampleXmlUtil.createSampleForType(elem);
    }

    public static XmlElementDescriptor getDescriptor(XmlTag tag, String elementName) {
        PsiMetaData metaData = tag.getMetaData();
        if (metaData instanceof XmlNSDescriptorImpl) {
            XmlNSDescriptorImpl nsDescriptor = (XmlNSDescriptorImpl)metaData;
            return nsDescriptor.getElementDescriptor(elementName, nsDescriptor.getDefaultNamespace());
        }
        return null;
    }

    public static List<String> addVariantsFromRootTag(XmlTag rootTag) {
        PsiMetaData metaData = rootTag.getMetaData();
        if (metaData instanceof XmlNSDescriptorImpl) {
            XmlElementDescriptor[] rootElementsDescriptors;
            XmlNSDescriptorImpl nsDescriptor = (XmlNSDescriptorImpl)metaData;
            ArrayList<String> elementDescriptors = new ArrayList<String>();
            for (XmlElementDescriptor e : rootElementsDescriptors = nsDescriptor.getRootElementsDescriptors((XmlDocument)PsiTreeUtil.getParentOfType((PsiElement)rootTag, XmlDocument.class))) {
                elementDescriptors.add(e.getName());
            }
            return elementDescriptors;
        }
        return Collections.emptyList();
    }

    public static String processAndSaveAllSchemas(@NotNull XmlFile file, final @NotNull Map<String, String> scannedToFileName, final @NotNull SchemaReferenceProcessor schemaReferenceProcessor) {
        if (file == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/xml/actions/xmlbeans/Xsd2InstanceUtils.processAndSaveAllSchemas must not be null");
        }
        if (scannedToFileName == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/xml/actions/xmlbeans/Xsd2InstanceUtils.processAndSaveAllSchemas must not be null");
        }
        if (schemaReferenceProcessor == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/xml/actions/xmlbeans/Xsd2InstanceUtils.processAndSaveAllSchemas must not be null");
        }
        String fileName = file.getName();
        String previous = scannedToFileName.get(fileName);
        if (previous != null) {
            return previous;
        }
        scannedToFileName.put(fileName, fileName);
        final StringBuilder result = new StringBuilder();
        file.acceptChildren((PsiElementVisitor)new XmlRecursiveElementVisitor(){

            public void visitElement(PsiElement psiElement) {
                super.visitElement(psiElement);
                if (psiElement instanceof LeafPsiElement) {
                    String text = psiElement.getText();
                    result.append(text);
                }
            }

            public void visitXmlAttribute(XmlAttribute xmlAttribute) {
                String s;
                PsiElement psiElement;
                PsiReference[] references;
                boolean replaced = false;
                if (xmlAttribute.isNamespaceDeclaration()) {
                    XmlNSDescriptor nsDescriptor;
                    replaced = true;
                    String value = xmlAttribute.getValue();
                    result.append(xmlAttribute.getText()).append(" ");
                    if (!scannedToFileName.containsKey(value) && (nsDescriptor = xmlAttribute.getParent().getNSDescriptor(value, true)) != null) {
                        Xsd2InstanceUtils.processAndSaveAllSchemas(nsDescriptor.getDescriptorFile(), scannedToFileName, schemaReferenceProcessor);
                    }
                } else if ("schemaLocation".equals(xmlAttribute.getName()) && (references = xmlAttribute.getValueElement().getReferences()).length > 0 && (psiElement = references[0].resolve()) instanceof XmlFile && (s = Xsd2InstanceUtils.processAndSaveAllSchemas((XmlFile)psiElement, scannedToFileName, schemaReferenceProcessor)) != null) {
                    result.append(xmlAttribute.getName()).append("='").append(s).append('\'');
                    replaced = true;
                }
                if (!replaced) {
                    result.append(xmlAttribute.getText());
                }
            }
        });
        schemaReferenceProcessor.processSchema(fileName, result.toString());
        return fileName;
    }

    public static interface SchemaReferenceProcessor {
        public void processSchema(String var1, String var2);
    }
}

