/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xml.index;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.Function;
import com.intellij.util.NullableFunction;
import com.intellij.util.indexing.AdditionalIndexedRootsScope;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.ID;
import com.intellij.xml.index.ResourceRelevance;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IndexedRelevantResource<K, V extends Comparable>
implements Comparable<IndexedRelevantResource<K, V>> {
    public static final Function<IndexedRelevantResource<String, String>, VirtualFile> MAPPING = new Function<IndexedRelevantResource<String, String>, VirtualFile>(){

        public VirtualFile fun(IndexedRelevantResource<String, String> resource) {
            return resource.getFile();
        }
    };
    private final VirtualFile myFile;
    private final K myKey;
    private final V myValue;
    private final ResourceRelevance myRelevance;

    public static <K, V extends Comparable> List<IndexedRelevantResource<K, V>> getResources(ID<K, V> indexId, final K key, final @Nullable Module module, @NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 3 for @NotNull parameter of com/intellij/xml/index/IndexedRelevantResource.getResources must not be null");
        }
        final ArrayList<IndexedRelevantResource<K, V>> resources = new ArrayList<IndexedRelevantResource<K, V>>();
        final ProjectFileIndex fileIndex = ProjectRootManager.getInstance((Project)project).getFileIndex();
        FileBasedIndex.getInstance().processValues(indexId, key, null, new FileBasedIndex.ValueProcessor<V>(){

            @Override
            public boolean process(VirtualFile file, V value) {
                ResourceRelevance relevance = ResourceRelevance.getRelevance(file, module, fileIndex);
                if (relevance != ResourceRelevance.NONE) {
                    resources.add(new IndexedRelevantResource(file, key, value, relevance));
                }
                return true;
            }
        }, new AdditionalIndexedRootsScope(GlobalSearchScope.allScope((Project)project)));
        return resources;
    }

    public static <K, V extends Comparable> List<IndexedRelevantResource<K, V>> getAllResources(ID<K, V> indexId, @NotNull Module module, @Nullable NullableFunction<List<IndexedRelevantResource<K, V>>, IndexedRelevantResource<K, V>> chooser) {
        if (module == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/xml/index/IndexedRelevantResource.getAllResources must not be null");
        }
        ArrayList<IndexedRelevantResource<K, V>> all = new ArrayList<IndexedRelevantResource<K, V>>();
        Collection<K> allKeys = FileBasedIndex.getInstance().getAllKeys(indexId, module.getProject());
        for (K key : allKeys) {
            List<IndexedRelevantResource<K, V>> resources = IndexedRelevantResource.getResources(indexId, key, module, module.getProject());
            if (resources.isEmpty()) continue;
            if (chooser == null) {
                all.add(resources.get(0));
                continue;
            }
            IndexedRelevantResource resource = (IndexedRelevantResource)chooser.fun(resources);
            if (resource == null) continue;
            all.add(resource);
        }
        return all;
    }

    public IndexedRelevantResource(VirtualFile file, K key, V value, ResourceRelevance relevance) {
        this.myFile = file;
        this.myKey = key;
        this.myValue = value;
        this.myRelevance = relevance;
    }

    public VirtualFile getFile() {
        return this.myFile;
    }

    public V getValue() {
        return this.myValue;
    }

    public ResourceRelevance getRelevance() {
        return this.myRelevance;
    }

    @Override
    public int compareTo(IndexedRelevantResource<K, V> o) {
        int i = this.myRelevance.compareTo(o.getRelevance());
        return i == 0 ? this.myValue.compareTo(o.getValue()) : i;
    }

    public K getKey() {
        return this.myKey;
    }

    public String toString() {
        return "IndexedRelevantResource{myRelevance=" + (Object)((Object)this.myRelevance) + ", myKey=" + this.myKey + ", myValue=" + this.myValue + ", myFile=" + this.myFile + '}';
    }
}

