/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xml.util;

import com.intellij.codeInsight.daemon.EmptyResolveMessageProvider;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReference;
import com.intellij.psi.search.PsiElementProcessor;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlDocument;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.HashMap;
import com.intellij.xml.XmlBundle;
import com.intellij.xml.XmlExtension;
import com.intellij.xml.util.HtmlUtil;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class AnchorReference
implements PsiReference,
EmptyResolveMessageProvider {
    private final String myAnchor;
    private final PsiReference myFileReference;
    private final PsiElement myElement;
    private final int myOffset;
    private final boolean mySoft;
    @NonNls
    private static final String ANCHOR_ELEMENT_NAME = "a";
    private static final String MAP_ELEMENT_NAME = "map";
    private static final Key<CachedValue<Map<String, XmlTag>>> ourCachedIdsKey = Key.create((String)"cached.ids");

    AnchorReference(String anchor, @Nullable FileReference psiReference, PsiElement element, int offset, boolean soft) {
        this.myAnchor = anchor;
        this.myFileReference = psiReference;
        this.myElement = element;
        this.myOffset = offset;
        this.mySoft = soft;
    }

    public PsiElement getElement() {
        return this.myElement;
    }

    public TextRange getRangeInElement() {
        return new TextRange(this.myOffset, this.myOffset + this.myAnchor.length());
    }

    public PsiElement resolve() {
        XmlTag tag;
        if (this.myAnchor.length() == 0) {
            return this.myElement;
        }
        Map<String, XmlTag> map = this.getIdMap();
        XmlTag xmlTag = tag = map != null ? map.get(this.myAnchor) : null;
        if (tag != null) {
            XmlAttribute attribute = tag.getAttribute("id", null);
            if (attribute == null) {
                attribute = tag.getAttribute("name", null);
            }
            if (attribute == null && MAP_ELEMENT_NAME.equalsIgnoreCase(tag.getName())) {
                attribute = tag.getAttribute("usemap", null);
            }
            return attribute.getValueElement();
        }
        return null;
    }

    private static boolean processXmlElements(XmlTag element, PsiElementProcessor processor) {
        if (!AnchorReference._processXmlElements(element, processor)) {
            return false;
        }
        for (PsiElement next = element.getNextSibling(); next != null; next = next.getNextSibling()) {
            if (!(next instanceof XmlTag) || AnchorReference._processXmlElements((XmlTag)next, processor)) continue;
            return false;
        }
        return true;
    }

    static boolean _processXmlElements(XmlTag element, PsiElementProcessor processor) {
        if (!processor.execute((PsiElement)element)) {
            return false;
        }
        XmlTag[] subTags = element.getSubTags();
        for (int i = 0; i < subTags.length; ++i) {
            if (AnchorReference._processXmlElements(subTags[i], processor)) continue;
            return false;
        }
        return true;
    }

    private Map<String, XmlTag> getIdMap() {
        final XmlFile file = this.getFile();
        if (file != null) {
            CachedValue value = (CachedValue)file.getUserData(ourCachedIdsKey);
            if (value == null) {
                value = CachedValuesManager.getManager((Project)file.getProject()).createCachedValue((CachedValueProvider)new CachedValueProvider<Map<String, XmlTag>>(){

                    public CachedValueProvider.Result<Map<String, XmlTag>> compute() {
                        XmlTag rootTag;
                        HashMap resultMap = new HashMap();
                        XmlDocument document = HtmlUtil.getRealXmlDocument(file.getDocument());
                        XmlTag xmlTag = rootTag = document != null ? document.getRootTag() : null;
                        if (rootTag != null) {
                            AnchorReference.processXmlElements(rootTag, new PsiElementProcessor((Map)resultMap){
                                final /* synthetic */ Map val$resultMap;
                                {
                                    this.val$resultMap = map;
                                }

                                public boolean execute(PsiElement element) {
                                    String anchorValue;
                                    String string = anchorValue = element instanceof XmlTag ? AnchorReference.getAnchorValue((XmlTag)element) : null;
                                    if (anchorValue != null) {
                                        this.val$resultMap.put(anchorValue, (XmlTag)element);
                                    }
                                    return true;
                                }
                            });
                        }
                        return new CachedValueProvider.Result((Object)resultMap, new Object[]{file});
                    }
                }, false);
                file.putUserData(ourCachedIdsKey, (Object)value);
            }
            return (Map)value.getValue();
        }
        return null;
    }

    private static String getAnchorValue(XmlTag xmlTag) {
        String map_anchor;
        String attributeValue2;
        String attributeValue = xmlTag.getAttributeValue("id");
        if (attributeValue != null) {
            return attributeValue;
        }
        if (ANCHOR_ELEMENT_NAME.equalsIgnoreCase(xmlTag.getName()) && (attributeValue2 = xmlTag.getAttributeValue("name")) != null) {
            return attributeValue2;
        }
        if (MAP_ELEMENT_NAME.equalsIgnoreCase(xmlTag.getName()) && (map_anchor = xmlTag.getAttributeValue("name")) != null) {
            return map_anchor;
        }
        return null;
    }

    public String getCanonicalText() {
        return this.myAnchor;
    }

    public PsiElement handleElementRename(String newElementName) throws IncorrectOperationException {
        return ElementManipulators.getManipulator((PsiElement)this.myElement).handleContentChange(this.myElement, this.getRangeInElement(), newElementName);
    }

    public PsiElement bindToElement(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/xml/util/AnchorReference.bindToElement must not be null");
        }
        return null;
    }

    public boolean isReferenceTo(PsiElement element) {
        if (!(element instanceof XmlAttributeValue)) {
            return false;
        }
        return this.myElement.getManager().areElementsEquivalent(element, this.resolve());
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public Object[] getVariants() {
        Object[] objectArray;
        Map<String, XmlTag> idMap = this.getIdMap();
        if (idMap == null) {
            objectArray = ArrayUtil.EMPTY_OBJECT_ARRAY;
            if (ArrayUtil.EMPTY_OBJECT_ARRAY == null) throw new IllegalStateException("@NotNull method com/intellij/xml/util/AnchorReference.getVariants must not return null");
            return objectArray;
        }
        objectArray = idMap.keySet().toArray(new Object[idMap.size()]);
        if (objectArray != null) return objectArray;
        throw new IllegalStateException("@NotNull method com/intellij/xml/util/AnchorReference.getVariants must not return null");
    }

    @Nullable
    private XmlFile getFile() {
        if (this.myFileReference != null) {
            PsiElement psiElement = this.myFileReference.resolve();
            return psiElement instanceof XmlFile ? (XmlFile)psiElement : null;
        }
        PsiFile containingFile = this.myElement.getContainingFile();
        if (containingFile instanceof XmlFile) {
            return (XmlFile)containingFile;
        }
        XmlExtension extension = XmlExtension.getExtensionByElement(this.myElement);
        return extension == null ? null : extension.getContainingFile(this.myElement);
    }

    public boolean isSoft() {
        return this.mySoft;
    }

    public String getUnresolvedMessagePattern() {
        XmlFile xmlFile = this.getFile();
        return xmlFile == null ? XmlBundle.message((String)"cannot.resolve.anchor", (Object[])new Object[]{this.myAnchor}) : XmlBundle.message((String)"cannot.resolve.anchor.in.file", (Object[])new Object[]{this.myAnchor, xmlFile.getName()});
    }
}

