/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xml.util;

import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInsight.CodeInsightUtilBase;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.XmlInspectionGroupNames;
import com.intellij.codeInspection.XmlSuppressableInspectionTool;
import com.intellij.lexer.Lexer;
import com.intellij.lexer.XmlLexer;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.XmlElementVisitor;
import com.intellij.psi.html.HtmlTag;
import com.intellij.psi.impl.source.tree.TreeUtil;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlTagValue;
import com.intellij.psi.xml.XmlTokenType;
import com.intellij.xml.XmlBundle;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class CheckValidXmlInScriptBodyInspection
extends XmlSuppressableInspectionTool {
    @NonNls
    private static final String SCRIPT_TAG_NAME = "script";
    private Lexer myXmlLexer;
    @NonNls
    private static final String AMP_ENTITY_REFERENCE = "&amp;";
    @NonNls
    private static final String LT_ENTITY_REFERENCE = "&lt;";

    public boolean isEnabledByDefault() {
        return true;
    }

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/xml/util/CheckValidXmlInScriptBodyInspection.buildVisitor must not be null");
        }
        XmlElementVisitor xmlElementVisitor = new XmlElementVisitor(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public void visitXmlTag(XmlTag tag) {
                PsiFile psiFile;
                FileType fileType;
                if (!CheckValidXmlInScriptBodyInspection.SCRIPT_TAG_NAME.equals(tag.getName()) && (!(tag instanceof HtmlTag) || !CheckValidXmlInScriptBodyInspection.SCRIPT_TAG_NAME.equalsIgnoreCase(tag.getName())) || (fileType = (psiFile = tag.getContainingFile()).getFileType()) != StdFileTypes.XHTML && fileType != StdFileTypes.JSPX) return;
                Class<CheckValidXmlInScriptBodyInspection> clazz = CheckValidXmlInScriptBodyInspection.class;
                synchronized (CheckValidXmlInScriptBodyInspection.class) {
                    XmlTagValue tagValue;
                    String tagBodyText;
                    if (CheckValidXmlInScriptBodyInspection.this.myXmlLexer == null) {
                        CheckValidXmlInScriptBodyInspection.this.myXmlLexer = (Lexer)new XmlLexer();
                    }
                    if ((tagBodyText = (tagValue = tag.getValue()).getText()).length() <= 0) return;
                    CheckValidXmlInScriptBodyInspection.this.myXmlLexer.start((CharSequence)tagBodyText);
                    while (CheckValidXmlInScriptBodyInspection.this.myXmlLexer.getTokenType() != null) {
                        IElementType tokenType = CheckValidXmlInScriptBodyInspection.this.myXmlLexer.getTokenType();
                        if (tokenType == XmlTokenType.XML_CDATA_START) {
                            while (tokenType != null && tokenType != XmlTokenType.XML_CDATA_END) {
                                CheckValidXmlInScriptBodyInspection.this.myXmlLexer.advance();
                                tokenType = CheckValidXmlInScriptBodyInspection.this.myXmlLexer.getTokenType();
                            }
                            if (tokenType == null) return;
                        }
                        if (tokenType == XmlTokenType.XML_BAD_CHARACTER && "&".equals(TreeUtil.getTokenText(CheckValidXmlInScriptBodyInspection.this.myXmlLexer)) || tokenType == XmlTokenType.XML_START_TAG_START) {
                            int valueStart = tagValue.getTextRange().getStartOffset();
                            int offset = valueStart + CheckValidXmlInScriptBodyInspection.this.myXmlLexer.getTokenStart();
                            PsiElement psiElement = psiFile.findElementAt(offset);
                            TextRange elementRange = psiElement.getTextRange();
                            int offsetInElement = offset - elementRange.getStartOffset();
                            holder.registerProblem(psiElement, XmlBundle.message((String)"unescaped.xml.character", (Object[])new Object[0]), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new LocalQuickFix[]{new InsertQuotedCharacterQuickFix(psiFile, psiElement, offsetInElement)});
                            int endOfElementInScriptTag = elementRange.getEndOffset() - valueStart;
                            while (CheckValidXmlInScriptBodyInspection.this.myXmlLexer.getTokenEnd() < endOfElementInScriptTag) {
                                CheckValidXmlInScriptBodyInspection.this.myXmlLexer.advance();
                                if (CheckValidXmlInScriptBodyInspection.this.myXmlLexer.getTokenType() != null) continue;
                            }
                        }
                        CheckValidXmlInScriptBodyInspection.this.myXmlLexer.advance();
                    }
                    // ** MonitorExit[var4_4] (shouldn't be in output)
                    return;
                }
            }
        };
        if (xmlElementVisitor == null) {
            throw new IllegalStateException("@NotNull method com/intellij/xml/util/CheckValidXmlInScriptBodyInspection.buildVisitor must not return null");
        }
        return xmlElementVisitor;
    }

    @NotNull
    public String getGroupDisplayName() {
        String string = XmlInspectionGroupNames.HTML_INSPECTIONS;
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/xml/util/CheckValidXmlInScriptBodyInspection.getGroupDisplayName must not return null");
        }
        return string;
    }

    @NotNull
    public String getDisplayName() {
        String string = XmlBundle.message((String)"html.inspections.check.valid.script.tag", (Object[])new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/xml/util/CheckValidXmlInScriptBodyInspection.getDisplayName must not return null");
        }
        return string;
    }

    @NotNull
    @NonNls
    public String getShortName() {
        if ("CheckValidXmlInScriptTagBody" == null) {
            throw new IllegalStateException("@NotNull method com/intellij/xml/util/CheckValidXmlInScriptBodyInspection.getShortName must not return null");
        }
        return "CheckValidXmlInScriptTagBody";
    }

    @NotNull
    public HighlightDisplayLevel getDefaultLevel() {
        HighlightDisplayLevel highlightDisplayLevel = HighlightDisplayLevel.ERROR;
        if (highlightDisplayLevel == null) {
            throw new IllegalStateException("@NotNull method com/intellij/xml/util/CheckValidXmlInScriptBodyInspection.getDefaultLevel must not return null");
        }
        return highlightDisplayLevel;
    }

    private static class InsertQuotedCharacterQuickFix
    implements LocalQuickFix {
        private final PsiFile psiFile;
        private final PsiElement psiElement;
        private final int startInElement;

        public InsertQuotedCharacterQuickFix(PsiFile psiFile, PsiElement psiElement, int startInElement) {
            this.psiFile = psiFile;
            this.psiElement = psiElement;
            this.startInElement = startInElement;
        }

        @NotNull
        public String getName() {
            String character = this.getXmlCharacter();
            String string = XmlBundle.message((String)"unescaped.xml.character.fix.message", (Object[])new Object[]{character.equals("&") ? XmlBundle.message((String)"unescaped.xml.character.fix.message.parameter", (Object[])new Object[0]) : character});
            if (string == null) {
                throw new IllegalStateException("@NotNull method com/intellij/xml/util/CheckValidXmlInScriptBodyInspection$InsertQuotedCharacterQuickFix.getName must not return null");
            }
            return string;
        }

        @NotNull
        public String getFamilyName() {
            String string = this.getName();
            if (string == null) {
                throw new IllegalStateException("@NotNull method com/intellij/xml/util/CheckValidXmlInScriptBodyInspection$InsertQuotedCharacterQuickFix.getFamilyName must not return null");
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor problemDescriptor) {
            if (project == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/xml/util/CheckValidXmlInScriptBodyInspection$InsertQuotedCharacterQuickFix.applyFix must not be null");
            }
            if (problemDescriptor == null) {
                throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/xml/util/CheckValidXmlInScriptBodyInspection$InsertQuotedCharacterQuickFix.applyFix must not be null");
            }
            if (!CodeInsightUtilBase.prepareFileForWrite(this.psiFile)) {
                return;
            }
            TextRange range = this.psiElement.getTextRange();
            OpenFileDescriptor descriptor = new OpenFileDescriptor(project, this.psiFile.getVirtualFile(), range.getStartOffset() + this.startInElement);
            Editor editor = FileEditorManager.getInstance((Project)project).openTextEditor(descriptor, true);
            if (editor == null) {
                return;
            }
            String xmlCharacter = this.getXmlCharacter();
            String replacement = xmlCharacter.equals("&") ? CheckValidXmlInScriptBodyInspection.AMP_ENTITY_REFERENCE : CheckValidXmlInScriptBodyInspection.LT_ENTITY_REFERENCE;
            replacement = this.psiElement.getText().replace(xmlCharacter, replacement);
            editor.getDocument().replaceString(range.getStartOffset(), range.getEndOffset(), (CharSequence)replacement);
        }

        private String getXmlCharacter() {
            return this.psiElement.getText().substring(this.startInElement, this.startInElement + 1);
        }
    }
}

