/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xml.util.documentation;

import com.intellij.lang.documentation.DocumentationProvider;
import com.intellij.lang.documentation.DocumentationUtil;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.XmlElementFactory;
import com.intellij.psi.meta.PsiMetaData;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeDecl;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlElementDecl;
import com.intellij.psi.xml.XmlEntityDecl;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.IncorrectOperationException;
import com.intellij.xml.XmlAttributeDescriptor;
import com.intellij.xml.XmlBundle;
import com.intellij.xml.XmlElementDescriptor;
import com.intellij.xml.util.ColorSampleLookupValue;
import com.intellij.xml.util.documentation.CompositeAttributeTagDescriptor;
import com.intellij.xml.util.documentation.EntityDescriptor;
import com.intellij.xml.util.documentation.HtmlAttributeDescriptor;
import com.intellij.xml.util.documentation.HtmlDescriptorsTable;
import com.intellij.xml.util.documentation.HtmlTagDescriptor;
import com.intellij.xml.util.documentation.XmlDocumentationProvider;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.Nullable;

public class HtmlDocumentationProvider
implements DocumentationProvider {
    private static String ourBaseHtmlExtDocUrl;
    private static DocumentationProvider ourStyleProvider;
    private static DocumentationProvider ourScriptProvider;
    @NonNls
    public static final String ELEMENT_ELEMENT_NAME = "element";
    @NonNls
    public static final String NBSP = ":&nbsp;";
    @NonNls
    public static final String BR = "<br>";

    public static void registerStyleDocumentationProvider(DocumentationProvider documentationProvider) {
        ourStyleProvider = documentationProvider;
    }

    @Nullable
    public String getQuickNavigateInfo(PsiElement element) {
        return null;
    }

    public List<String> getUrlFor(PsiElement element, PsiElement originalElement) {
        String result = HtmlDocumentationProvider.getUrlForHtml(element, (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)originalElement, XmlTag.class, (boolean)false));
        if (result == null && ourStyleProvider != null) {
            return ourStyleProvider.getUrlFor(element, originalElement);
        }
        return result != null ? Collections.singletonList(result) : null;
    }

    public static String getUrlForHtml(PsiElement element, XmlTag context) {
        EntityDescriptor descriptor = HtmlDocumentationProvider.findDocumentationDescriptor(element, context);
        if (descriptor != null) {
            return ourBaseHtmlExtDocUrl + descriptor.getHelpRef();
        }
        return null;
    }

    private static EntityDescriptor findDocumentationDescriptor(PsiElement element, XmlTag context) {
        boolean isTag = true;
        XmlElement nameElement = null;
        String key = null;
        if (element instanceof XmlElementDecl) {
            nameElement = ((XmlElementDecl)element).getNameElement();
        } else if (element instanceof XmlAttributeDecl) {
            nameElement = ((XmlAttributeDecl)element).getNameElement();
            isTag = false;
        } else if (element instanceof XmlTag) {
            XmlTag xmlTag = (XmlTag)element;
            PsiMetaData metaData = xmlTag.getMetaData();
            key = metaData != null ? metaData.getName() : null;
            isTag = xmlTag.getLocalName().equals(ELEMENT_ELEMENT_NAME);
        } else if (element.getParent() instanceof XmlAttributeValue) {
            isTag = false;
            key = ((XmlAttribute)element.getParent().getParent()).getName();
        } else if (element instanceof XmlAttributeValue) {
            isTag = false;
            XmlAttribute xmlAttribute = (XmlAttribute)element.getParent();
            key = xmlAttribute.getName();
        } else if (element instanceof XmlAttribute) {
            XmlAttribute xmlAttribute = (XmlAttribute)element;
            isTag = false;
            key = xmlAttribute.getName();
        } else {
            nameElement = element;
            boolean bl = isTag = !(element.getParent() instanceof XmlAttribute);
        }
        if (nameElement != null) {
            key = nameElement.getText();
        }
        String string = key = key != null ? key.toLowerCase() : "";
        if (isTag) {
            return HtmlDescriptorsTable.getTagDescriptor(key);
        }
        return HtmlDocumentationProvider.getDescriptor(key, context);
    }

    private static HtmlAttributeDescriptor getDescriptor(String name, XmlTag context) {
        HtmlAttributeDescriptor attributeDescriptor = HtmlDescriptorsTable.getAttributeDescriptor(name);
        if (attributeDescriptor instanceof CompositeAttributeTagDescriptor) {
            return ((CompositeAttributeTagDescriptor)attributeDescriptor).findHtmlAttributeInContext(context);
        }
        return attributeDescriptor;
    }

    public String generateDoc(PsiElement element, PsiElement originalElement) {
        XmlTag tag = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)originalElement, XmlTag.class, (boolean)false);
        String result = this.generateDocForHtml(element, false, tag, originalElement);
        if (result == null && ourStyleProvider != null) {
            result = ourStyleProvider.generateDoc(element, originalElement);
        }
        if (result == null && ourScriptProvider != null) {
            result = ourScriptProvider.generateDoc(element, originalElement);
        }
        if (result == null && element instanceof XmlAttributeValue) {
            result = this.generateDocForHtml(element.getParent(), false, tag, originalElement);
        }
        return result;
    }

    public String generateDocForHtml(PsiElement element) {
        return this.generateDocForHtml(element, true, null, null);
    }

    protected String generateDocForHtml(PsiElement element, boolean ommitHtmlSpecifics, XmlTag context, PsiElement originalElement) {
        EntityDescriptor descriptor = HtmlDocumentationProvider.findDocumentationDescriptor(element, context);
        if (descriptor != null) {
            return HtmlDocumentationProvider.generateJavaDoc(descriptor, ommitHtmlSpecifics, originalElement);
        }
        if (element instanceof XmlEntityDecl) {
            XmlEntityDecl entityDecl = (XmlEntityDecl)element;
            return XmlDocumentationProvider.findDocRightAfterElement(element, entityDecl.getName());
        }
        return null;
    }

    private static String generateJavaDoc(EntityDescriptor descriptor, boolean ommitHtmlSpecifics, PsiElement element) {
        boolean deprecated;
        StringBuilder buf = new StringBuilder();
        boolean istag = descriptor instanceof HtmlTagDescriptor;
        if (istag) {
            DocumentationUtil.formatEntityName((String)XmlBundle.message((String)"xml.javadoc.tag.name.message", (Object[])new Object[0]), (String)descriptor.getName(), (StringBuilder)buf);
        } else {
            DocumentationUtil.formatEntityName((String)XmlBundle.message((String)"xml.javadoc.attribute.name.message", (Object[])new Object[0]), (String)descriptor.getName(), (StringBuilder)buf);
        }
        buf.append(XmlBundle.message((String)"xml.javadoc.description.message", (Object[])new Object[0])).append(NBSP).append(descriptor.getDescription()).append(BR);
        if (istag) {
            HtmlTagDescriptor tagDescriptor = (HtmlTagDescriptor)descriptor;
            if (!ommitHtmlSpecifics) {
                boolean hasStartTag = tagDescriptor.isHasStartTag();
                if (!hasStartTag) {
                    buf.append(XmlBundle.message((String)"xml.javadoc.start.tag.could.be.omitted.message", (Object[])new Object[0])).append(BR);
                }
                if (!tagDescriptor.isEmpty() && !tagDescriptor.isHasEndTag()) {
                    buf.append(XmlBundle.message((String)"xml.javadoc.end.tag.could.be.omitted.message", (Object[])new Object[0])).append(BR);
                }
            }
            if (tagDescriptor.isEmpty()) {
                buf.append(XmlBundle.message((String)"xml.javadoc.is.empty.message", (Object[])new Object[0])).append(BR);
            }
        } else {
            HtmlAttributeDescriptor attributeDescriptor = (HtmlAttributeDescriptor)descriptor;
            buf.append(XmlBundle.message((String)"xml.javadoc.attr.type.message", (Object[])new Object[]{attributeDescriptor.getType()})).append(BR);
            if (!attributeDescriptor.isHasDefaultValue()) {
                buf.append(XmlBundle.message((String)"xml.javadoc.attr.default.required.message", (Object[])new Object[0])).append(BR);
            }
        }
        char dtdId = descriptor.getDtd();
        boolean bl = deprecated = dtdId == 'L';
        if (deprecated) {
            buf.append(XmlBundle.message((String)"xml.javadoc.deprecated.message", (Object[])new Object[]{deprecated})).append(BR);
        }
        if (dtdId == 'L') {
            buf.append(XmlBundle.message((String)"xml.javadoc.defined.in.loose.dtd.message", (Object[])new Object[0]));
        } else if (dtdId == 'D') {
            buf.append(XmlBundle.message((String)"xml.javadoc.defined.in.frameset.dtd.message", (Object[])new Object[0]));
        } else {
            buf.append(XmlBundle.message((String)"xml.javadoc.defined.in.any.dtd.message", (Object[])new Object[0]));
        }
        if (!istag) {
            ColorSampleLookupValue.addColorPreviewAndCodeToLookup(element, buf);
        }
        if (element != null) {
            buf.append(XmlDocumentationProvider.generateHtmlAdditionalDocTemplate(element));
        }
        return buf.toString();
    }

    public PsiElement getDocumentationElementForLookupItem(PsiManager psiManager, Object object, PsiElement element) {
        PsiElement result = this.createNavigationElementHTML(psiManager, object.toString(), element);
        if (result == null && ourStyleProvider != null) {
            result = ourStyleProvider.getDocumentationElementForLookupItem(psiManager, object, element);
        }
        if (result == null && ourScriptProvider != null) {
            result = ourScriptProvider.getDocumentationElementForLookupItem(psiManager, object, element);
        }
        if (result == null && object instanceof String && element != null) {
            result = XmlDocumentationProvider.findDeclWithName((String)object, element);
        }
        return result;
    }

    public PsiElement getDocumentationElementForLink(PsiManager psiManager, String link, PsiElement context) {
        PsiElement result = this.createNavigationElementHTML(psiManager, link, context);
        if (result == null && ourStyleProvider != null) {
            result = ourStyleProvider.getDocumentationElementForLink(psiManager, link, context);
        }
        if (result == null && ourScriptProvider != null) {
            result = ourScriptProvider.getDocumentationElementForLink(psiManager, link, context);
        }
        return result;
    }

    public PsiElement createNavigationElementHTML(PsiManager psiManager, String text, PsiElement context) {
        String key = text.toLowerCase();
        HtmlTagDescriptor descriptor = HtmlDescriptorsTable.getTagDescriptor(key);
        if (descriptor != null && !this.isAttributeContext(context)) {
            try {
                XmlTag tagFromText = XmlElementFactory.getInstance((Project)psiManager.getProject()).createTagFromText("<" + key + " xmlns=\"" + "http://www.w3.org/1999/xhtml" + "\"/>");
                XmlElementDescriptor tagDescriptor = tagFromText.getDescriptor();
                return tagDescriptor != null ? tagDescriptor.getDeclaration() : null;
            }
            catch (IncorrectOperationException ignore) {}
        } else {
            XmlTag tagContext = this.findTagContext(context);
            HtmlAttributeDescriptor myAttributeDescriptor = HtmlDocumentationProvider.getDescriptor(key, tagContext);
            if (myAttributeDescriptor != null && tagContext != null) {
                XmlElementDescriptor tagDescriptor = tagContext.getDescriptor();
                XmlAttributeDescriptor attributeDescriptor = tagDescriptor != null ? tagDescriptor.getAttributeDescriptor(text, tagContext) : null;
                return attributeDescriptor != null ? attributeDescriptor.getDeclaration() : null;
            }
        }
        return null;
    }

    protected boolean isAttributeContext(PsiElement context) {
        PsiElement prevSibling;
        if (context instanceof XmlAttribute) {
            return true;
        }
        return context instanceof PsiWhiteSpace && (prevSibling = context.getPrevSibling()) instanceof XmlAttribute;
    }

    protected XmlTag findTagContext(PsiElement context) {
        PsiElement prevSibling;
        if (context instanceof PsiWhiteSpace && (prevSibling = context.getPrevSibling()) instanceof XmlTag) {
            return (XmlTag)prevSibling;
        }
        return (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)context, XmlTag.class, (boolean)false);
    }

    public static void setBaseHtmlExtDocUrl(String baseHtmlExtDocUrl) {
        ourBaseHtmlExtDocUrl = baseHtmlExtDocUrl;
    }

    static String getBaseHtmlExtDocUrl() {
        return ourBaseHtmlExtDocUrl;
    }

    public static void registerScriptDocumentationProvider(DocumentationProvider provider) {
        ourScriptProvider = provider;
    }
}

