/*
 * Decompiled with CFR 0.152.
 */
package org.testng.reporters;

import java.io.File;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.testng.IResultMap;
import org.testng.ISuiteResult;
import org.testng.ITestResult;
import org.testng.internal.Utils;
import org.testng.reporters.XMLReporterConfig;
import org.testng.reporters.XMLStringBuffer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XMLSuiteResultWriter {
    private XMLReporterConfig config;

    public XMLSuiteResultWriter(XMLReporterConfig config) {
        this.config = config;
    }

    public void writeSuiteResult(XMLStringBuffer xmlBuffer, ISuiteResult suiteResult) {
        if (3 != this.config.getFileFragmentationLevel()) {
            this.writeAllToBuffer(xmlBuffer, suiteResult);
        } else {
            String parentDir = this.config.getOutputDirectory() + File.separatorChar + suiteResult.getTestContext().getSuite().getName();
            File file = this.referenceSuiteResult(xmlBuffer, parentDir, suiteResult);
            XMLStringBuffer suiteXmlBuffer = new XMLStringBuffer("");
            this.writeAllToBuffer(suiteXmlBuffer, suiteResult);
            Utils.writeUtf8File(file.getAbsoluteFile().getParent(), file.getName(), suiteXmlBuffer.toXML());
        }
    }

    private void writeAllToBuffer(XMLStringBuffer xmlBuffer, ISuiteResult suiteResult) {
        xmlBuffer.push("test", this.getSuiteResultAttributes(suiteResult));
        HashSet<ITestResult> testResults = new HashSet<ITestResult>();
        this.addAllTestResults(testResults, suiteResult.getTestContext().getPassedTests());
        this.addAllTestResults(testResults, suiteResult.getTestContext().getFailedTests());
        this.addAllTestResults(testResults, suiteResult.getTestContext().getSkippedTests());
        this.addAllTestResults(testResults, suiteResult.getTestContext().getPassedConfigurations());
        this.addAllTestResults(testResults, suiteResult.getTestContext().getSkippedConfigurations());
        this.addAllTestResults(testResults, suiteResult.getTestContext().getFailedConfigurations());
        this.addAllTestResults(testResults, suiteResult.getTestContext().getFailedButWithinSuccessPercentageTests());
        this.addTestResults(xmlBuffer, testResults);
        xmlBuffer.pop();
    }

    private void addAllTestResults(Set<ITestResult> testResults, IResultMap resultMap) {
        if (resultMap != null) {
            testResults.addAll(resultMap.getAllResults());
        }
    }

    private File referenceSuiteResult(XMLStringBuffer xmlBuffer, String parentDir, ISuiteResult suiteResult) {
        Properties attrs = new Properties();
        String suiteResultName = suiteResult.getTestContext().getName() + ".xml";
        attrs.setProperty("url", suiteResultName);
        xmlBuffer.addEmptyElement("test", attrs);
        return new File(parentDir + File.separatorChar + suiteResultName);
    }

    private Properties getSuiteResultAttributes(ISuiteResult suiteResult) {
        Properties attributes = new Properties();
        attributes.setProperty("name", suiteResult.getTestContext().getName());
        return attributes;
    }

    private void addTestResults(XMLStringBuffer xmlBuffer, Set<ITestResult> testResults) {
        Map<String, List<ITestResult>> testsGroupedByClass = this.buildTestClassGroups(testResults);
        for (Map.Entry<String, List<ITestResult>> result : testsGroupedByClass.entrySet()) {
            Properties attributes = new Properties();
            String className = result.getKey();
            if (this.config.isSplitClassAndPackageNames()) {
                int dot = className.lastIndexOf(46);
                attributes.setProperty("name", dot > -1 ? className.substring(dot + 1, className.length()) : className);
                attributes.setProperty("package", dot > -1 ? className.substring(0, dot) : "[default]");
            } else {
                attributes.setProperty("name", className);
            }
            xmlBuffer.push("class", attributes);
            List<ITestResult> sortedResults = result.getValue();
            Collections.sort(sortedResults);
            for (ITestResult testResult : sortedResults) {
                this.addTestResult(xmlBuffer, testResult);
            }
            xmlBuffer.pop();
        }
    }

    private Map<String, List<ITestResult>> buildTestClassGroups(Set<ITestResult> testResults) {
        HashMap<String, List<ITestResult>> map = new HashMap<String, List<ITestResult>>();
        for (ITestResult result : testResults) {
            String className = result.getTestClass().getName();
            ArrayList<ITestResult> list = (ArrayList<ITestResult>)map.get(className);
            if (list == null) {
                list = new ArrayList<ITestResult>();
                map.put(className, list);
            }
            list.add(result);
        }
        return map;
    }

    private void addTestResult(XMLStringBuffer xmlBuffer, ITestResult testResult) {
        Properties attribs = this.getTestResultAttributes(testResult);
        attribs.setProperty("status", this.getStatusString(testResult.getStatus()));
        xmlBuffer.push("test-method", attribs);
        this.addTestMethodParams(xmlBuffer, testResult);
        this.addTestResultException(xmlBuffer, testResult);
        xmlBuffer.pop();
    }

    private String getStatusString(int testResultStatus) {
        switch (testResultStatus) {
            case 1: {
                return "PASS";
            }
            case 2: {
                return "FAIL";
            }
            case 3: {
                return "SKIP";
            }
            case 4: {
                return "SUCCESS_PERCENTAGE_FAILURE";
            }
        }
        return null;
    }

    private Properties getTestResultAttributes(ITestResult testResult) {
        String dependsOnStr;
        String groupNamesStr;
        Properties attributes = new Properties();
        if (!testResult.getMethod().isTest()) {
            attributes.setProperty("is-config", "true");
        }
        attributes.setProperty("name", testResult.getName());
        String description = testResult.getMethod().getDescription();
        if (!Utils.isStringEmpty(description)) {
            attributes.setProperty("description", description);
        }
        attributes.setProperty("signature", this.removeClassName(testResult.getMethod().toString()));
        SimpleDateFormat format = new SimpleDateFormat(this.config.getTimestampFormat());
        String startTime = format.format(testResult.getStartMillis());
        String endTime = format.format(testResult.getEndMillis());
        attributes.setProperty("started-at", startTime);
        attributes.setProperty("finished-at", endTime);
        long duration = testResult.getEndMillis() - testResult.getStartMillis();
        String strDuration = Long.toString(duration);
        attributes.setProperty("duration-ms", strDuration);
        if (this.config.isGenerateGroupsAttribute() && !Utils.isStringEmpty(groupNamesStr = Utils.arrayToString(testResult.getMethod().getGroups()))) {
            attributes.setProperty("groups", groupNamesStr);
        }
        if (this.config.isGenerateDependsOnMethods() && !Utils.isStringEmpty(dependsOnStr = Utils.arrayToString(testResult.getMethod().getMethodsDependedUpon()))) {
            attributes.setProperty("depends-on-methods", dependsOnStr);
        }
        if (this.config.isGenerateDependsOnGroups() && !Utils.isStringEmpty(dependsOnStr = Utils.arrayToString(testResult.getMethod().getGroupsDependedUpon()))) {
            attributes.setProperty("depends-on-groups", dependsOnStr);
        }
        return attributes;
    }

    private String removeClassName(String methodSignature) {
        int firstParanthesisPos = methodSignature.indexOf("(");
        int dotAferClassPos = methodSignature.substring(0, firstParanthesisPos).lastIndexOf(".");
        return methodSignature.substring(dotAferClassPos + 1, methodSignature.length());
    }

    public void addTestMethodParams(XMLStringBuffer xmlBuffer, ITestResult testResult) {
        Object[] parameters = testResult.getParameters();
        if (parameters != null && parameters.length > 0) {
            xmlBuffer.push("params");
            for (int i = 0; i < parameters.length; ++i) {
                this.addParameter(xmlBuffer, parameters[i], i);
            }
            xmlBuffer.pop();
        }
    }

    private void addParameter(XMLStringBuffer xmlBuffer, Object parameter, int i) {
        Properties attrs = new Properties();
        attrs.setProperty("index", String.valueOf(i));
        xmlBuffer.push("param", attrs);
        if (parameter == null) {
            Properties valueAttrs = new Properties();
            valueAttrs.setProperty("is-null", "true");
            xmlBuffer.addEmptyElement("value", valueAttrs);
        } else {
            xmlBuffer.push("value");
            xmlBuffer.addCDATA(parameter.toString());
            xmlBuffer.pop();
        }
        xmlBuffer.pop();
    }

    private void addTestResultException(XMLStringBuffer xmlBuffer, ITestResult testResult) {
        Throwable exception = testResult.getThrowable();
        if (exception != null) {
            Properties exceptionAttrs = new Properties();
            exceptionAttrs.setProperty("class", exception.getClass().getName());
            xmlBuffer.push("exception", exceptionAttrs);
            if (!Utils.isStringEmpty(exception.getMessage())) {
                xmlBuffer.push("message");
                xmlBuffer.addCDATA(exception.getMessage());
                xmlBuffer.pop();
            }
            String[] stackTraces = Utils.stackTrace(exception, false);
            if ((this.config.getStackTraceOutputMethod() & 1) == 1) {
                xmlBuffer.push("short-stacktrace");
                xmlBuffer.addCDATA(stackTraces[0]);
                xmlBuffer.pop();
            }
            if ((this.config.getStackTraceOutputMethod() & 2) == 2) {
                xmlBuffer.push("full-stacktrace");
                xmlBuffer.addCDATA(stackTraces[1]);
                xmlBuffer.pop();
            }
            xmlBuffer.pop();
        }
    }
}

