/*
 * Decompiled with CFR 0.152.
 */
package org.testng.xml;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.testng.internal.PackageUtils;
import org.testng.internal.Utils;
import org.testng.reporters.XMLStringBuffer;
import org.testng.xml.XmlClass;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XmlPackage
implements Serializable {
    private String m_name;
    private List<String> m_include = new ArrayList<String>();
    private List<String> m_exclude = new ArrayList<String>();
    private List<XmlClass> m_xmlClasses = null;

    public List<String> getExclude() {
        return this.m_exclude;
    }

    public void setExclude(List<String> exclude) {
        this.m_exclude = exclude;
    }

    public List<String> getInclude() {
        return this.m_include;
    }

    public void setInclude(List<String> include) {
        this.m_include = include;
    }

    public String getName() {
        return this.m_name;
    }

    public void setName(String name) {
        this.m_name = name;
    }

    public List<XmlClass> getXmlClasses() {
        if (null == this.m_xmlClasses) {
            this.m_xmlClasses = this.initializeXmlClasses();
        }
        return this.m_xmlClasses;
    }

    private List<XmlClass> initializeXmlClasses() {
        ArrayList<XmlClass> result = new ArrayList<XmlClass>();
        try {
            String[] classes;
            for (String className : classes = PackageUtils.findClassesInPackage(this.m_name, this.m_include, this.m_exclude)) {
                result.add(new XmlClass(className, Boolean.FALSE));
            }
        }
        catch (IOException ioex) {
            Utils.log("XmlPackage", 1, ioex.getMessage());
        }
        return result;
    }

    public Object toXml(String indent) {
        XMLStringBuffer xsb = new XMLStringBuffer(indent);
        Properties p = new Properties();
        p.setProperty("name", this.getName());
        xsb.push("package", p);
        for (String m : this.getInclude()) {
            Properties includeProp = new Properties();
            includeProp.setProperty("name", m);
            xsb.addEmptyElement("include", includeProp);
        }
        for (String m : this.getExclude()) {
            Properties excludeProp = new Properties();
            excludeProp.setProperty("name", m);
            xsb.addEmptyElement("exclude", excludeProp);
        }
        xsb.pop("package");
        return xsb.toXML();
    }
}

