/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cvsSupport2.connections.local;

import com.intellij.cvsSupport2.config.LocalSettings;
import com.intellij.cvsSupport2.connections.ConnectionOnProcess;
import com.intellij.cvsSupport2.errorHandling.ErrorRegistry;
import com.intellij.execution.configurations.GeneralCommandLine;
import java.io.IOException;
import java.util.StringTokenizer;
import org.netbeans.lib.cvsclient.connection.AuthenticationException;

public class LocalConnection
extends ConnectionOnProcess {
    private final LocalSettings myLocalSettings;

    public LocalConnection(String repository, LocalSettings localSettings, ErrorRegistry errorRegistry) {
        super(repository, errorRegistry);
        this.myLocalSettings = localSettings;
    }

    @Override
    public void open() throws AuthenticationException {
        if (!this.myLocalSettings.isCvsClientVerified()) {
            this.verifyServerCapability();
            this.myLocalSettings.setCvsClientVerified(true);
        }
        GeneralCommandLine commandLine = new GeneralCommandLine();
        commandLine.setExePath(this.myLocalSettings.PATH_TO_CVS_CLIENT);
        StringTokenizer st = new StringTokenizer(this.myLocalSettings.SERVER_COMMAND.trim());
        while (st.hasMoreTokens()) {
            commandLine.addParameter(st.nextToken());
        }
        this.execute(commandLine);
    }

    private void verifyServerCapability() throws AuthenticationException {
        GeneralCommandLine commandLine = new GeneralCommandLine();
        commandLine.setExePath(this.myLocalSettings.PATH_TO_CVS_CLIENT);
        commandLine.addParameter("-v");
        this.execute(commandLine);
        try {
            String[] lines;
            int c;
            StringBuilder responseBuilder = new StringBuilder();
            while ((c = this.myInputStream.read()) != -1) {
                responseBuilder.append((char)c);
            }
            for (String line : lines = responseBuilder.toString().split("\n")) {
                if (line.trim().endsWith("(client)")) {
                    throw new AuthenticationException("CVS client does not support server mode operation", null);
                }
                if (line.trim().length() <= 0) {
                    continue;
                }
                break;
            }
        }
        catch (IOException e) {
            throw new AuthenticationException("Can't read CVS version", (Throwable)e);
        }
        this.closeInternal();
    }
}

