/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.application;

import com.intellij.openapi.util.NamedJDOMExternalizable;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.SystemProperties;
import com.intellij.util.io.URLUtil;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.Properties;
import java.util.PropertyResourceBundle;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PathManager {
    @NonNls
    private static final String PROPERTIES_FILE = "idea.properties.file";
    @NonNls
    private static final String PROPERTY_SYSTEM_PATH = "idea.system.path";
    @NonNls
    private static final String PROPERTY_CONFIG_PATH = "idea.config.path";
    @NonNls
    private static final String PROPERTY_PLUGINS_PATH = "idea.plugins.path";
    @NonNls
    private static final String PROPERTY_HOME_PATH = "idea.home.path";
    @NonNls
    private static final String PROPERTY_LOG_PATH = "idea.log.path";
    @NonNls
    private static String ourHomePath;
    @NonNls
    private static String ourSystemPath;
    @NonNls
    private static String ourConfigPath;
    @NonNls
    private static String ourPluginsPath;
    @NonNls
    private static String ourLogPath;
    @NonNls
    private static final String FILE = "file";
    @NonNls
    private static final String JAR = "jar";
    @NonNls
    private static final String JAR_DELIMITER = "!";
    @NonNls
    private static final String PROTOCOL_DELIMITER = ":";
    @NonNls
    public static final String DEFAULT_OPTIONS_FILE_NAME = "other";
    @NonNls
    private static final String LIB_FOLDER = "lib";
    @NonNls
    public static final String PLUGINS_DIRECTORY = "plugins";
    @NonNls
    private static final String BIN_FOLDER = "bin";
    @NonNls
    private static final String LOG_DIRECTORY = "log";
    @NonNls
    private static final String OPTIONS_FOLDER = "options";

    public static String getHomePath() {
        if (ourHomePath != null) {
            return ourHomePath;
        }
        if (System.getProperty(PROPERTY_HOME_PATH) != null) {
            ourHomePath = PathManager.getAbsolutePath(System.getProperty(PROPERTY_HOME_PATH));
        } else {
            Class<PathManager> aClass = PathManager.class;
            String rootPath = PathManager.getResourceRoot(aClass, "/" + aClass.getName().replace('.', '/') + ".class");
            if (rootPath != null) {
                String parent;
                File root = new File(rootPath).getAbsoluteFile();
                do {
                    if ((parent = root.getParent()) == null) {
                        return null;
                    }
                    assert (parent != null) : "No parent found for " + root + "; " + "bin" + " folder with " + "idea.properties" + " file not found";
                } while ((root = new File(parent).getAbsoluteFile()) != null && !PathManager.isIdeaHome(root));
                ourHomePath = root != null ? root.getAbsolutePath() : null;
            }
        }
        try {
            if (!SystemInfo.isFileSystemCaseSensitive) {
                ourHomePath = ourHomePath == null ? null : new File(ourHomePath).getCanonicalPath();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return ourHomePath;
    }

    private static boolean isIdeaHome(File root) {
        return new File(root, FileUtil.toSystemDependentName("bin/idea.properties")).exists() || new File(root, FileUtil.toSystemDependentName("community/bin/idea.properties")).exists();
    }

    public static String getLibPath() {
        return PathManager.getHomePath() + File.separator + LIB_FOLDER;
    }

    private static String trimPathQuotes(String path) {
        if (path == null || path.length() < 3) {
            return path;
        }
        if (StringUtil.startsWithChar(path, '\"') && StringUtil.endsWithChar(path, '\"')) {
            return path.substring(1, path.length() - 1);
        }
        return path;
    }

    public static String getSystemPath() {
        if (ourSystemPath != null) {
            return ourSystemPath;
        }
        ourSystemPath = System.getProperty(PROPERTY_SYSTEM_PATH) != null ? PathManager.getAbsolutePath(PathManager.trimPathQuotes(System.getProperty(PROPERTY_SYSTEM_PATH))) : PathManager.getHomePath() + File.separator + "system";
        try {
            File file = new File(ourSystemPath);
            file.mkdirs();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ourSystemPath;
    }

    public static boolean ensureConfigFolderExists(boolean createIfNotExists) {
        PathManager.getConfigPathWithoutDialog();
        File file = new File(ourConfigPath);
        if (createIfNotExists && !file.exists()) {
            file.mkdirs();
            return true;
        }
        return false;
    }

    public static String getConfigPath(boolean createIfNotExists) {
        PathManager.ensureConfigFolderExists(createIfNotExists);
        return ourConfigPath;
    }

    public static String getConfigPath() {
        return PathManager.getConfigPath(true);
    }

    private static String getConfigPathWithoutDialog() {
        if (ourConfigPath != null) {
            return ourConfigPath;
        }
        ourConfigPath = System.getProperty(PROPERTY_CONFIG_PATH) != null ? PathManager.getAbsolutePath(PathManager.trimPathQuotes(System.getProperty(PROPERTY_CONFIG_PATH))) : PathManager.getHomePath() + File.separator + "config";
        return ourConfigPath;
    }

    public static String getBinPath() {
        return PathManager.getHomePath() + File.separator + BIN_FOLDER;
    }

    public static String getOptionsPath() {
        return PathManager.getConfigPath() + File.separator + OPTIONS_FOLDER;
    }

    public static String getOptionsPathWithoutDialog() {
        return PathManager.getConfigPathWithoutDialog() + File.separator + OPTIONS_FOLDER;
    }

    public static File getIndexRoot() {
        File file = new File(PathManager.getSystemPath(), "index");
        try {
            file = file.getCanonicalFile();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        file.mkdirs();
        return file;
    }

    public static String getPreinstalledPluginsPath() {
        return StringHolder.ourPreinstalledPluginsPath;
    }

    public static String getPluginsPath() {
        if (ourPluginsPath == null) {
            ourPluginsPath = System.getProperty(PROPERTY_PLUGINS_PATH) != null ? PathManager.getAbsolutePath(PathManager.trimPathQuotes(System.getProperty(PROPERTY_PLUGINS_PATH))) : PathManager.getConfigPath() + File.separatorChar + PLUGINS_DIRECTORY;
        }
        return ourPluginsPath;
    }

    public static String getLogPath() {
        if (ourLogPath == null) {
            ourLogPath = System.getProperty(PROPERTY_LOG_PATH) != null ? PathManager.getAbsolutePath(PathManager.trimPathQuotes(System.getProperty(PROPERTY_LOG_PATH))) : PathManager.getSystemPath() + File.separatorChar + LOG_DIRECTORY;
        }
        return ourLogPath;
    }

    private static String getAbsolutePath(String path) {
        if (path.startsWith("~/") || path.startsWith("~\\")) {
            path = SystemProperties.getUserHome() + path.substring(1);
        }
        return new File(path).getAbsolutePath();
    }

    @NonNls
    public static File getOptionsFile(NamedJDOMExternalizable externalizable) {
        return new File(PathManager.getOptionsPath() + File.separatorChar + externalizable.getExternalFileName() + ".xml");
    }

    @NonNls
    public static File getOptionsFile(@NonNls String fileName) {
        return new File(PathManager.getOptionsPath() + File.separatorChar + fileName + ".xml");
    }

    @Nullable
    public static String getResourceRoot(Class context, @NonNls String path) {
        URL url = context.getResource(path);
        if (url == null) {
            url = ClassLoader.getSystemResource(path.substring(1));
        }
        if (url == null) {
            return null;
        }
        return PathManager.extractRoot(url, path);
    }

    @NonNls
    private static String extractRoot(URL resourceURL, String resourcePath) {
        String archivePath;
        String fullPath;
        int delimiter;
        if (!StringUtil.startsWithChar(resourcePath, '/') && !StringUtil.startsWithChar(resourcePath, '\\')) {
            System.err.println("precondition failed: " + resourcePath);
            return null;
        }
        String protocol = resourceURL.getProtocol();
        String resultPath = null;
        if (FILE.equals(protocol)) {
            String testResourcePath;
            String path = resourceURL.getFile();
            String testPath = path.replace('\\', '/');
            if (StringUtil.endsWithIgnoreCase(testPath, testResourcePath = resourcePath.replace('\\', '/'))) {
                resultPath = path.substring(0, path.length() - resourcePath.length());
            }
        } else if (JAR.equals(protocol) && (delimiter = (fullPath = resourceURL.getFile()).indexOf(JAR_DELIMITER)) >= 0 && StringUtil.startsWithConcatenationOf(archivePath = fullPath.substring(0, delimiter), FILE, PROTOCOL_DELIMITER)) {
            resultPath = archivePath.substring(FILE.length() + PROTOCOL_DELIMITER.length());
        }
        if (resultPath == null) {
            System.err.println("cannot extract: " + resultPath + " from " + resourceURL);
            return null;
        }
        resultPath = StringUtil.trimEnd(resultPath, File.separator);
        resultPath = URLUtil.unescapePercentSequences(resultPath);
        return resultPath;
    }

    @NonNls
    public static File getDefaultOptionsFile() {
        return new File(PathManager.getOptionsPath(), "other.xml");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void loadProperties() {
        File propFile = FileUtil.findFirstThatExist(System.getProperty(PROPERTIES_FILE), SystemProperties.getUserHome() + "/idea.properties", PathManager.getHomePath() + "/bin/idea.properties", PathManager.getHomePath() + "/community/bin/idea.properties");
        if (propFile != null) {
            InputStream fis = null;
            try {
                fis = new BufferedInputStream(new FileInputStream(propFile));
                PropertyResourceBundle bundle = new PropertyResourceBundle(fis);
                Enumeration<String> keys = bundle.getKeys();
                String home = (String)bundle.handleGetObject("idea.home");
                if (home != null && ourHomePath == null) {
                    ourHomePath = PathManager.getAbsolutePath(PathManager.substitueVars(home));
                }
                Properties sysProperties = System.getProperties();
                while (keys.hasMoreElements()) {
                    String key = keys.nextElement();
                    if (sysProperties.getProperty(key, null) != null) continue;
                    String value = PathManager.substitueVars(bundle.getString(key));
                    sysProperties.setProperty(key, value);
                }
            }
            catch (IOException e) {
                System.err.println("Problem reading from property file: " + propFile.getPath());
            }
            finally {
                try {
                    if (fis != null) {
                        fis.close();
                    }
                }
                catch (IOException iOException) {}
            }
        }
    }

    public static String substitueVars(String s) {
        String ideaHomePath = PathManager.getHomePath();
        return PathManager.substituteVars(s, ideaHomePath);
    }

    public static String substituteVars(String s, String ideaHomePath) {
        if (s == null) {
            return null;
        }
        if (s.startsWith("..")) {
            s = ideaHomePath + File.separatorChar + BIN_FOLDER + File.separatorChar + s;
        }
        s = StringUtil.replace(s, "${idea.home}", ideaHomePath);
        Properties props = System.getProperties();
        Set<Object> keys = props.keySet();
        for (Object key1 : keys) {
            String key = (String)key1;
            String value = props.getProperty(key);
            s = StringUtil.replace(s, "${" + key + "}", value);
        }
        return s;
    }

    public static String getPluginTempPath() {
        String systemPath = PathManager.getSystemPath();
        return systemPath + File.separator + PLUGINS_DIRECTORY;
    }

    public static File findFileInLibDirectory(@NotNull String relativePath) {
        if (relativePath == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/application/PathManager.findFileInLibDirectory must not be null");
        }
        File file = new File(PathManager.getLibPath() + File.separator + relativePath);
        if (file.exists()) {
            return file;
        }
        return new File(PathManager.getHomePath() + File.separator + "community" + File.separator + LIB_FOLDER + File.separator + relativePath);
    }

    private static class StringHolder {
        private static final String ourPreinstalledPluginsPath = PathManager.getHomePath() + File.separatorChar + "plugins";

        private StringHolder() {
        }
    }
}

