/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.graph;

import com.intellij.openapi.util.Pair;
import com.intellij.util.graph.Graph;
import gnu.trove.TIntArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;

public class DFSTBuilder<Node> {
    private final Graph<Node> myGraph;
    private final Map<Node, Integer> myNodeToNNumber;
    private Map<Node, Integer> myNodeToTNumber;
    private final Node[] myInvN;
    private Pair<Node, Node> myBackEdge = null;
    private Comparator<Node> myComparator = null;
    private boolean myNBuilt = false;
    private boolean myTBuilt = false;
    private TIntArrayList mySCCs = null;
    private Node[] myInvT;

    public DFSTBuilder(Graph<Node> graph) {
        this.myGraph = graph;
        this.myNodeToNNumber = new LinkedHashMap<Node, Integer>(this.myGraph.getNodes().size());
        this.myInvN = new Object[this.myGraph.getNodes().size()];
    }

    public void buildDFST() {
        if (this.myNBuilt) {
            return;
        }
        Collection<Node> nodes = this.myGraph.getNodes();
        int indexN = nodes.size();
        LinkedHashSet processed = new LinkedHashSet();
        for (Node node : nodes) {
            if (this.myGraph.getIn(node).hasNext()) continue;
            indexN = this.traverseSubGraph(node, indexN, processed);
        }
        for (Node node : nodes) {
            indexN = this.traverseSubGraph(node, indexN, processed);
        }
        this.myNBuilt = true;
    }

    public Comparator<Node> comparator() {
        if (this.myComparator == null) {
            this.buildDFST();
            if (this.isAcyclic()) {
                this.myComparator = new Comparator<Node>(){

                    @Override
                    public int compare(Node t, Node t1) {
                        return ((Integer)DFSTBuilder.this.myNodeToNNumber.get(t)).compareTo((Integer)DFSTBuilder.this.myNodeToNNumber.get(t1));
                    }
                };
            } else {
                this.build_T();
                this.myComparator = new Comparator<Node>(){

                    @Override
                    public int compare(Node t, Node t1) {
                        return ((Integer)DFSTBuilder.this.myNodeToTNumber.get(t)).compareTo((Integer)DFSTBuilder.this.myNodeToTNumber.get(t1));
                    }
                };
            }
        }
        return this.myComparator;
    }

    private int traverseSubGraph(Node node, int nNumber, Set<Node> processed) {
        if (!processed.contains(node)) {
            processed.add(node);
            Iterator<Node> it = this.myGraph.getOut(node);
            while (it.hasNext()) {
                nNumber = this.traverseSubGraph(it.next(), nNumber, processed);
            }
            this.myNodeToNNumber.put(node, --nNumber);
            this.myInvN[nNumber] = node;
            if (this.myBackEdge == null) {
                it = this.myGraph.getIn(node);
                while (it.hasNext()) {
                    Node prev = it.next();
                    Integer prevNumber = this.myNodeToNNumber.get(prev);
                    if (prevNumber == null || prevNumber <= nNumber) continue;
                    this.myBackEdge = new Pair<Node, Node>(node, prev);
                    break;
                }
            }
        }
        return nNumber;
    }

    private Set<Node> region(Node v) {
        LinkedList<Node> frontier = new LinkedList<Node>();
        frontier.addFirst(v);
        LinkedHashSet result = new LinkedHashSet();
        int number = this.myNodeToNNumber.get(v);
        while (!frontier.isEmpty()) {
            Object curr = frontier.removeFirst();
            result.add(curr);
            Iterator<Node> it = this.myGraph.getIn(curr);
            while (it.hasNext()) {
                Node w = it.next();
                if (this.myNodeToNNumber.get(w) <= number || result.contains(w)) continue;
                frontier.add(w);
            }
        }
        return result;
    }

    private void build_T() {
        if (this.myTBuilt) {
            return;
        }
        this.myInvT = new Object[this.myGraph.getNodes().size()];
        this.mySCCs = new TIntArrayList();
        int size = this.myGraph.getNodes().size();
        this.myNodeToTNumber = new LinkedHashMap<Node, Integer>(size);
        int currT = 0;
        for (int i = 0; i < size; ++i) {
            Node v = this.myInvN[i];
            if (this.myNodeToTNumber.containsKey(v)) continue;
            Set<Node> region = this.region(v);
            this.mySCCs.add(region.size());
            this.myNodeToTNumber.put(v, currT);
            this.myInvT[currT++] = v;
            for (Node w : region) {
                if (w == v) continue;
                this.myNodeToTNumber.put(w, currT);
                this.myInvT[currT++] = w;
            }
        }
        this.myTBuilt = true;
    }

    public Pair<Node, Node> getCircularDependency() {
        this.buildDFST();
        return this.myBackEdge;
    }

    public boolean isAcyclic() {
        return this.getCircularDependency() == null;
    }

    public Node getNodeByNNumber(int n) {
        return this.myInvN[n];
    }

    public Node getNodeByTNumber(int n) {
        return this.myInvT[n];
    }

    public TIntArrayList getSCCs() {
        if (!this.myNBuilt) {
            this.buildDFST();
        }
        if (!this.myTBuilt) {
            this.build_T();
        }
        return this.mySCCs;
    }
}

