/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.messages.impl;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.ConcurrencyUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.messages.MessageBus;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import com.intellij.util.messages.impl.Message;
import com.intellij.util.messages.impl.MessageBusConnectionImpl;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Iterator;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;

public class MessageBusImpl
implements MessageBus {
    private final ThreadLocal<Queue<DeliveryJob>> myMessageQueue = new ThreadLocal<Queue<DeliveryJob>>(){

        @Override
        protected Queue<DeliveryJob> initialValue() {
            return new ConcurrentLinkedQueue<DeliveryJob>();
        }
    };
    private final ConcurrentMap<Topic, Object> mySyncPublishers = new ConcurrentHashMap<Topic, Object>();
    private final ConcurrentMap<Topic, Object> myAsyncPublishers = new ConcurrentHashMap<Topic, Object>();
    private final ConcurrentMap<Topic, List<MessageBusConnectionImpl>> mySubscribers = new ConcurrentHashMap<Topic, List<MessageBusConnectionImpl>>();
    private final List<MessageBusImpl> myChildBusses = ContainerUtil.createEmptyCOWList();
    private static final Object NA = new Object();
    private final MessageBusImpl myParentBus;
    private final Object myOwner;

    public MessageBusImpl() {
        this(null, null);
    }

    public MessageBusImpl(Object owner, MessageBus parentBus) {
        this.myOwner = owner;
        this.myParentBus = (MessageBusImpl)parentBus;
        if (this.myParentBus != null) {
            this.myParentBus.notifyChildBusCreated(this);
        }
    }

    private void notifyChildBusCreated(MessageBusImpl messageBus) {
        this.myChildBusses.add(messageBus);
    }

    private void notifyChildBusDisposed(MessageBusImpl bus) {
        this.myChildBusses.remove(bus);
    }

    @Override
    public MessageBusConnection connect() {
        return new MessageBusConnectionImpl(this);
    }

    @Override
    public MessageBusConnection connect(Disposable parentDisposable) {
        MessageBusConnection connection = this.connect();
        Disposer.register(parentDisposable, connection);
        return connection;
    }

    @Override
    public <L> L syncPublisher(final Topic<L> topic) {
        Object publisher = this.mySyncPublishers.get(topic);
        if (publisher == null) {
            Class<L> listenerClass = topic.getListenerClass();
            InvocationHandler handler = new InvocationHandler(){

                @Override
                public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                    MessageBusImpl.this.sendMessage(new Message(topic, method, args));
                    return NA;
                }
            };
            publisher = Proxy.newProxyInstance(listenerClass.getClassLoader(), new Class[]{listenerClass}, handler);
            publisher = ConcurrencyUtil.cacheOrGet(this.mySyncPublishers, topic, publisher);
        }
        return (L)publisher;
    }

    @Override
    public <L> L asyncPublisher(final Topic<L> topic) {
        Object publisher = this.myAsyncPublishers.get(topic);
        if (publisher == null) {
            Class<L> listenerClass = topic.getListenerClass();
            InvocationHandler handler = new InvocationHandler(){

                @Override
                public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                    MessageBusImpl.this.postMessage(new Message(topic, method, args));
                    return NA;
                }
            };
            publisher = Proxy.newProxyInstance(listenerClass.getClassLoader(), new Class[]{listenerClass}, handler);
            publisher = ConcurrencyUtil.cacheOrGet(this.myAsyncPublishers, topic, publisher);
        }
        return (L)publisher;
    }

    @Override
    public void dispose() {
        this.myMessageQueue.get().clear();
        this.myMessageQueue.remove();
        if (this.myParentBus != null) {
            this.myParentBus.notifyChildBusDisposed(this);
        }
    }

    private void postMessage(Message message) {
        Topic.BroadcastDirection direction;
        Topic topic = message.getTopic();
        List topicSubscribers = (List)this.mySubscribers.get(topic);
        if (topicSubscribers != null) {
            for (MessageBusConnectionImpl subscriber : topicSubscribers) {
                this.myMessageQueue.get().offer(new DeliveryJob(subscriber, message));
                subscriber.scheduleMessageDelivery(message);
            }
        }
        if ((direction = topic.getBroadcastDirection()) == Topic.BroadcastDirection.TO_CHILDREN) {
            for (MessageBusImpl childBus : this.myChildBusses) {
                childBus.postMessage(message);
            }
        }
        if (direction == Topic.BroadcastDirection.TO_PARENT && this.myParentBus != null) {
            this.myParentBus.postMessage(message);
        }
    }

    private void sendMessage(Message message) {
        this.pumpMessages();
        this.postMessage(message);
        this.pumpMessages();
    }

    private void pumpMessages() {
        if (this.myParentBus != null) {
            this.myParentBus.pumpMessages();
        } else {
            this.doPumpMessages();
        }
    }

    private void doPumpMessages() {
        DeliveryJob job;
        while ((job = this.myMessageQueue.get().poll()) != null) {
            job.connection.deliverMessage(job.message);
        }
        for (MessageBusImpl childBus : this.myChildBusses) {
            childBus.doPumpMessages();
        }
    }

    public void notifyOnSubscription(MessageBusConnectionImpl connection, Topic topic) {
        List<Object> topicSubscribers = (CopyOnWriteArrayList)this.mySubscribers.get(topic);
        if (topicSubscribers == null) {
            topicSubscribers = ContainerUtil.createEmptyCOWList();
            topicSubscribers = ConcurrencyUtil.cacheOrGet(this.mySubscribers, topic, topicSubscribers);
        }
        topicSubscribers.add(connection);
    }

    public void notifyConnectionTerminated(MessageBusConnectionImpl connection) {
        for (List topicSubscribers : this.mySubscribers.values()) {
            topicSubscribers.remove(connection);
        }
        Iterator i = this.myMessageQueue.get().iterator();
        while (i.hasNext()) {
            DeliveryJob job = (DeliveryJob)i.next();
            if (job.connection != connection) continue;
            i.remove();
        }
    }

    public void deliverSingleMessage() {
        DeliveryJob job = this.myMessageQueue.get().poll();
        if (job == null) {
            return;
        }
        job.connection.deliverMessage(job.message);
    }

    private static class DeliveryJob {
        public final MessageBusConnectionImpl connection;
        public final Message message;

        public DeliveryJob(MessageBusConnectionImpl connection, Message message) {
            this.connection = connection;
            this.message = message;
        }
    }
}

