/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ipp.asserttoif;

import com.intellij.psi.PsiAssertStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.ipp.asserttoif.AssertStatementPredicate;
import com.siyeh.ipp.base.Intention;
import com.siyeh.ipp.base.PsiElementPredicate;
import com.siyeh.ipp.psiutils.BoolUtils;
import org.jetbrains.annotations.NotNull;

public class AssertToIfIntention
extends Intention {
    @Override
    @NotNull
    protected PsiElementPredicate getElementPredicate() {
        AssertStatementPredicate assertStatementPredicate = new AssertStatementPredicate();
        if (assertStatementPredicate == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ipp/asserttoif/AssertToIfIntention.getElementPredicate must not return null");
        }
        return assertStatementPredicate;
    }

    @Override
    public void processIntention(PsiElement element) throws IncorrectOperationException {
        PsiAssertStatement assertStatement = (PsiAssertStatement)element;
        assert (assertStatement != null);
        PsiExpression condition = assertStatement.getAssertCondition();
        PsiExpression description = assertStatement.getAssertDescription();
        String negatedConditionString = BoolUtils.getNegatedExpressionText(condition);
        String newStatement = description == null ? "if(" + negatedConditionString + "){ throw new IllegalArgumentException();}" : "if(" + negatedConditionString + "){ throw new IllegalArgumentException(" + description.getText() + ");}";
        AssertToIfIntention.replaceStatement(newStatement, (PsiStatement)assertStatement);
    }
}

