/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ipp.forloop;

import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiForStatement;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.tree.IElementType;
import com.siyeh.ipp.base.PsiElementPredicate;
import com.siyeh.ipp.psiutils.VariableAccessUtils;

public class ReverseForLoopDirectionPredicate
implements PsiElementPredicate {
    @Override
    public boolean satisfiedBy(PsiElement element) {
        if (!(element instanceof PsiJavaToken)) {
            return false;
        }
        PsiJavaToken keyword = (PsiJavaToken)element;
        IElementType tokenType = keyword.getTokenType();
        if (!JavaTokenType.FOR_KEYWORD.equals(tokenType)) {
            return false;
        }
        PsiElement parent = keyword.getParent();
        if (!(parent instanceof PsiForStatement)) {
            return false;
        }
        PsiForStatement forStatement = (PsiForStatement)parent;
        PsiStatement initialization = forStatement.getInitialization();
        if (!(initialization instanceof PsiDeclarationStatement)) {
            return false;
        }
        PsiDeclarationStatement declarationStatement = (PsiDeclarationStatement)initialization;
        PsiElement[] declaredElements = declarationStatement.getDeclaredElements();
        if (declaredElements.length != 1) {
            return false;
        }
        PsiElement declaredElement = declaredElements[0];
        if (!(declaredElement instanceof PsiLocalVariable)) {
            return false;
        }
        PsiVariable variable = (PsiVariable)declaredElement;
        PsiType type = variable.getType();
        if (!PsiType.INT.equals(type) && !PsiType.LONG.equals(type)) {
            return false;
        }
        PsiExpression condition = forStatement.getCondition();
        if (!VariableAccessUtils.isVariableCompared(variable, condition)) {
            return false;
        }
        PsiStatement update = forStatement.getUpdate();
        return VariableAccessUtils.isVariableIncrementOrDecremented(variable, update);
    }
}

