/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.properties;

import com.intellij.codeInsight.CodeInsightUtilBase;
import com.intellij.lang.properties.PropertiesBundle;
import com.intellij.lang.properties.ResourceBundle;
import com.intellij.lang.properties.editor.ResourceBundleAsVirtualFile;
import com.intellij.lang.properties.psi.PropertiesFile;
import com.intellij.lang.properties.psi.Property;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.InputValidator;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.refactoring.rename.RenameHandler;
import com.intellij.refactoring.rename.RenameProcessor;
import java.io.File;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ResourceBundleRenameHandler
implements RenameHandler {
    public boolean isAvailableOnDataContext(DataContext dataContext) {
        Project project = (Project)PlatformDataKeys.PROJECT.getData(dataContext);
        if (project == null) {
            return false;
        }
        ResourceBundle bundle = ResourceBundleRenameHandler.getResourceBundleFromDataContext(dataContext);
        return bundle != null && bundle.getPropertiesFiles(project).size() > 1;
    }

    public boolean isRenaming(DataContext dataContext) {
        return this.isAvailableOnDataContext(dataContext);
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file, DataContext dataContext) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/lang/properties/ResourceBundleRenameHandler.invoke must not be null");
        }
        ResourceBundle resourceBundle = ResourceBundleRenameHandler.getResourceBundleFromDataContext(dataContext);
        assert (resourceBundle != null);
        Messages.showInputDialog((Project)project, (String)PropertiesBundle.message("rename.bundle.enter.new.resource.bundle.base.name.prompt.text", new Object[0]), (String)PropertiesBundle.message("rename.resource.bundle.dialog.title", new Object[0]), (Icon)Messages.getQuestionIcon(), (String)resourceBundle.getBaseName(), (InputValidator)new MyInputValidator(project, resourceBundle));
    }

    public void invoke(@NotNull Project project, @NotNull PsiElement[] elements, DataContext dataContext) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/lang/properties/ResourceBundleRenameHandler.invoke must not be null");
        }
        if (elements == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/lang/properties/ResourceBundleRenameHandler.invoke must not be null");
        }
        this.invoke(project, null, null, dataContext);
    }

    @Nullable
    private static ResourceBundle getResourceBundleFromDataContext(DataContext dataContext) {
        PsiFile psiFile;
        PsiElement element = (PsiElement)LangDataKeys.PSI_ELEMENT.getData(dataContext);
        if (element instanceof Property) {
            return null;
        }
        VirtualFile virtualFile = (VirtualFile)PlatformDataKeys.VIRTUAL_FILE.getData(dataContext);
        if (virtualFile == null) {
            return null;
        }
        if (virtualFile instanceof ResourceBundleAsVirtualFile) {
            return ((ResourceBundleAsVirtualFile)virtualFile).getResourceBundle();
        }
        Project project = (Project)PlatformDataKeys.PROJECT.getData(dataContext);
        if (project != null && (psiFile = PsiManager.getInstance((Project)project).findFile(virtualFile)) instanceof PropertiesFile) {
            return ((PropertiesFile)psiFile).getResourceBundle();
        }
        return null;
    }

    private static class MyInputValidator
    implements InputValidator {
        private final Project myProject;
        private final ResourceBundle myResourceBundle;

        public MyInputValidator(Project project, ResourceBundle resourceBundle) {
            this.myProject = project;
            this.myResourceBundle = resourceBundle;
        }

        public boolean checkInput(String inputString) {
            return inputString.indexOf(File.separatorChar) < 0 && inputString.indexOf(47) < 0;
        }

        public boolean canClose(String inputString) {
            return this.doRename(inputString);
        }

        private boolean doRename(String inputString) {
            List<PropertiesFile> propertiesFiles = this.myResourceBundle.getPropertiesFiles(this.myProject);
            for (PropertiesFile propertiesFile : propertiesFiles) {
                if (CodeInsightUtilBase.prepareFileForWrite((PsiFile)propertiesFile)) continue;
                return false;
            }
            RenameProcessor renameProcessor = new RenameProcessor(this.myProject);
            String baseName = this.myResourceBundle.getBaseName();
            for (PropertiesFile propertiesFile : propertiesFiles) {
                VirtualFile virtualFile = propertiesFile.getVirtualFile();
                String newName = inputString + virtualFile.getNameWithoutExtension().substring(baseName.length()) + "." + virtualFile.getExtension();
                renameProcessor.addElement((PsiElement)propertiesFile, newName);
            }
            renameProcessor.setCommandName(PropertiesBundle.message("rename.resource.bundle.dialog.title", new Object[0]));
            renameProcessor.doRun();
            return true;
        }
    }
}

