/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.properties.references;

import com.intellij.codeInsight.daemon.QuickFixProvider;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.quickfix.QuickFixAction;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.LocalQuickFixProvider;
import com.intellij.lang.properties.psi.PropertiesFile;
import com.intellij.lang.properties.references.CreatePropertyFix;
import com.intellij.lang.properties.references.I18nUtil;
import com.intellij.lang.properties.references.PropertyReferenceBase;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PropertyReference
extends PropertyReferenceBase
implements QuickFixProvider,
LocalQuickFixProvider {
    @Nullable
    private final String myBundleName;

    public PropertyReference(@NotNull String key, @NotNull PsiElement element, String bundleName, boolean soft, TextRange range) {
        if (key == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/lang/properties/references/PropertyReference.<init> must not be null");
        }
        if (element == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/lang/properties/references/PropertyReference.<init> must not be null");
        }
        super(key, soft, element, range);
        this.myBundleName = bundleName;
    }

    public PropertyReference(@NotNull String key, @NotNull PsiElement element, @Nullable String bundleName, boolean soft) {
        if (key == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/lang/properties/references/PropertyReference.<init> must not be null");
        }
        if (element == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/lang/properties/references/PropertyReference.<init> must not be null");
        }
        super(key, soft, element);
        this.myBundleName = bundleName;
    }

    @Override
    @Nullable
    protected List<PropertiesFile> getPropertiesFiles() {
        if (this.myBundleName == null) {
            return null;
        }
        return this.retrievePropertyFilesByBundleName(this.myBundleName, this.myElement);
    }

    protected List<PropertiesFile> retrievePropertyFilesByBundleName(String bundleName, PsiElement element) {
        return I18nUtil.propertiesFilesByBundleName(bundleName, element);
    }

    public void registerQuickfix(HighlightInfo info, PsiReference reference) {
        List<PropertiesFile> propertiesFiles = this.retrievePropertyFilesByBundleName(this.myBundleName, reference.getElement());
        CreatePropertyFix fix = new CreatePropertyFix(this.myElement, this.myKey, propertiesFiles);
        QuickFixAction.registerQuickFixAction((HighlightInfo)info, (IntentionAction)fix);
    }

    public LocalQuickFix[] getQuickFixes() {
        List<PropertiesFile> propertiesFiles = this.retrievePropertyFilesByBundleName(this.myBundleName, this.getElement());
        CreatePropertyFix fix = new CreatePropertyFix(this.myElement, this.myKey, propertiesFiles);
        return new LocalQuickFix[]{fix};
    }
}

