/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.generate.tostring.element;

import java.io.Serializable;
import org.jetbrains.generate.tostring.config.FilterPattern;
import org.jetbrains.generate.tostring.config.Filterable;
import org.jetbrains.generate.tostring.element.AbstractElement;
import org.jetbrains.generate.tostring.element.Element;
import org.jetbrains.generate.tostring.util.StringUtil;

public class MethodElement
extends AbstractElement
implements Serializable,
Element,
Filterable {
    private String methodName;
    private String fieldName;
    private boolean modifierAbstract;
    private boolean modifierSynchronzied;
    private boolean returnTypeVoid;
    private boolean getter;
    private boolean deprecated;

    public String getMethodName() {
        return this.methodName;
    }

    public void setMethodName(String methodName) {
        this.methodName = methodName;
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public void setFieldName(String fieldName) {
        this.fieldName = fieldName;
    }

    @Override
    public String getAccessor() {
        return this.methodName + "()";
    }

    public boolean isModifierAbstract() {
        return this.modifierAbstract;
    }

    public void setModifierAbstract(boolean modifierAbstract) {
        this.modifierAbstract = modifierAbstract;
    }

    public boolean isModifierSynchronzied() {
        return this.modifierSynchronzied;
    }

    public void setModifierSynchronzied(boolean modifierSynchronzied) {
        this.modifierSynchronzied = modifierSynchronzied;
    }

    public boolean isReturnTypeVoid() {
        return this.returnTypeVoid;
    }

    public void setReturnTypeVoid(boolean returnTypeVoid) {
        this.returnTypeVoid = returnTypeVoid;
    }

    public boolean isGetter() {
        return this.getter;
    }

    public void setGetter(boolean getter) {
        this.getter = getter;
    }

    public boolean isDeprecated() {
        return this.deprecated;
    }

    public void setDeprecated(boolean deprecated) {
        this.deprecated = deprecated;
    }

    public boolean matchName(String regexp) throws IllegalArgumentException {
        if (StringUtil.isEmpty(regexp)) {
            throw new IllegalArgumentException("Can't perform regular expression since the given input is empty. Check the Method body velocity code: regexp='" + regexp + "'");
        }
        return this.methodName.matches(regexp);
    }

    @Override
    public boolean applyFilter(FilterPattern pattern) {
        String type;
        if (pattern == null) {
            return false;
        }
        if (StringUtil.isNotEmpty(pattern.getMethodName()) && this.methodName.matches(pattern.getMethodName())) {
            return true;
        }
        return StringUtil.isNotEmpty(pattern.getMethodType()) && !this.returnTypeVoid && !this.isPrimitive && this.getTypeQualifiedName() != null && (type = this.getTypeQualifiedName()).matches(pattern.getMethodType());
    }

    @Override
    public String toString() {
        return super.toString() + " ::: MethodElement{" + "fieldName='" + this.fieldName + "'" + ", methodName='" + this.methodName + "'" + ", modifierAbstract=" + this.modifierAbstract + ", modifierSynchronzied=" + this.modifierSynchronzied + ", returnTypeVoid=" + this.returnTypeVoid + ", getter=" + this.getter + ", deprecated=" + this.deprecated + "}";
    }
}

