/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webdav.lib.search;

import java.io.StringWriter;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.xmlio.out.XMLEncode;
import org.apache.webdav.lib.PropertyName;
import org.apache.webdav.lib.search.SearchBuilder;
import org.apache.webdav.lib.search.SearchException;
import org.apache.webdav.lib.search.SearchExpression;
import org.apache.webdav.lib.search.SearchRequest;
import org.apache.webdav.lib.search.SearchScope;
import org.apache.webdav.lib.search.expressions.AndExpression;
import org.apache.webdav.lib.search.expressions.CompareExpression;
import org.apache.webdav.lib.search.expressions.ContainsExpression;
import org.apache.webdav.lib.search.expressions.IsDefinedExpression;
import org.apache.webdav.lib.search.expressions.NotExpression;
import org.apache.webdav.lib.search.expressions.OrExpression;
import org.apache.webdav.lib.search.expressions.TestExpression;
import org.apache.webdav.lib.util.QName;

public class BasicSearchBuilder
implements SearchBuilder {
    private static DateFormat dateFormat = new SimpleDateFormat("EEE, d MMM yyyy kk:mm:ss z", Locale.US);
    private Map variables;
    private StringWriter writer;

    public String build(SearchRequest search, Map variables, List scopes) throws SearchException {
        this.variables = variables;
        this.writer = new StringWriter();
        this.writer.write("<D:searchrequest xmlns:D='DAV:'>\n");
        this.writer.write("<D:basicsearch>\n");
        BasicSearchBuilder.writeSelection(search, this.writer);
        BasicSearchBuilder.writeFrom(scopes, this.writer);
        if (search.getWhereExpression() != null) {
            this.writer.write("<D:where>\n");
            search.getWhereExpression().build(this);
            this.writer.write("</D:where>\n");
        }
        this.writer.write("</D:basicsearch>\n");
        this.writer.write("</D:searchrequest>\n");
        return this.writer.toString();
    }

    private static void writeSelection(SearchRequest search, StringWriter writer) {
        Iterator i = search.getSelection();
        if (i.hasNext()) {
            writer.write("<D:select><D:prop>\n");
            while (i.hasNext()) {
                writer.write("<");
                BasicSearchBuilder.writeQNameStart((PropertyName)i.next(), writer);
                writer.write("/>\n");
            }
            writer.write("</D:prop></D:select>\n");
        }
    }

    private static void writeFrom(List scopes, StringWriter writer) {
        writer.write("<D:from>\n");
        int l = scopes.size();
        for (int i = 0; i < l; ++i) {
            SearchScope scope = (SearchScope)scopes.get(i);
            writer.write("<D:scope><D:href>");
            writer.write(XMLEncode.xmlEncodeText((String)scope.getHref()));
            writer.write("</D:href><D:depth>");
            writer.write(scope.getDepthString());
            writer.write("</D:depth></D:scope>\n");
        }
        writer.write("</D:from>\n");
    }

    private static void writeQNameStart(QName name, StringWriter writer) {
        if (name.getNamespaceURI().equals("DAV:")) {
            writer.write("D:");
            writer.write(name.getLocalName());
        } else {
            writer.write(name.getLocalName());
            writer.write(" xmlns='");
            writer.write(name.getNamespaceURI());
            writer.write("'");
        }
    }

    private static void writeQNameEnd(QName name, StringWriter writer) {
        if (name.getNamespaceURI().equals("DAV:")) {
            writer.write("D:");
            writer.write(name.getLocalName());
        } else {
            writer.write(name.getLocalName());
        }
    }

    public void buildAnd(AndExpression and) throws SearchException {
        this.writer.write("<D:and>\n");
        Iterator i = and.getExpressions();
        while (i.hasNext()) {
            SearchExpression expression = (SearchExpression)i.next();
            expression.build(this);
        }
        this.writer.write("</D:and>\n");
    }

    public void buildOr(OrExpression or) throws SearchException {
        this.writer.write("<D:or>\n");
        Iterator i = or.getExpressions();
        while (i.hasNext()) {
            SearchExpression expression = (SearchExpression)i.next();
            expression.build(this);
        }
        this.writer.write("</D:or>\n");
    }

    public void buildNot(NotExpression expression) throws SearchException {
        this.writer.write("<D:not>\n");
        expression.getExpression().build(this);
        this.writer.write("</D:not>\n");
    }

    public void buildCompare(CompareExpression compare) throws SearchException {
        this.writer.write("<");
        BasicSearchBuilder.writeQNameStart(compare.getOperator(), this.writer);
        this.writer.write(">");
        this.writer.write("<D:prop><");
        BasicSearchBuilder.writeQNameStart(compare.getPropertyName(), this.writer);
        this.writer.write("/></D:prop>");
        this.writer.write("<D:literal>");
        this.writer.write(XMLEncode.xmlEncodeText((String)this.valueToString(compare.getValue())));
        this.writer.write("</D:literal>");
        this.writer.write("</");
        BasicSearchBuilder.writeQNameEnd(compare.getOperator(), this.writer);
        this.writer.write(">\n");
    }

    public void buildContains(ContainsExpression contains) throws SearchException {
        this.writer.write("<D:contains>");
        this.writer.write(XMLEncode.xmlEncodeText((String)contains.getText()));
        this.writer.write("</D:contains>\n");
    }

    public void buildIsdefined(IsDefinedExpression expression) throws SearchException {
        this.writer.write("<D:is-defined><D:prop><");
        BasicSearchBuilder.writeQNameStart(expression.getPropertyName(), this.writer);
        this.writer.write("/></D:prop></D:is-defined>\n");
    }

    public void buildTest(TestExpression expression) throws SearchException {
        this.writer.write("<");
        if (expression.getNamespace().equals("DAV:")) {
            this.writer.write("D:");
            this.writer.write(expression.getLocalName());
        } else {
            this.writer.write(expression.getLocalName());
            this.writer.write(" xmlns='");
            this.writer.write(expression.getNamespace());
            this.writer.write("'");
        }
        this.writer.write("/>");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String valueToString(Object value) throws SearchException {
        if (value instanceof Date) {
            DateFormat dateFormat = BasicSearchBuilder.dateFormat;
            synchronized (dateFormat) {
                return BasicSearchBuilder.dateFormat.format((Date)value);
            }
        }
        if (value instanceof SearchRequest.Variable) {
            SearchRequest.Variable var = (SearchRequest.Variable)value;
            Object val = this.variables.get(var.getName());
            if (val == null) {
                val = var.getDefaultValue();
            }
            if (val == null) {
                throw new SearchException("Unset variable: " + var.getName());
            }
            return this.valueToString(val);
        }
        return value.toString();
    }
}

