/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.example.debug.bdi;

import com.sun.jdi.ReferenceType;
import com.sun.jdi.VirtualMachine;
import com.sun.jdi.request.EventRequest;
import com.sun.tools.example.debug.bdi.AccessWatchpointSpec;
import com.sun.tools.example.debug.bdi.BreakpointSpec;
import com.sun.tools.example.debug.bdi.EventRequestSpec;
import com.sun.tools.example.debug.bdi.ExceptionSpec;
import com.sun.tools.example.debug.bdi.ExecutionManager;
import com.sun.tools.example.debug.bdi.LineBreakpointSpec;
import com.sun.tools.example.debug.bdi.MethodBreakpointSpec;
import com.sun.tools.example.debug.bdi.ModificationWatchpointSpec;
import com.sun.tools.example.debug.bdi.PatternReferenceTypeSpec;
import com.sun.tools.example.debug.bdi.SourceNameReferenceTypeSpec;
import com.sun.tools.example.debug.bdi.SpecErrorEvent;
import com.sun.tools.example.debug.bdi.SpecEvent;
import com.sun.tools.example.debug.bdi.SpecListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Vector;

class EventRequestSpecList {
    private List<EventRequestSpec> eventRequestSpecs = Collections.synchronizedList(new ArrayList());
    final ExecutionManager runtime;

    EventRequestSpecList(ExecutionManager executionManager) {
        this.runtime = executionManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void resolve(ReferenceType referenceType) {
        List<EventRequestSpec> list = this.eventRequestSpecs;
        synchronized (list) {
            for (EventRequestSpec eventRequestSpec : this.eventRequestSpecs) {
                eventRequestSpec.attemptResolve(referenceType);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void install(EventRequestSpec eventRequestSpec, VirtualMachine virtualMachine) {
        List<EventRequestSpec> list = this.eventRequestSpecs;
        synchronized (list) {
            this.eventRequestSpecs.add(eventRequestSpec);
        }
        if (virtualMachine != null) {
            eventRequestSpec.attemptImmediateResolve(virtualMachine);
        }
    }

    BreakpointSpec createClassLineBreakpoint(String string, int n) {
        PatternReferenceTypeSpec patternReferenceTypeSpec = new PatternReferenceTypeSpec(string);
        return new LineBreakpointSpec(this, patternReferenceTypeSpec, n);
    }

    BreakpointSpec createSourceLineBreakpoint(String string, int n) {
        SourceNameReferenceTypeSpec sourceNameReferenceTypeSpec = new SourceNameReferenceTypeSpec(string, n);
        return new LineBreakpointSpec(this, sourceNameReferenceTypeSpec, n);
    }

    BreakpointSpec createMethodBreakpoint(String string, String string2, List<String> list) {
        PatternReferenceTypeSpec patternReferenceTypeSpec = new PatternReferenceTypeSpec(string);
        return new MethodBreakpointSpec(this, patternReferenceTypeSpec, string2, list);
    }

    ExceptionSpec createExceptionIntercept(String string, boolean bl, boolean bl2) {
        PatternReferenceTypeSpec patternReferenceTypeSpec = new PatternReferenceTypeSpec(string);
        return new ExceptionSpec(this, patternReferenceTypeSpec, bl, bl2);
    }

    AccessWatchpointSpec createAccessWatchpoint(String string, String string2) {
        PatternReferenceTypeSpec patternReferenceTypeSpec = new PatternReferenceTypeSpec(string);
        return new AccessWatchpointSpec(this, patternReferenceTypeSpec, string2);
    }

    ModificationWatchpointSpec createModificationWatchpoint(String string, String string2) {
        PatternReferenceTypeSpec patternReferenceTypeSpec = new PatternReferenceTypeSpec(string);
        return new ModificationWatchpointSpec(this, patternReferenceTypeSpec, string2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void delete(EventRequestSpec eventRequestSpec) {
        EventRequest eventRequest = eventRequestSpec.getEventRequest();
        List<EventRequestSpec> list = this.eventRequestSpecs;
        synchronized (list) {
            this.eventRequestSpecs.remove(eventRequestSpec);
        }
        if (eventRequest != null) {
            eventRequest.virtualMachine().eventRequestManager().deleteEventRequest(eventRequest);
        }
        this.notifyDeleted(eventRequestSpec);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<EventRequestSpec> eventRequestSpecs() {
        List<EventRequestSpec> list = this.eventRequestSpecs;
        synchronized (list) {
            return new ArrayList<EventRequestSpec>(this.eventRequestSpecs);
        }
    }

    private Vector<SpecListener> specListeners() {
        return (Vector)this.runtime.specListeners.clone();
    }

    void notifySet(EventRequestSpec eventRequestSpec) {
        Vector<SpecListener> vector = this.specListeners();
        SpecEvent specEvent = new SpecEvent(eventRequestSpec);
        for (int i = 0; i < vector.size(); ++i) {
            eventRequestSpec.notifySet(vector.elementAt(i), specEvent);
        }
    }

    void notifyDeferred(EventRequestSpec eventRequestSpec) {
        Vector<SpecListener> vector = this.specListeners();
        SpecEvent specEvent = new SpecEvent(eventRequestSpec);
        for (int i = 0; i < vector.size(); ++i) {
            eventRequestSpec.notifyDeferred(vector.elementAt(i), specEvent);
        }
    }

    void notifyDeleted(EventRequestSpec eventRequestSpec) {
        Vector<SpecListener> vector = this.specListeners();
        SpecEvent specEvent = new SpecEvent(eventRequestSpec);
        for (int i = 0; i < vector.size(); ++i) {
            eventRequestSpec.notifyDeleted(vector.elementAt(i), specEvent);
        }
    }

    void notifyResolved(EventRequestSpec eventRequestSpec) {
        Vector<SpecListener> vector = this.specListeners();
        SpecEvent specEvent = new SpecEvent(eventRequestSpec);
        for (int i = 0; i < vector.size(); ++i) {
            eventRequestSpec.notifyResolved(vector.elementAt(i), specEvent);
        }
    }

    void notifyError(EventRequestSpec eventRequestSpec, Exception exception) {
        Vector<SpecListener> vector = this.specListeners();
        SpecErrorEvent specErrorEvent = new SpecErrorEvent(eventRequestSpec, exception);
        for (int i = 0; i < vector.size(); ++i) {
            eventRequestSpec.notifyError(vector.elementAt(i), specErrorEvent);
        }
    }
}

