/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.example.debug.gui;

import com.sun.tools.example.debug.bdi.ExecutionManager;
import com.sun.tools.example.debug.gui.ClassManager;
import com.sun.tools.example.debug.gui.CommandInterpreter;
import com.sun.tools.example.debug.gui.Environment;
import com.sun.tools.example.debug.gui.JDBFileFilter;
import com.sun.tools.example.debug.gui.SourceManager;
import java.awt.Container;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import java.util.Vector;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;

class JDBMenuBar
extends JMenuBar {
    Environment env;
    ExecutionManager runtime;
    ClassManager classManager;
    SourceManager sourceManager;
    CommandInterpreter interpreter;

    JDBMenuBar(Environment environment) {
        this.env = environment;
        this.runtime = environment.getExecutionManager();
        this.classManager = environment.getClassManager();
        this.sourceManager = environment.getSourceManager();
        this.interpreter = new CommandInterpreter(environment, true);
        JMenu jMenu = new JMenu("File");
        JMenuItem jMenuItem = new JMenuItem("Open...", 79);
        jMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JDBMenuBar.this.openCommand();
            }
        });
        jMenu.add(jMenuItem);
        this.addTool(jMenu, "Exit debugger", "Exit", "exit");
        JMenu jMenu2 = new JMenu("Commands");
        this.addTool(jMenu2, "Step into next line", "Step", "step");
        this.addTool(jMenu2, "Step over next line", "Next", "next");
        jMenu2.addSeparator();
        this.addTool(jMenu2, "Step into next instruction", "Step Instruction", "stepi");
        this.addTool(jMenu2, "Step over next instruction", "Next Instruction", "nexti");
        jMenu2.addSeparator();
        this.addTool(jMenu2, "Step out of current method call", "Step Up", "step up");
        jMenu2.addSeparator();
        this.addTool(jMenu2, "Suspend execution", "Interrupt", "interrupt");
        this.addTool(jMenu2, "Continue execution", "Continue", "cont");
        jMenu2.addSeparator();
        this.addTool(jMenu2, "Display current stack", "Where", "where");
        jMenu2.addSeparator();
        this.addTool(jMenu2, "Move up one stack frame", "Up", "up");
        this.addTool(jMenu2, "Move down one stack frame", "Down", "down");
        jMenu2.addSeparator();
        JMenuItem jMenuItem2 = new JMenuItem("Monitor Expression...", 77);
        jMenuItem2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JDBMenuBar.this.monitorCommand();
            }
        });
        jMenu2.add(jMenuItem2);
        JMenuItem jMenuItem3 = new JMenuItem("Unmonitor Expression...");
        jMenuItem3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JDBMenuBar.this.unmonitorCommand();
            }
        });
        jMenu2.add(jMenuItem3);
        JMenu jMenu3 = new JMenu("Breakpoint");
        JMenuItem jMenuItem4 = new JMenuItem("Stop in...", 83);
        jMenuItem4.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JDBMenuBar.this.buildBreakpoint();
            }
        });
        jMenu3.add(jMenuItem4);
        JMenu jMenu4 = new JMenu("Help");
        this.addTool(jMenu4, "Display command list", "Help", "help");
        this.add(jMenu);
        this.add(jMenu2);
        this.add(jMenu4);
    }

    private void buildBreakpoint() {
        Frame frame = JOptionPane.getRootFrame();
        JDialog jDialog = new JDialog(frame, "Specify Breakpoint");
        Container container = jDialog.getContentPane();
        Vector<String> vector = new Vector<String>();
        vector.add("Foo");
        vector.add("Bar");
        JList jList = new JList(vector);
        JScrollPane jScrollPane = new JScrollPane(jList);
        container.add(jScrollPane);
        jDialog.show();
    }

    private void monitorCommand() {
        String string = (String)JOptionPane.showInputDialog(null, "Expression to monitor:", "Add Monitor", 3, null, null, null);
        if (string != null) {
            this.interpreter.executeCommand("monitor " + string);
        }
    }

    private void unmonitorCommand() {
        List<String> list = this.env.getMonitorListModel().monitors();
        String string = (String)JOptionPane.showInputDialog(null, "Expression to unmonitor:", "Remove Monitor", 3, null, list.toArray(), list.get(list.size() - 1));
        if (string != null) {
            this.interpreter.executeCommand("unmonitor " + string);
        }
    }

    private void openCommand() {
        JFileChooser jFileChooser = new JFileChooser();
        JDBFileFilter jDBFileFilter = new JDBFileFilter("java", "Java source code");
        jFileChooser.setFileFilter(jDBFileFilter);
        int n = jFileChooser.showOpenDialog(this);
        if (n == 0) {
            System.out.println("Chose file: " + jFileChooser.getSelectedFile().getName());
        }
    }

    private void addTool(JMenu jMenu, String string, String string2, String string3) {
        JMenuItem jMenuItem = new JMenuItem(string2);
        jMenuItem.setToolTipText(string);
        final String string4 = string3;
        jMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JDBMenuBar.this.interpreter.executeCommand(string4);
            }
        });
        jMenu.add(jMenuItem);
    }
}

