/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.example.debug.gui;

import com.sun.jdi.ClassNotLoadedException;
import com.sun.jdi.IncompatibleThreadStateException;
import com.sun.jdi.InvalidTypeException;
import com.sun.jdi.InvocationException;
import com.sun.jdi.StackFrame;
import com.sun.jdi.Value;
import com.sun.tools.example.debug.bdi.ExecutionManager;
import com.sun.tools.example.debug.bdi.VMNotInterruptedException;
import com.sun.tools.example.debug.expr.ExpressionParser;
import com.sun.tools.example.debug.expr.ParseException;
import com.sun.tools.example.debug.gui.ContextManager;
import com.sun.tools.example.debug.gui.Environment;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class MonitorTool
extends JPanel {
    private ExecutionManager runtime;
    private ContextManager context;
    private JList list;

    public MonitorTool(Environment environment) {
        super(new BorderLayout());
        this.runtime = environment.getExecutionManager();
        this.context = environment.getContextManager();
        this.list = new JList(environment.getMonitorListModel());
        this.list.setCellRenderer(new MonitorRenderer());
        JScrollPane jScrollPane = new JScrollPane(this.list);
        this.add(jScrollPane);
        MonitorToolListener monitorToolListener = new MonitorToolListener();
        this.list.addListSelectionListener(monitorToolListener);
    }

    private Value evaluate(String string) throws ParseException, InvocationException, InvalidTypeException, ClassNotLoadedException, IncompatibleThreadStateException {
        ExpressionParser.GetFrame getFrame = new ExpressionParser.GetFrame(){

            @Override
            public StackFrame get() throws IncompatibleThreadStateException {
                try {
                    return MonitorTool.this.context.getCurrentFrame();
                }
                catch (VMNotInterruptedException vMNotInterruptedException) {
                    throw new IncompatibleThreadStateException();
                }
            }
        };
        return ExpressionParser.evaluate(string, this.runtime.vm(), getFrame);
    }

    private class MonitorRenderer
    extends DefaultListCellRenderer {
        private MonitorRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
            if (object == null) {
                this.setText("<unavailable>");
            } else {
                String string = (String)object;
                try {
                    Value value = MonitorTool.this.evaluate(string);
                    this.setText(string + " = " + value);
                }
                catch (ParseException parseException) {
                    this.setText(string + " ? " + parseException.getMessage());
                }
                catch (IncompatibleThreadStateException incompatibleThreadStateException) {
                    this.setText(string + " ...");
                }
                catch (Exception exception) {
                    this.setText(string + " ? " + exception);
                }
            }
            return this;
        }
    }

    private class MonitorToolListener
    implements ListSelectionListener {
        private MonitorToolListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            int n = MonitorTool.this.list.getSelectedIndex();
            if (n != -1) {
                // empty if block
            }
        }
    }
}

