/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jmx.event;

import com.sun.jmx.remote.util.ClassLogger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.management.remote.NotificationResult;
import javax.management.remote.TargetedNotification;

public class EventBuffer {
    private final int capacity;
    private final List<TargetedNotification> list;
    private boolean closed;
    private long passed = 0L;
    private final int[] lock = new int[0];
    private static final ClassLogger logger = new ClassLogger("javax.management.event", "EventBuffer");

    public EventBuffer() {
        this(Integer.MAX_VALUE, null);
    }

    public EventBuffer(int n) {
        this(n, new ArrayList<TargetedNotification>());
    }

    public EventBuffer(int n, List<TargetedNotification> list) {
        if (logger.traceOn()) {
            logger.trace("EventBuffer", "New buffer with the capacity: " + n);
        }
        if (n < 1) {
            throw new IllegalArgumentException("The capacity must be bigger than 0");
        }
        if (list == null) {
            throw new NullPointerException("Null list.");
        }
        this.capacity = n;
        this.list = list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(TargetedNotification targetedNotification) {
        if (logger.traceOn()) {
            logger.trace("add", "Add one notif.");
        }
        int[] nArray = this.lock;
        synchronized (this.lock) {
            if (this.list.size() == this.capacity) {
                ++this.passed;
                this.list.remove(0);
                if (logger.traceOn()) {
                    logger.trace("add", "Over, remove the oldest one.");
                }
            }
            this.list.add(targetedNotification);
            this.lock.notify();
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(TargetedNotification[] targetedNotificationArray) {
        if (targetedNotificationArray == null || targetedNotificationArray.length == 0) {
            return;
        }
        if (logger.traceOn()) {
            logger.trace("add", "Add notifs: " + targetedNotificationArray.length);
        }
        int[] nArray = this.lock;
        synchronized (this.lock) {
            int n = this.list.size() - this.capacity + targetedNotificationArray.length;
            if (n > 0) {
                this.passed += (long)n;
                if (logger.traceOn()) {
                    logger.trace("add", "Over, remove the oldest: " + n);
                }
                if (targetedNotificationArray.length <= this.capacity) {
                    this.list.subList(0, n).clear();
                } else {
                    this.list.clear();
                    TargetedNotification[] targetedNotificationArray2 = new TargetedNotification[this.capacity];
                    System.arraycopy(targetedNotificationArray, targetedNotificationArray.length - this.capacity, targetedNotificationArray2, 0, this.capacity);
                    targetedNotificationArray = targetedNotificationArray2;
                }
            }
            Collections.addAll(this.list, targetedNotificationArray);
            this.lock.notify();
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NotificationResult fetchNotifications(long l, long l2, int n) {
        long l3;
        if (logger.traceOn()) {
            logger.trace("fetchNotifications", "Being called: " + l + " " + l2 + " " + n);
        }
        if (l < 0L || l2 < 0L || n < 0) {
            throw new IllegalArgumentException("Negative value.");
        }
        TargetedNotification[] targetedNotificationArray = new TargetedNotification[]{};
        long l4 = l3 = l < this.passed ? this.passed : l;
        long l5 = System.currentTimeMillis();
        long l6 = l2;
        int[] nArray = this.lock;
        synchronized (this.lock) {
            int n2 = (int)(l - this.passed);
            while (!this.closed && n2 > 0) {
                l6 = l2 - (System.currentTimeMillis() - l5);
                if (this.list.size() == 0) {
                    if (l6 <= 0L) {
                        // ** MonitorExit[var15_9] (shouldn't be in output)
                        return new NotificationResult(l, l, new TargetedNotification[0]);
                    }
                    this.waiting(l6);
                    continue;
                }
                if (n2 <= this.list.size()) {
                    this.list.subList(0, n2).clear();
                    this.passed += (long)n2;
                    break;
                }
                this.passed += (long)this.list.size();
                n2 -= this.list.size();
                this.list.clear();
            }
            l3 = this.passed;
            if (this.list.size() == 0) {
                l6 = l2 - (System.currentTimeMillis() - l5);
                this.waiting(l6);
            }
            if (this.list.size() == 0) {
                targetedNotificationArray = new TargetedNotification[]{};
            } else if (this.list.size() <= n) {
                targetedNotificationArray = this.list.toArray(new TargetedNotification[0]);
            } else {
                targetedNotificationArray = new TargetedNotification[n];
                for (int i = 0; i < n; ++i) {
                    targetedNotificationArray[i] = this.list.get(i);
                }
            }
            l4 = l3 + (long)targetedNotificationArray.length;
            // ** MonitorExit[var15_9] (shouldn't be in output)
            if (logger.traceOn()) {
                logger.trace("fetchNotifications", "Return: " + l3 + " " + l4 + " " + targetedNotificationArray.length);
            }
            return new NotificationResult(l3, l4, targetedNotificationArray);
        }
    }

    public int size() {
        return this.list.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addLost(long l) {
        int[] nArray = this.lock;
        synchronized (this.lock) {
            this.passed += l;
            // ** MonitorExit[var3_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        if (logger.traceOn()) {
            logger.trace("clear", "done");
        }
        int[] nArray = this.lock;
        synchronized (this.lock) {
            this.list.clear();
            this.closed = true;
            this.lock.notifyAll();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waiting(long l) {
        long l2 = System.currentTimeMillis();
        long l3 = l;
        int[] nArray = this.lock;
        synchronized (this.lock) {
            while (!this.closed && this.list.size() == 0 && l3 > 0L) {
                try {
                    this.lock.wait(l3);
                    l3 = l - (System.currentTimeMillis() - l2);
                }
                catch (InterruptedException interruptedException) {
                    logger.trace("waiting", interruptedException);
                    break;
                }
            }
            // ** MonitorExit[var7_4] (shouldn't be in output)
            return;
        }
    }
}

