/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jmx.mbeanserver;

import com.sun.jmx.mbeanserver.Introspector;
import com.sun.jmx.mbeanserver.MBeanAnalyzer;
import com.sun.jmx.mbeanserver.MBeanIntrospector;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.WeakHashMap;
import javax.management.Descriptor;
import javax.management.ImmutableDescriptor;
import javax.management.IntrospectionException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanException;
import javax.management.MBeanOperationInfo;
import javax.management.ManagedOperation;
import javax.management.NotCompliantMBeanException;
import javax.management.NotificationBroadcaster;
import javax.management.NotificationBroadcasterSupport;

class StandardMBeanIntrospector
extends MBeanIntrospector<Method> {
    private static final StandardMBeanIntrospector instance = new StandardMBeanIntrospector();
    private static final WeakHashMap<Class<?>, Boolean> definitelyImmutable = new WeakHashMap();
    private static final MBeanIntrospector.PerInterfaceMap<Method> perInterfaceMap = new MBeanIntrospector.PerInterfaceMap();
    private static final MBeanIntrospector.MBeanInfoMap mbeanInfoMap = new MBeanIntrospector.MBeanInfoMap();

    StandardMBeanIntrospector() {
    }

    static StandardMBeanIntrospector getInstance() {
        return instance;
    }

    @Override
    MBeanIntrospector.PerInterfaceMap<Method> getPerInterfaceMap() {
        return perInterfaceMap;
    }

    @Override
    MBeanIntrospector.MBeanInfoMap getMBeanInfoMap() {
        return mbeanInfoMap;
    }

    @Override
    MBeanAnalyzer<Method> getAnalyzer(Class<?> clazz) throws NotCompliantMBeanException {
        return MBeanAnalyzer.analyzer(clazz, this);
    }

    @Override
    boolean isMXBean() {
        return false;
    }

    @Override
    Method mFrom(Method method) {
        return method;
    }

    @Override
    String getName(Method method) {
        return method.getName();
    }

    @Override
    Type getGenericReturnType(Method method) {
        return method.getGenericReturnType();
    }

    @Override
    Type[] getGenericParameterTypes(Method method) {
        return method.getGenericParameterTypes();
    }

    @Override
    String[] getSignature(Method method) {
        Class<?>[] classArray = method.getParameterTypes();
        String[] stringArray = new String[classArray.length];
        for (int i = 0; i < classArray.length; ++i) {
            stringArray[i] = classArray[i].getName();
        }
        return stringArray;
    }

    @Override
    void checkMethod(Method method) {
    }

    @Override
    Object invokeM2(Method method, Object object, Object[] objectArray, Object object2) throws InvocationTargetException, IllegalAccessException, MBeanException {
        return method.invoke(object, objectArray);
    }

    @Override
    boolean validParameter(Method method, Object object, int n, Object object2) {
        return StandardMBeanIntrospector.isValidParameter(method, object, n);
    }

    @Override
    MBeanAttributeInfo getMBeanAttributeInfo(String string, Method method, Method method2) throws IntrospectionException {
        String string2 = this.getAttributeDescription(string, "Attribute exposed for management", method, method2);
        return new MBeanAttributeInfo(string, string2, method, method2);
    }

    @Override
    MBeanOperationInfo getMBeanOperationInfo(String string, Method method) {
        String string2 = Introspector.descriptionForElement(method);
        if (string2 == null) {
            string2 = "Operation exposed for management";
        }
        int n = 3;
        ManagedOperation managedOperation = method.getAnnotation(ManagedOperation.class);
        if (managedOperation != null) {
            n = managedOperation.impact().getCode();
        }
        MBeanOperationInfo mBeanOperationInfo = new MBeanOperationInfo(string2, method);
        return new MBeanOperationInfo(mBeanOperationInfo.getName(), mBeanOperationInfo.getDescription(), mBeanOperationInfo.getSignature(), mBeanOperationInfo.getReturnType(), n, mBeanOperationInfo.getDescriptor());
    }

    @Override
    Descriptor getBasicMBeanDescriptor() {
        return ImmutableDescriptor.EMPTY_DESCRIPTOR;
    }

    @Override
    Descriptor getMBeanDescriptor(Class<?> clazz) {
        boolean bl = StandardMBeanIntrospector.isDefinitelyImmutableInfo(clazz);
        return new ImmutableDescriptor("mxbean=false", "immutableInfo=" + bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static boolean isDefinitelyImmutableInfo(Class<?> clazz) {
        if (!NotificationBroadcaster.class.isAssignableFrom(clazz)) {
            return true;
        }
        WeakHashMap<Class<?>, Boolean> weakHashMap = definitelyImmutable;
        synchronized (weakHashMap) {
            Boolean bl = definitelyImmutable.get(clazz);
            if (bl == null) {
                Class<NotificationBroadcasterSupport> clazz2 = NotificationBroadcasterSupport.class;
                if (clazz2.isAssignableFrom(clazz)) {
                    try {
                        Method method = clazz.getMethod("getNotificationInfo", new Class[0]);
                        bl = method.getDeclaringClass() == clazz2;
                    }
                    catch (Exception exception) {
                        return false;
                    }
                } else {
                    bl = false;
                }
                definitelyImmutable.put(clazz, bl);
            }
            return bl;
        }
    }
}

