/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.sound;

import com.sun.media.sound.AbstractMixer;
import com.sun.media.sound.EventDispatcher;
import java.util.Vector;
import javax.sound.sampled.Control;
import javax.sound.sampled.Line;
import javax.sound.sampled.LineEvent;
import javax.sound.sampled.LineListener;
import javax.sound.sampled.LineUnavailableException;

abstract class AbstractLine
implements Line {
    protected Line.Info info;
    protected Control[] controls;
    protected AbstractMixer mixer;
    private boolean open = false;
    private Vector listeners = new Vector();
    private static final EventDispatcher eventDispatcher = new EventDispatcher();

    protected AbstractLine(Line.Info info, AbstractMixer abstractMixer, Control[] controlArray) {
        if (controlArray == null) {
            controlArray = new Control[]{};
        }
        this.info = info;
        this.mixer = abstractMixer;
        this.controls = controlArray;
    }

    @Override
    public Line.Info getLineInfo() {
        return this.info;
    }

    @Override
    public boolean isOpen() {
        return this.open;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addLineListener(LineListener lineListener) {
        Vector vector = this.listeners;
        synchronized (vector) {
            if (!this.listeners.contains(lineListener)) {
                this.listeners.addElement(lineListener);
            }
        }
    }

    @Override
    public void removeLineListener(LineListener lineListener) {
        this.listeners.removeElement(lineListener);
    }

    @Override
    public Control[] getControls() {
        Control[] controlArray = new Control[this.controls.length];
        for (int i = 0; i < this.controls.length; ++i) {
            controlArray[i] = this.controls[i];
        }
        return controlArray;
    }

    @Override
    public boolean isControlSupported(Control.Type type) {
        if (type == null) {
            return false;
        }
        for (int i = 0; i < this.controls.length; ++i) {
            if (type != this.controls[i].getType()) continue;
            return true;
        }
        return false;
    }

    @Override
    public Control getControl(Control.Type type) {
        if (type != null) {
            for (int i = 0; i < this.controls.length; ++i) {
                if (type != this.controls[i].getType()) continue;
                return this.controls[i];
            }
        }
        throw new IllegalArgumentException("Unsupported control type: " + type);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setOpen(boolean bl) {
        boolean bl2 = false;
        long l = this.getLongFramePosition();
        AbstractLine abstractLine = this;
        synchronized (abstractLine) {
            if (this.open != bl) {
                this.open = bl;
                bl2 = true;
            }
        }
        if (bl2) {
            if (bl) {
                this.sendEvents(new LineEvent(this, LineEvent.Type.OPEN, l));
            } else {
                this.sendEvents(new LineEvent(this, LineEvent.Type.CLOSE, l));
            }
        }
    }

    protected void sendEvents(LineEvent lineEvent) {
        eventDispatcher.sendAudioEvents(lineEvent, this.listeners);
    }

    public final int getFramePosition() {
        return (int)this.getLongFramePosition();
    }

    public long getLongFramePosition() {
        return -1L;
    }

    protected AbstractMixer getMixer() {
        return this.mixer;
    }

    protected EventDispatcher getEventDispatcher() {
        return eventDispatcher;
    }

    @Override
    public abstract void open() throws LineUnavailableException;

    @Override
    public abstract void close();

    static {
        eventDispatcher.start();
    }
}

