/*
 * Decompiled with CFR 0.152.
 */
package java.dyn;

import java.dyn.CallSite;
import java.dyn.LinkagePermission;
import java.dyn.MethodHandle;
import java.dyn.MethodHandles;
import java.dyn.MethodType;
import java.dyn.WrongMethodTypeException;
import java.util.WeakHashMap;
import sun.dyn.util.VerifyAccess;
import sun.reflect.Reflection;

public class Linkage {
    public static final MethodType BOOTSTRAP_METHOD_TYPE = MethodType.make(CallSite.class, Class.class, String.class, MethodType.class);
    private static final MethodType OLD_BOOTSTRAP_METHOD_TYPE = MethodType.make(Object.class, CallSite.class, Object[].class);
    private static final WeakHashMap<Class, MethodHandle> bootstrapMethods = new WeakHashMap();
    private static final MethodHandle DO_NOT_BOOTSTRAP = MethodHandles.Lookup.IMPL_LOOKUP.findStatic(Linkage.class, "doNotBootstrap", OLD_BOOTSTRAP_METHOD_TYPE);

    private Linkage() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerBootstrapMethod(Class clazz, MethodHandle methodHandle) {
        Class clazz2 = Reflection.getCallerClass(2);
        VerifyAccess.checkBootstrapPrivilege(clazz2, clazz, "registerBootstrapMethod");
        Linkage.checkBSM(methodHandle);
        WeakHashMap<Class, MethodHandle> weakHashMap = bootstrapMethods;
        synchronized (weakHashMap) {
            if (bootstrapMethods.containsKey(clazz)) {
                throw new IllegalStateException("bootstrap method already declared in " + clazz);
            }
            bootstrapMethods.put(clazz, methodHandle);
        }
    }

    static void checkBSM(MethodHandle methodHandle) {
        if (methodHandle == null) {
            throw new IllegalArgumentException("null bootstrap method");
        }
        if (methodHandle.type() == OLD_BOOTSTRAP_METHOD_TYPE) {
            throw new WrongMethodTypeException("bootstrap method must be a CallSite factory");
        }
        if (methodHandle.type() != BOOTSTRAP_METHOD_TYPE) {
            throw new WrongMethodTypeException(methodHandle.toString());
        }
    }

    public static void registerBootstrapMethod(Class<?> clazz, String string) {
        Class clazz2 = Reflection.getCallerClass(2);
        MethodHandle methodHandle = MethodHandles.findStaticFrom(clazz2, clazz, string, BOOTSTRAP_METHOD_TYPE);
        Linkage.checkBSM(methodHandle);
        Linkage.registerBootstrapMethod(clazz2, methodHandle);
    }

    public static void registerBootstrapMethod(String string) {
        Class clazz = Reflection.getCallerClass(2);
        MethodHandle methodHandle = MethodHandles.findStaticFrom(clazz, clazz, string, BOOTSTRAP_METHOD_TYPE);
        Linkage.checkBSM(methodHandle);
        Linkage.registerBootstrapMethod(clazz, methodHandle);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MethodHandle getBootstrapMethod(Class clazz) {
        Class clazz2 = Reflection.getCallerClass(2);
        VerifyAccess.checkBootstrapPrivilege(clazz2, clazz, "registerBootstrapMethod");
        WeakHashMap<Class, MethodHandle> weakHashMap = bootstrapMethods;
        synchronized (weakHashMap) {
            return bootstrapMethods.get(clazz);
        }
    }

    public static Object invalidateAll() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new LinkagePermission("invalidateAll"));
        }
        throw new UnsupportedOperationException("NYI");
    }

    public static Object invalidateCallerClass(Class<?> clazz) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new LinkagePermission("invalidateAll", clazz));
        }
        throw new UnsupportedOperationException("NYI");
    }

    private static Object doNotBootstrap(CallSite callSite, Object ... objectArray) {
        throw new UnsupportedOperationException("call site must not have null target: " + callSite);
    }

    static MethodHandle findBootstrapMethod(Class clazz, Class clazz2) {
        return DO_NOT_BOOTSTRAP;
    }
}

