/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;

public abstract class AbstractCollection<E>
implements Collection<E> {
    protected AbstractCollection() {
    }

    @Override
    public abstract Iterator<E> iterator();

    @Override
    public abstract int size();

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public boolean contains(Object object) {
        Iterator<E> iterator = this.iterator();
        if (object == null) {
            while (iterator.hasNext()) {
                if (iterator.next() != null) continue;
                return true;
            }
        } else {
            while (iterator.hasNext()) {
                if (!object.equals(iterator.next())) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public Object[] toArray() {
        Object[] objectArray = new Object[this.size()];
        Iterator<E> iterator = this.iterator();
        for (int i = 0; i < objectArray.length; ++i) {
            if (!iterator.hasNext()) {
                return Arrays.copyOf(objectArray, i);
            }
            objectArray[i] = iterator.next();
        }
        return iterator.hasNext() ? AbstractCollection.finishToArray(objectArray, iterator) : objectArray;
    }

    @Override
    public <T> T[] toArray(T[] TArray) {
        int n = this.size();
        T[] TArray2 = TArray.length >= n ? TArray : (Object[])Array.newInstance(TArray.getClass().getComponentType(), n);
        Iterator<E> iterator = this.iterator();
        for (int i = 0; i < TArray2.length; ++i) {
            if (!iterator.hasNext()) {
                if (TArray != TArray2) {
                    return Arrays.copyOf(TArray2, i);
                }
                TArray2[i] = null;
                return TArray2;
            }
            TArray2[i] = iterator.next();
        }
        return iterator.hasNext() ? AbstractCollection.finishToArray(TArray2, iterator) : TArray2;
    }

    private static <T> T[] finishToArray(T[] TArray, Iterator<?> iterator) {
        int n = TArray.length;
        while (iterator.hasNext()) {
            int n2 = TArray.length;
            if (n == n2) {
                int n3 = (n2 / 2 + 1) * 3;
                if (n3 <= n2) {
                    if (n2 == Integer.MAX_VALUE) {
                        throw new OutOfMemoryError("Required array size too large");
                    }
                    n3 = Integer.MAX_VALUE;
                }
                TArray = Arrays.copyOf(TArray, n3);
            }
            TArray[n++] = iterator.next();
        }
        return n == TArray.length ? TArray : Arrays.copyOf(TArray, n);
    }

    @Override
    public boolean add(E e) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean remove(Object object) {
        Iterator<E> iterator = this.iterator();
        if (object == null) {
            while (iterator.hasNext()) {
                if (iterator.next() != null) continue;
                iterator.remove();
                return true;
            }
        } else {
            while (iterator.hasNext()) {
                if (!object.equals(iterator.next())) continue;
                iterator.remove();
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean containsAll(Collection<?> collection) {
        Iterator<?> iterator = collection.iterator();
        while (iterator.hasNext()) {
            if (this.contains(iterator.next())) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean addAll(Collection<? extends E> collection) {
        boolean bl = false;
        Iterator<E> iterator = collection.iterator();
        while (iterator.hasNext()) {
            if (!this.add(iterator.next())) continue;
            bl = true;
        }
        return bl;
    }

    @Override
    public boolean removeAll(Collection<?> collection) {
        boolean bl = false;
        Iterator<E> iterator = this.iterator();
        while (iterator.hasNext()) {
            if (!collection.contains(iterator.next())) continue;
            iterator.remove();
            bl = true;
        }
        return bl;
    }

    @Override
    public boolean retainAll(Collection<?> collection) {
        boolean bl = false;
        Iterator<E> iterator = this.iterator();
        while (iterator.hasNext()) {
            if (collection.contains(iterator.next())) continue;
            iterator.remove();
            bl = true;
        }
        return bl;
    }

    @Override
    public void clear() {
        Iterator<E> iterator = this.iterator();
        while (iterator.hasNext()) {
            iterator.next();
            iterator.remove();
        }
    }

    public String toString() {
        Iterator<E> iterator = this.iterator();
        if (!iterator.hasNext()) {
            return "[]";
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append('[');
        while (true) {
            E e;
            stringBuilder.append((Object)((e = iterator.next()) == this ? "(this Collection)" : e));
            if (!iterator.hasNext()) {
                return stringBuilder.append(']').toString();
            }
            stringBuilder.append(", ");
        }
    }
}

