/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.AbstractList;
import java.util.AbstractMap;
import java.util.AbstractQueue;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Deque;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Queue;
import java.util.Random;
import java.util.RandomAccess;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;

public class Collections {
    private static final int BINARYSEARCH_THRESHOLD = 5000;
    private static final int REVERSE_THRESHOLD = 18;
    private static final int SHUFFLE_THRESHOLD = 5;
    private static final int FILL_THRESHOLD = 25;
    private static final int ROTATE_THRESHOLD = 100;
    private static final int COPY_THRESHOLD = 10;
    private static final int REPLACEALL_THRESHOLD = 11;
    private static final int INDEXOFSUBLIST_THRESHOLD = 35;
    private static Random r;
    public static final Set EMPTY_SET;
    public static final List EMPTY_LIST;
    public static final Map EMPTY_MAP;

    private Collections() {
    }

    public static <T extends Comparable<? super T>> void sort(List<T> list) {
        Object[] objectArray = list.toArray();
        Arrays.sort(objectArray);
        ListIterator<T> listIterator = list.listIterator();
        for (int i = 0; i < objectArray.length; ++i) {
            listIterator.next();
            listIterator.set((Comparable)objectArray[i]);
        }
    }

    public static <T> void sort(List<T> list, Comparator<? super T> comparator) {
        Object[] objectArray = list.toArray();
        Arrays.sort(objectArray, comparator);
        ListIterator<T> listIterator = list.listIterator();
        for (int i = 0; i < objectArray.length; ++i) {
            listIterator.next();
            listIterator.set(objectArray[i]);
        }
    }

    public static <T> int binarySearch(List<? extends Comparable<? super T>> list, T t) {
        if (list instanceof RandomAccess || list.size() < 5000) {
            return Collections.indexedBinarySearch(list, t);
        }
        return Collections.iteratorBinarySearch(list, t);
    }

    private static <T> int indexedBinarySearch(List<? extends Comparable<? super T>> list, T t) {
        int n = 0;
        int n2 = list.size() - 1;
        while (n <= n2) {
            int n3 = n + n2 >>> 1;
            Comparable<T> comparable = list.get(n3);
            int n4 = comparable.compareTo(t);
            if (n4 < 0) {
                n = n3 + 1;
                continue;
            }
            if (n4 > 0) {
                n2 = n3 - 1;
                continue;
            }
            return n3;
        }
        return -(n + 1);
    }

    private static <T> int iteratorBinarySearch(List<? extends Comparable<? super T>> list, T t) {
        int n = 0;
        int n2 = list.size() - 1;
        ListIterator<? extends Comparable<? super T>> listIterator = list.listIterator();
        while (n <= n2) {
            int n3 = n + n2 >>> 1;
            Comparable<T> comparable = Collections.get(listIterator, n3);
            int n4 = comparable.compareTo(t);
            if (n4 < 0) {
                n = n3 + 1;
                continue;
            }
            if (n4 > 0) {
                n2 = n3 - 1;
                continue;
            }
            return n3;
        }
        return -(n + 1);
    }

    private static <T> T get(ListIterator<? extends T> listIterator, int n) {
        T t = null;
        int n2 = listIterator.nextIndex();
        if (n2 <= n) {
            do {
                t = listIterator.next();
            } while (n2++ < n);
        } else {
            do {
                t = listIterator.previous();
            } while (--n2 > n);
        }
        return t;
    }

    public static <T> int binarySearch(List<? extends T> list, T t, Comparator<? super T> comparator) {
        if (comparator == null) {
            return Collections.binarySearch(list, t);
        }
        if (list instanceof RandomAccess || list.size() < 5000) {
            return Collections.indexedBinarySearch(list, t, comparator);
        }
        return Collections.iteratorBinarySearch(list, t, comparator);
    }

    private static <T> int indexedBinarySearch(List<? extends T> list, T t, Comparator<? super T> comparator) {
        int n = 0;
        int n2 = list.size() - 1;
        while (n <= n2) {
            int n3 = n + n2 >>> 1;
            T t2 = list.get(n3);
            int n4 = comparator.compare(t2, t);
            if (n4 < 0) {
                n = n3 + 1;
                continue;
            }
            if (n4 > 0) {
                n2 = n3 - 1;
                continue;
            }
            return n3;
        }
        return -(n + 1);
    }

    private static <T> int iteratorBinarySearch(List<? extends T> list, T t, Comparator<? super T> comparator) {
        int n = 0;
        int n2 = list.size() - 1;
        ListIterator<? extends T> listIterator = list.listIterator();
        while (n <= n2) {
            int n3 = n + n2 >>> 1;
            T t2 = Collections.get(listIterator, n3);
            int n4 = comparator.compare(t2, t);
            if (n4 < 0) {
                n = n3 + 1;
                continue;
            }
            if (n4 > 0) {
                n2 = n3 - 1;
                continue;
            }
            return n3;
        }
        return -(n + 1);
    }

    public static void reverse(List<?> list) {
        int n = list.size();
        if (n < 18 || list instanceof RandomAccess) {
            int n2 = 0;
            int n3 = n >> 1;
            int n4 = n - 1;
            while (n2 < n3) {
                Collections.swap(list, n2, n4);
                ++n2;
                --n4;
            }
        } else {
            ListIterator<?> listIterator = list.listIterator();
            ListIterator<?> listIterator2 = list.listIterator(n);
            int n5 = list.size() >> 1;
            for (int i = 0; i < n5; ++i) {
                Object obj = listIterator.next();
                listIterator.set(listIterator2.previous());
                listIterator2.set(obj);
            }
        }
    }

    public static void shuffle(List<?> list) {
        if (r == null) {
            r = new Random();
        }
        Collections.shuffle(list, r);
    }

    public static void shuffle(List<?> list, Random random) {
        int n = list.size();
        if (n < 5 || list instanceof RandomAccess) {
            for (int i = n; i > 1; --i) {
                Collections.swap(list, i - 1, random.nextInt(i));
            }
        } else {
            Object[] objectArray = list.toArray();
            for (int i = n; i > 1; --i) {
                Collections.swap(objectArray, i - 1, random.nextInt(i));
            }
            ListIterator<?> listIterator = list.listIterator();
            for (int i = 0; i < objectArray.length; ++i) {
                listIterator.next();
                listIterator.set(objectArray[i]);
            }
        }
    }

    public static void swap(List<?> list, int n, int n2) {
        List<?> list2 = list;
        list2.set(n, list2.set(n2, list2.get(n)));
    }

    private static void swap(Object[] objectArray, int n, int n2) {
        Object object = objectArray[n];
        objectArray[n] = objectArray[n2];
        objectArray[n2] = object;
    }

    public static <T> void fill(List<? super T> list, T t) {
        int n = list.size();
        if (n < 25 || list instanceof RandomAccess) {
            for (int i = 0; i < n; ++i) {
                list.set(i, t);
            }
        } else {
            ListIterator<T> listIterator = list.listIterator();
            for (int i = 0; i < n; ++i) {
                listIterator.next();
                listIterator.set(t);
            }
        }
    }

    public static <T> void copy(List<? super T> list, List<? extends T> list2) {
        int n = list2.size();
        if (n > list.size()) {
            throw new IndexOutOfBoundsException("Source does not fit in dest");
        }
        if (n < 10 || list2 instanceof RandomAccess && list instanceof RandomAccess) {
            for (int i = 0; i < n; ++i) {
                list.set(i, list2.get(i));
            }
        } else {
            ListIterator<T> listIterator = list.listIterator();
            ListIterator<T> listIterator2 = list2.listIterator();
            for (int i = 0; i < n; ++i) {
                listIterator.next();
                listIterator.set(listIterator2.next());
            }
        }
    }

    public static <T> T min(Collection<? extends T> collection) {
        Iterator<T> iterator = collection.iterator();
        T t = iterator.next();
        while (iterator.hasNext()) {
            T t2 = iterator.next();
            if (((Comparable)t2).compareTo(t) >= 0) continue;
            t = t2;
        }
        return t;
    }

    public static <T> T min(Collection<? extends T> collection, Comparator<? super T> comparator) {
        if (comparator == null) {
            return Collections.min(collection);
        }
        Iterator<T> iterator = collection.iterator();
        T t = iterator.next();
        while (iterator.hasNext()) {
            T t2 = iterator.next();
            if (comparator.compare(t2, t) >= 0) continue;
            t = t2;
        }
        return t;
    }

    public static <T> T max(Collection<? extends T> collection) {
        Iterator<T> iterator = collection.iterator();
        T t = iterator.next();
        while (iterator.hasNext()) {
            T t2 = iterator.next();
            if (((Comparable)t2).compareTo(t) <= 0) continue;
            t = t2;
        }
        return t;
    }

    public static <T> T max(Collection<? extends T> collection, Comparator<? super T> comparator) {
        if (comparator == null) {
            return Collections.max(collection);
        }
        Iterator<T> iterator = collection.iterator();
        T t = iterator.next();
        while (iterator.hasNext()) {
            T t2 = iterator.next();
            if (comparator.compare(t2, t) <= 0) continue;
            t = t2;
        }
        return t;
    }

    public static void rotate(List<?> list, int n) {
        if (list instanceof RandomAccess || list.size() < 100) {
            Collections.rotate1(list, n);
        } else {
            Collections.rotate2(list, n);
        }
    }

    private static <T> void rotate1(List<T> list, int n) {
        int n2 = list.size();
        if (n2 == 0) {
            return;
        }
        if ((n %= n2) < 0) {
            n += n2;
        }
        if (n == 0) {
            return;
        }
        int n3 = 0;
        int n4 = 0;
        while (n4 != n2) {
            T t = list.get(n3);
            int n5 = n3;
            do {
                if ((n5 += n) >= n2) {
                    n5 -= n2;
                }
                t = list.set(n5, t);
                ++n4;
            } while (n5 != n3);
            ++n3;
        }
    }

    private static void rotate2(List<?> list, int n) {
        int n2 = list.size();
        if (n2 == 0) {
            return;
        }
        int n3 = -n % n2;
        if (n3 < 0) {
            n3 += n2;
        }
        if (n3 == 0) {
            return;
        }
        Collections.reverse(list.subList(0, n3));
        Collections.reverse(list.subList(n3, n2));
        Collections.reverse(list);
    }

    public static <T> boolean replaceAll(List<T> list, T t, T t2) {
        boolean bl = false;
        int n = list.size();
        if (n < 11 || list instanceof RandomAccess) {
            if (t == null) {
                for (int i = 0; i < n; ++i) {
                    if (list.get(i) != null) continue;
                    list.set(i, t2);
                    bl = true;
                }
            } else {
                for (int i = 0; i < n; ++i) {
                    if (!t.equals(list.get(i))) continue;
                    list.set(i, t2);
                    bl = true;
                }
            }
        } else {
            ListIterator<T> listIterator = list.listIterator();
            if (t == null) {
                for (int i = 0; i < n; ++i) {
                    if (listIterator.next() != null) continue;
                    listIterator.set(t2);
                    bl = true;
                }
            } else {
                for (int i = 0; i < n; ++i) {
                    if (!t.equals(listIterator.next())) continue;
                    listIterator.set(t2);
                    bl = true;
                }
            }
        }
        return bl;
    }

    public static int indexOfSubList(List<?> list, List<?> list2) {
        int n = list.size();
        int n2 = list2.size();
        int n3 = n - n2;
        if (n < 35 || list instanceof RandomAccess && list2 instanceof RandomAccess) {
            block0: for (int i = 0; i <= n3; ++i) {
                int n4 = 0;
                int n5 = i;
                while (n4 < n2) {
                    if (!Collections.eq(list2.get(n4), list.get(n5))) continue block0;
                    ++n4;
                    ++n5;
                }
                return i;
            }
        } else {
            ListIterator<?> listIterator = list.listIterator();
            block2: for (int i = 0; i <= n3; ++i) {
                ListIterator<?> listIterator2 = list2.listIterator();
                for (int j = 0; j < n2; ++j) {
                    if (Collections.eq(listIterator2.next(), listIterator.next())) continue;
                    for (int k = 0; k < j; ++k) {
                        listIterator.previous();
                    }
                    continue block2;
                }
                return i;
            }
        }
        return -1;
    }

    public static int lastIndexOfSubList(List<?> list, List<?> list2) {
        int n = list.size();
        int n2 = list2.size();
        int n3 = n - n2;
        if (n < 35 || list instanceof RandomAccess) {
            block0: for (int i = n3; i >= 0; --i) {
                int n4 = 0;
                int n5 = i;
                while (n4 < n2) {
                    if (!Collections.eq(list2.get(n4), list.get(n5))) continue block0;
                    ++n4;
                    ++n5;
                }
                return i;
            }
        } else {
            if (n3 < 0) {
                return -1;
            }
            ListIterator<?> listIterator = list.listIterator(n3);
            block2: for (int i = n3; i >= 0; --i) {
                ListIterator<?> listIterator2 = list2.listIterator();
                for (int j = 0; j < n2; ++j) {
                    if (Collections.eq(listIterator2.next(), listIterator.next())) continue;
                    if (i == 0) continue block2;
                    for (int k = 0; k <= j + 1; ++k) {
                        listIterator.previous();
                    }
                    continue block2;
                }
                return i;
            }
        }
        return -1;
    }

    public static <T> Collection<T> unmodifiableCollection(Collection<? extends T> collection) {
        return new UnmodifiableCollection<T>(collection);
    }

    public static <T> Set<T> unmodifiableSet(Set<? extends T> set) {
        return new UnmodifiableSet<T>(set);
    }

    public static <T> SortedSet<T> unmodifiableSortedSet(SortedSet<T> sortedSet) {
        return new UnmodifiableSortedSet<T>(sortedSet);
    }

    public static <T> List<T> unmodifiableList(List<? extends T> list) {
        return list instanceof RandomAccess ? new UnmodifiableRandomAccessList<T>(list) : new UnmodifiableList<T>(list);
    }

    public static <K, V> Map<K, V> unmodifiableMap(Map<? extends K, ? extends V> map) {
        return new UnmodifiableMap<K, V>(map);
    }

    public static <K, V> SortedMap<K, V> unmodifiableSortedMap(SortedMap<K, ? extends V> sortedMap) {
        return new UnmodifiableSortedMap<K, V>(sortedMap);
    }

    public static <T> Collection<T> synchronizedCollection(Collection<T> collection) {
        return new SynchronizedCollection<T>(collection);
    }

    static <T> Collection<T> synchronizedCollection(Collection<T> collection, Object object) {
        return new SynchronizedCollection<T>(collection, object);
    }

    public static <T> Set<T> synchronizedSet(Set<T> set) {
        return new SynchronizedSet<T>(set);
    }

    static <T> Set<T> synchronizedSet(Set<T> set, Object object) {
        return new SynchronizedSet<T>(set, object);
    }

    public static <T> SortedSet<T> synchronizedSortedSet(SortedSet<T> sortedSet) {
        return new SynchronizedSortedSet<T>(sortedSet);
    }

    public static <T> List<T> synchronizedList(List<T> list) {
        return list instanceof RandomAccess ? new SynchronizedRandomAccessList<T>(list) : new SynchronizedList<T>(list);
    }

    static <T> List<T> synchronizedList(List<T> list, Object object) {
        return list instanceof RandomAccess ? new SynchronizedRandomAccessList<T>(list, object) : new SynchronizedList<T>(list, object);
    }

    public static <K, V> Map<K, V> synchronizedMap(Map<K, V> map) {
        return new SynchronizedMap<K, V>(map);
    }

    public static <K, V> SortedMap<K, V> synchronizedSortedMap(SortedMap<K, V> sortedMap) {
        return new SynchronizedSortedMap<K, V>(sortedMap);
    }

    public static <E> Collection<E> checkedCollection(Collection<E> collection, Class<E> clazz) {
        return new CheckedCollection<E>(collection, clazz);
    }

    static <T> T[] zeroLengthArray(Class<T> clazz) {
        return (Object[])Array.newInstance(clazz, 0);
    }

    public static <E> Set<E> checkedSet(Set<E> set, Class<E> clazz) {
        return new CheckedSet<E>(set, clazz);
    }

    public static <E> SortedSet<E> checkedSortedSet(SortedSet<E> sortedSet, Class<E> clazz) {
        return new CheckedSortedSet<E>(sortedSet, clazz);
    }

    public static <E> List<E> checkedList(List<E> list, Class<E> clazz) {
        return list instanceof RandomAccess ? new CheckedRandomAccessList<E>(list, clazz) : new CheckedList<E>(list, clazz);
    }

    public static <K, V> Map<K, V> checkedMap(Map<K, V> map, Class<K> clazz, Class<V> clazz2) {
        return new CheckedMap<K, V>(map, clazz, clazz2);
    }

    public static <K, V> SortedMap<K, V> checkedSortedMap(SortedMap<K, V> sortedMap, Class<K> clazz, Class<V> clazz2) {
        return new CheckedSortedMap<K, V>(sortedMap, clazz, clazz2);
    }

    public static <T> Iterator<T> emptyIterator() {
        return EmptyIterator.EMPTY_ITERATOR;
    }

    public static <T> ListIterator<T> emptyListIterator() {
        return EmptyListIterator.EMPTY_ITERATOR;
    }

    public static <T> Enumeration<T> emptyEnumeration() {
        return EmptyEnumeration.EMPTY_ENUMERATION;
    }

    public static final <T> Set<T> emptySet() {
        return EMPTY_SET;
    }

    public static final <T> List<T> emptyList() {
        return EMPTY_LIST;
    }

    public static final <K, V> Map<K, V> emptyMap() {
        return EMPTY_MAP;
    }

    public static <T> Set<T> singleton(T t) {
        return new SingletonSet<T>(t);
    }

    static <E> Iterator<E> singletonIterator(final E e) {
        return new Iterator<E>(){
            private boolean hasNext = true;

            @Override
            public boolean hasNext() {
                return this.hasNext;
            }

            @Override
            public E next() {
                if (this.hasNext) {
                    this.hasNext = false;
                    return e;
                }
                throw new NoSuchElementException();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public static <T> List<T> singletonList(T t) {
        return new SingletonList<T>(t);
    }

    public static <K, V> Map<K, V> singletonMap(K k, V v) {
        return new SingletonMap<K, V>(k, v);
    }

    public static <T> List<T> nCopies(int n, T t) {
        if (n < 0) {
            throw new IllegalArgumentException("List length = " + n);
        }
        return new CopiesList<T>(n, t);
    }

    public static <T> Comparator<T> reverseOrder() {
        return ReverseComparator.REVERSE_ORDER;
    }

    public static <T> Comparator<T> reverseOrder(Comparator<T> comparator) {
        if (comparator == null) {
            return Collections.reverseOrder();
        }
        if (comparator instanceof ReverseComparator2) {
            return ((ReverseComparator2)comparator).cmp;
        }
        return new ReverseComparator2<T>(comparator);
    }

    public static <T> Enumeration<T> enumeration(final Collection<T> collection) {
        return new Enumeration<T>(){
            private final Iterator<T> i;
            {
                this.i = collection.iterator();
            }

            @Override
            public boolean hasMoreElements() {
                return this.i.hasNext();
            }

            @Override
            public T nextElement() {
                return this.i.next();
            }
        };
    }

    public static <T> ArrayList<T> list(Enumeration<T> enumeration) {
        ArrayList<T> arrayList = new ArrayList<T>();
        while (enumeration.hasMoreElements()) {
            arrayList.add(enumeration.nextElement());
        }
        return arrayList;
    }

    static boolean eq(Object object, Object object2) {
        return object == null ? object2 == null : object.equals(object2);
    }

    public static int frequency(Collection<?> collection, Object object) {
        int n = 0;
        if (object == null) {
            for (Object obj : collection) {
                if (obj != null) continue;
                ++n;
            }
        } else {
            for (Object obj : collection) {
                if (!object.equals(obj)) continue;
                ++n;
            }
        }
        return n;
    }

    public static boolean disjoint(Collection<?> collection, Collection<?> collection2) {
        if (collection instanceof Set && !(collection2 instanceof Set) || collection.size() > collection2.size()) {
            Collection<?> collection3 = collection;
            collection = collection2;
            collection2 = collection3;
        }
        for (Object e : collection) {
            if (!collection2.contains(e)) continue;
            return false;
        }
        return true;
    }

    public static <T> boolean addAll(Collection<? super T> collection, T ... TArray) {
        boolean bl = false;
        for (T t : TArray) {
            bl |= collection.add(t);
        }
        return bl;
    }

    public static <E> Set<E> newSetFromMap(Map<E, Boolean> map) {
        return new SetFromMap<E>(map);
    }

    public static <T> Queue<T> asLifoQueue(Deque<T> deque) {
        return new AsLIFOQueue<T>(deque);
    }

    static {
        EMPTY_SET = new EmptySet();
        EMPTY_LIST = new EmptyList();
        EMPTY_MAP = new EmptyMap();
    }

    static class AsLIFOQueue<E>
    extends AbstractQueue<E>
    implements Queue<E>,
    Serializable {
        private static final long serialVersionUID = 1802017725587941708L;
        private final Deque<E> q;

        AsLIFOQueue(Deque<E> deque) {
            this.q = deque;
        }

        @Override
        public boolean add(E e) {
            this.q.addFirst(e);
            return true;
        }

        @Override
        public boolean offer(E e) {
            return this.q.offerFirst(e);
        }

        @Override
        public E poll() {
            return this.q.pollFirst();
        }

        @Override
        public E remove() {
            return this.q.removeFirst();
        }

        @Override
        public E peek() {
            return this.q.peekFirst();
        }

        @Override
        public E element() {
            return this.q.getFirst();
        }

        @Override
        public void clear() {
            this.q.clear();
        }

        @Override
        public int size() {
            return this.q.size();
        }

        @Override
        public boolean isEmpty() {
            return this.q.isEmpty();
        }

        @Override
        public boolean contains(Object object) {
            return this.q.contains(object);
        }

        @Override
        public boolean remove(Object object) {
            return this.q.remove(object);
        }

        @Override
        public Iterator<E> iterator() {
            return this.q.iterator();
        }

        @Override
        public Object[] toArray() {
            return this.q.toArray();
        }

        @Override
        public <T> T[] toArray(T[] TArray) {
            return this.q.toArray(TArray);
        }

        @Override
        public String toString() {
            return this.q.toString();
        }

        @Override
        public boolean containsAll(Collection<?> collection) {
            return this.q.containsAll(collection);
        }

        @Override
        public boolean removeAll(Collection<?> collection) {
            return this.q.removeAll(collection);
        }

        @Override
        public boolean retainAll(Collection<?> collection) {
            return this.q.retainAll(collection);
        }
    }

    private static class SetFromMap<E>
    extends AbstractSet<E>
    implements Set<E>,
    Serializable {
        private final Map<E, Boolean> m;
        private transient Set<E> s;
        private static final long serialVersionUID = 2454657854757543876L;

        SetFromMap(Map<E, Boolean> map) {
            if (!map.isEmpty()) {
                throw new IllegalArgumentException("Map is non-empty");
            }
            this.m = map;
            this.s = map.keySet();
        }

        @Override
        public void clear() {
            this.m.clear();
        }

        @Override
        public int size() {
            return this.m.size();
        }

        @Override
        public boolean isEmpty() {
            return this.m.isEmpty();
        }

        @Override
        public boolean contains(Object object) {
            return this.m.containsKey(object);
        }

        @Override
        public boolean remove(Object object) {
            return this.m.remove(object) != null;
        }

        @Override
        public boolean add(E e) {
            return this.m.put(e, Boolean.TRUE) == null;
        }

        @Override
        public Iterator<E> iterator() {
            return this.s.iterator();
        }

        @Override
        public Object[] toArray() {
            return this.s.toArray();
        }

        @Override
        public <T> T[] toArray(T[] TArray) {
            return this.s.toArray(TArray);
        }

        @Override
        public String toString() {
            return this.s.toString();
        }

        @Override
        public int hashCode() {
            return this.s.hashCode();
        }

        @Override
        public boolean equals(Object object) {
            return object == this || this.s.equals(object);
        }

        @Override
        public boolean containsAll(Collection<?> collection) {
            return this.s.containsAll(collection);
        }

        @Override
        public boolean removeAll(Collection<?> collection) {
            return this.s.removeAll(collection);
        }

        @Override
        public boolean retainAll(Collection<?> collection) {
            return this.s.retainAll(collection);
        }

        private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
            objectInputStream.defaultReadObject();
            this.s = this.m.keySet();
        }
    }

    private static class ReverseComparator2<T>
    implements Comparator<T>,
    Serializable {
        private static final long serialVersionUID = 4374092139857L;
        final Comparator<T> cmp;

        ReverseComparator2(Comparator<T> comparator) {
            assert (comparator != null);
            this.cmp = comparator;
        }

        @Override
        public int compare(T t, T t2) {
            return this.cmp.compare(t2, t);
        }

        @Override
        public boolean equals(Object object) {
            return object == this || object instanceof ReverseComparator2 && this.cmp.equals(((ReverseComparator2)object).cmp);
        }

        public int hashCode() {
            return this.cmp.hashCode() ^ Integer.MIN_VALUE;
        }
    }

    private static class ReverseComparator
    implements Comparator<Comparable<Object>>,
    Serializable {
        private static final long serialVersionUID = 7207038068494060240L;
        static final ReverseComparator REVERSE_ORDER = new ReverseComparator();

        private ReverseComparator() {
        }

        @Override
        public int compare(Comparable<Object> comparable, Comparable<Object> comparable2) {
            return comparable2.compareTo(comparable);
        }

        private Object readResolve() {
            return Collections.reverseOrder();
        }
    }

    private static class CopiesList<E>
    extends AbstractList<E>
    implements RandomAccess,
    Serializable {
        private static final long serialVersionUID = 2739099268398711800L;
        final int n;
        final E element;

        CopiesList(int n, E e) {
            assert (n >= 0);
            this.n = n;
            this.element = e;
        }

        @Override
        public int size() {
            return this.n;
        }

        @Override
        public boolean contains(Object object) {
            return this.n != 0 && Collections.eq(object, this.element);
        }

        @Override
        public int indexOf(Object object) {
            return this.contains(object) ? 0 : -1;
        }

        @Override
        public int lastIndexOf(Object object) {
            return this.contains(object) ? this.n - 1 : -1;
        }

        @Override
        public E get(int n) {
            if (n < 0 || n >= this.n) {
                throw new IndexOutOfBoundsException("Index: " + n + ", Size: " + this.n);
            }
            return this.element;
        }

        @Override
        public Object[] toArray() {
            Object[] objectArray = new Object[this.n];
            if (this.element != null) {
                Arrays.fill(objectArray, 0, this.n, this.element);
            }
            return objectArray;
        }

        @Override
        public <T> T[] toArray(T[] objectArray) {
            int n = this.n;
            if (objectArray.length < n) {
                objectArray = (Object[])Array.newInstance(objectArray.getClass().getComponentType(), n);
                if (this.element != null) {
                    Arrays.fill(objectArray, 0, n, this.element);
                }
            } else {
                Arrays.fill(objectArray, 0, n, this.element);
                if (objectArray.length > n) {
                    objectArray[n] = null;
                }
            }
            return objectArray;
        }

        @Override
        public List<E> subList(int n, int n2) {
            if (n < 0) {
                throw new IndexOutOfBoundsException("fromIndex = " + n);
            }
            if (n2 > this.n) {
                throw new IndexOutOfBoundsException("toIndex = " + n2);
            }
            if (n > n2) {
                throw new IllegalArgumentException("fromIndex(" + n + ") > toIndex(" + n2 + ")");
            }
            return new CopiesList<E>(n2 - n, this.element);
        }
    }

    private static class SingletonMap<K, V>
    extends AbstractMap<K, V>
    implements Serializable {
        private static final long serialVersionUID = -6979724477215052911L;
        private final K k;
        private final V v;
        private transient Set<K> keySet = null;
        private transient Set<Map.Entry<K, V>> entrySet = null;
        private transient Collection<V> values = null;

        SingletonMap(K k, V v) {
            this.k = k;
            this.v = v;
        }

        @Override
        public int size() {
            return 1;
        }

        @Override
        public boolean isEmpty() {
            return false;
        }

        @Override
        public boolean containsKey(Object object) {
            return Collections.eq(object, this.k);
        }

        @Override
        public boolean containsValue(Object object) {
            return Collections.eq(object, this.v);
        }

        @Override
        public V get(Object object) {
            return Collections.eq(object, this.k) ? (V)this.v : null;
        }

        @Override
        public Set<K> keySet() {
            if (this.keySet == null) {
                this.keySet = Collections.singleton(this.k);
            }
            return this.keySet;
        }

        @Override
        public Set<Map.Entry<K, V>> entrySet() {
            if (this.entrySet == null) {
                this.entrySet = Collections.singleton(new AbstractMap.SimpleImmutableEntry<K, V>(this.k, this.v));
            }
            return this.entrySet;
        }

        @Override
        public Collection<V> values() {
            if (this.values == null) {
                this.values = Collections.singleton(this.v);
            }
            return this.values;
        }
    }

    private static class SingletonList<E>
    extends AbstractList<E>
    implements RandomAccess,
    Serializable {
        private static final long serialVersionUID = 3093736618740652951L;
        private final E element;

        SingletonList(E e) {
            this.element = e;
        }

        @Override
        public Iterator<E> iterator() {
            return Collections.singletonIterator(this.element);
        }

        @Override
        public int size() {
            return 1;
        }

        @Override
        public boolean contains(Object object) {
            return Collections.eq(object, this.element);
        }

        @Override
        public E get(int n) {
            if (n != 0) {
                throw new IndexOutOfBoundsException("Index: " + n + ", Size: 1");
            }
            return this.element;
        }
    }

    private static class SingletonSet<E>
    extends AbstractSet<E>
    implements Serializable {
        private static final long serialVersionUID = 3193687207550431679L;
        private final E element;

        SingletonSet(E e) {
            this.element = e;
        }

        @Override
        public Iterator<E> iterator() {
            return Collections.singletonIterator(this.element);
        }

        @Override
        public int size() {
            return 1;
        }

        @Override
        public boolean contains(Object object) {
            return Collections.eq(object, this.element);
        }
    }

    private static class EmptyMap<K, V>
    extends AbstractMap<K, V>
    implements Serializable {
        private static final long serialVersionUID = 6428348081105594320L;

        private EmptyMap() {
        }

        @Override
        public int size() {
            return 0;
        }

        @Override
        public boolean isEmpty() {
            return true;
        }

        @Override
        public boolean containsKey(Object object) {
            return false;
        }

        @Override
        public boolean containsValue(Object object) {
            return false;
        }

        @Override
        public V get(Object object) {
            return null;
        }

        @Override
        public Set<K> keySet() {
            return Collections.emptySet();
        }

        @Override
        public Collection<V> values() {
            return Collections.emptySet();
        }

        @Override
        public Set<Map.Entry<K, V>> entrySet() {
            return Collections.emptySet();
        }

        @Override
        public boolean equals(Object object) {
            return object instanceof Map && ((Map)object).isEmpty();
        }

        @Override
        public int hashCode() {
            return 0;
        }

        private Object readResolve() {
            return EMPTY_MAP;
        }
    }

    private static class EmptyList<E>
    extends AbstractList<E>
    implements RandomAccess,
    Serializable {
        private static final long serialVersionUID = 8842843931221139166L;

        private EmptyList() {
        }

        @Override
        public Iterator<E> iterator() {
            return Collections.emptyIterator();
        }

        @Override
        public ListIterator<E> listIterator() {
            return Collections.emptyListIterator();
        }

        @Override
        public int size() {
            return 0;
        }

        @Override
        public boolean isEmpty() {
            return true;
        }

        @Override
        public boolean contains(Object object) {
            return false;
        }

        @Override
        public boolean containsAll(Collection<?> collection) {
            return collection.isEmpty();
        }

        @Override
        public Object[] toArray() {
            return new Object[0];
        }

        @Override
        public <T> T[] toArray(T[] TArray) {
            if (TArray.length > 0) {
                TArray[0] = null;
            }
            return TArray;
        }

        @Override
        public E get(int n) {
            throw new IndexOutOfBoundsException("Index: " + n);
        }

        @Override
        public boolean equals(Object object) {
            return object instanceof List && ((List)object).isEmpty();
        }

        @Override
        public int hashCode() {
            return 1;
        }

        private Object readResolve() {
            return EMPTY_LIST;
        }
    }

    private static class EmptySet<E>
    extends AbstractSet<E>
    implements Serializable {
        private static final long serialVersionUID = 1582296315990362920L;

        private EmptySet() {
        }

        @Override
        public Iterator<E> iterator() {
            return Collections.emptyIterator();
        }

        @Override
        public int size() {
            return 0;
        }

        @Override
        public boolean isEmpty() {
            return true;
        }

        @Override
        public boolean contains(Object object) {
            return false;
        }

        @Override
        public boolean containsAll(Collection<?> collection) {
            return collection.isEmpty();
        }

        @Override
        public Object[] toArray() {
            return new Object[0];
        }

        @Override
        public <T> T[] toArray(T[] TArray) {
            if (TArray.length > 0) {
                TArray[0] = null;
            }
            return TArray;
        }

        private Object readResolve() {
            return EMPTY_SET;
        }
    }

    private static class EmptyEnumeration<E>
    implements Enumeration<E> {
        static final EmptyEnumeration<Object> EMPTY_ENUMERATION = new EmptyEnumeration();

        private EmptyEnumeration() {
        }

        @Override
        public boolean hasMoreElements() {
            return false;
        }

        @Override
        public E nextElement() {
            throw new NoSuchElementException();
        }
    }

    private static class EmptyListIterator<E>
    extends EmptyIterator<E>
    implements ListIterator<E> {
        static final EmptyListIterator<Object> EMPTY_ITERATOR = new EmptyListIterator();

        private EmptyListIterator() {
        }

        @Override
        public boolean hasPrevious() {
            return false;
        }

        @Override
        public E previous() {
            throw new NoSuchElementException();
        }

        @Override
        public int nextIndex() {
            return 0;
        }

        @Override
        public int previousIndex() {
            return -1;
        }

        @Override
        public void set(E e) {
            throw new IllegalStateException();
        }

        @Override
        public void add(E e) {
            throw new UnsupportedOperationException();
        }
    }

    private static class EmptyIterator<E>
    implements Iterator<E> {
        static final EmptyIterator<Object> EMPTY_ITERATOR = new EmptyIterator();

        private EmptyIterator() {
        }

        @Override
        public boolean hasNext() {
            return false;
        }

        @Override
        public E next() {
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            throw new IllegalStateException();
        }
    }

    static class CheckedSortedMap<K, V>
    extends CheckedMap<K, V>
    implements SortedMap<K, V>,
    Serializable {
        private static final long serialVersionUID = 1599671320688067438L;
        private final SortedMap<K, V> sm;

        CheckedSortedMap(SortedMap<K, V> sortedMap, Class<K> clazz, Class<V> clazz2) {
            super(sortedMap, clazz, clazz2);
            this.sm = sortedMap;
        }

        @Override
        public Comparator<? super K> comparator() {
            return this.sm.comparator();
        }

        @Override
        public K firstKey() {
            return this.sm.firstKey();
        }

        @Override
        public K lastKey() {
            return this.sm.lastKey();
        }

        @Override
        public SortedMap<K, V> subMap(K k, K k2) {
            return Collections.checkedSortedMap(this.sm.subMap(k, k2), this.keyType, this.valueType);
        }

        @Override
        public SortedMap<K, V> headMap(K k) {
            return Collections.checkedSortedMap(this.sm.headMap(k), this.keyType, this.valueType);
        }

        @Override
        public SortedMap<K, V> tailMap(K k) {
            return Collections.checkedSortedMap(this.sm.tailMap(k), this.keyType, this.valueType);
        }
    }

    private static class CheckedMap<K, V>
    implements Map<K, V>,
    Serializable {
        private static final long serialVersionUID = 5742860141034234728L;
        private final Map<K, V> m;
        final Class<K> keyType;
        final Class<V> valueType;
        private transient Set<Map.Entry<K, V>> entrySet = null;

        private void typeCheck(Object object, Object object2) {
            if (object != null && !this.keyType.isInstance(object)) {
                throw new ClassCastException(this.badKeyMsg(object));
            }
            if (object2 != null && !this.valueType.isInstance(object2)) {
                throw new ClassCastException(this.badValueMsg(object2));
            }
        }

        private String badKeyMsg(Object object) {
            return "Attempt to insert " + object.getClass() + " key into map with key type " + this.keyType;
        }

        private String badValueMsg(Object object) {
            return "Attempt to insert " + object.getClass() + " value into map with value type " + this.valueType;
        }

        CheckedMap(Map<K, V> map, Class<K> clazz, Class<V> clazz2) {
            if (map == null || clazz == null || clazz2 == null) {
                throw new NullPointerException();
            }
            this.m = map;
            this.keyType = clazz;
            this.valueType = clazz2;
        }

        @Override
        public int size() {
            return this.m.size();
        }

        @Override
        public boolean isEmpty() {
            return this.m.isEmpty();
        }

        @Override
        public boolean containsKey(Object object) {
            return this.m.containsKey(object);
        }

        @Override
        public boolean containsValue(Object object) {
            return this.m.containsValue(object);
        }

        @Override
        public V get(Object object) {
            return this.m.get(object);
        }

        @Override
        public V remove(Object object) {
            return this.m.remove(object);
        }

        @Override
        public void clear() {
            this.m.clear();
        }

        @Override
        public Set<K> keySet() {
            return this.m.keySet();
        }

        @Override
        public Collection<V> values() {
            return this.m.values();
        }

        @Override
        public boolean equals(Object object) {
            return object == this || this.m.equals(object);
        }

        @Override
        public int hashCode() {
            return this.m.hashCode();
        }

        public String toString() {
            return this.m.toString();
        }

        @Override
        public V put(K k, V v) {
            this.typeCheck(k, v);
            return this.m.put(k, v);
        }

        @Override
        public void putAll(Map<? extends K, ? extends V> map) {
            Object[] objectArray = map.entrySet().toArray();
            ArrayList arrayList = new ArrayList(objectArray.length);
            for (Object object : objectArray) {
                Map.Entry entry = (Map.Entry)object;
                Object k = entry.getKey();
                Object v = entry.getValue();
                this.typeCheck(k, v);
                arrayList.add(new AbstractMap.SimpleImmutableEntry(k, v));
            }
            for (Map.Entry entry : arrayList) {
                this.m.put(entry.getKey(), entry.getValue());
            }
        }

        @Override
        public Set<Map.Entry<K, V>> entrySet() {
            if (this.entrySet == null) {
                this.entrySet = new CheckedEntrySet<K, V>(this.m.entrySet(), this.valueType);
            }
            return this.entrySet;
        }

        static class CheckedEntrySet<K, V>
        implements Set<Map.Entry<K, V>> {
            private final Set<Map.Entry<K, V>> s;
            private final Class<V> valueType;

            CheckedEntrySet(Set<Map.Entry<K, V>> set, Class<V> clazz) {
                this.s = set;
                this.valueType = clazz;
            }

            @Override
            public int size() {
                return this.s.size();
            }

            @Override
            public boolean isEmpty() {
                return this.s.isEmpty();
            }

            public String toString() {
                return this.s.toString();
            }

            @Override
            public int hashCode() {
                return this.s.hashCode();
            }

            @Override
            public void clear() {
                this.s.clear();
            }

            @Override
            public boolean add(Map.Entry<K, V> entry) {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean addAll(Collection<? extends Map.Entry<K, V>> collection) {
                throw new UnsupportedOperationException();
            }

            @Override
            public Iterator<Map.Entry<K, V>> iterator() {
                final Iterator<Map.Entry<K, V>> iterator = this.s.iterator();
                final Class<V> clazz = this.valueType;
                return new Iterator<Map.Entry<K, V>>(){

                    @Override
                    public boolean hasNext() {
                        return iterator.hasNext();
                    }

                    @Override
                    public void remove() {
                        iterator.remove();
                    }

                    @Override
                    public Map.Entry<K, V> next() {
                        return CheckedEntrySet.checkedEntry((Map.Entry)iterator.next(), clazz);
                    }
                };
            }

            @Override
            public Object[] toArray() {
                Object[] objectArray = this.s.toArray();
                Object[] objectArray2 = CheckedEntry.class.isInstance(objectArray.getClass().getComponentType()) ? objectArray : new Object[objectArray.length];
                for (int i = 0; i < objectArray.length; ++i) {
                    objectArray2[i] = CheckedEntrySet.checkedEntry((Map.Entry)objectArray[i], this.valueType);
                }
                return objectArray2;
            }

            @Override
            public <T> T[] toArray(T[] TArray) {
                T[] TArray2 = this.s.toArray(TArray.length == 0 ? TArray : Arrays.copyOf(TArray, 0));
                for (int i = 0; i < TArray2.length; ++i) {
                    TArray2[i] = CheckedEntrySet.checkedEntry((Map.Entry)TArray2[i], this.valueType);
                }
                if (TArray2.length > TArray.length) {
                    return TArray2;
                }
                System.arraycopy(TArray2, 0, TArray, 0, TArray2.length);
                if (TArray.length > TArray2.length) {
                    TArray[TArray2.length] = null;
                }
                return TArray;
            }

            @Override
            public boolean contains(Object object) {
                if (!(object instanceof Map.Entry)) {
                    return false;
                }
                CheckedEntry<K, V, V> checkedEntry = (CheckedEntry<K, V, V>)object;
                return this.s.contains(checkedEntry instanceof CheckedEntry ? checkedEntry : CheckedEntrySet.checkedEntry(checkedEntry, this.valueType));
            }

            @Override
            public boolean containsAll(Collection<?> collection) {
                for (Object obj : collection) {
                    if (this.contains(obj)) continue;
                    return false;
                }
                return true;
            }

            @Override
            public boolean remove(Object object) {
                if (!(object instanceof Map.Entry)) {
                    return false;
                }
                return this.s.remove(new AbstractMap.SimpleImmutableEntry((Map.Entry)object));
            }

            @Override
            public boolean removeAll(Collection<?> collection) {
                return this.batchRemove(collection, false);
            }

            @Override
            public boolean retainAll(Collection<?> collection) {
                return this.batchRemove(collection, true);
            }

            private boolean batchRemove(Collection<?> collection, boolean bl) {
                boolean bl2 = false;
                Iterator<Map.Entry<K, V>> iterator = this.iterator();
                while (iterator.hasNext()) {
                    if (collection.contains(iterator.next()) == bl) continue;
                    iterator.remove();
                    bl2 = true;
                }
                return bl2;
            }

            @Override
            public boolean equals(Object object) {
                if (object == this) {
                    return true;
                }
                if (!(object instanceof Set)) {
                    return false;
                }
                Set set = (Set)object;
                return set.size() == this.s.size() && this.containsAll(set);
            }

            static <K, V, T> CheckedEntry<K, V, T> checkedEntry(Map.Entry<K, V> entry, Class<T> clazz) {
                return new CheckedEntry<K, V, T>(entry, clazz);
            }

            private static class CheckedEntry<K, V, T>
            implements Map.Entry<K, V> {
                private final Map.Entry<K, V> e;
                private final Class<T> valueType;

                CheckedEntry(Map.Entry<K, V> entry, Class<T> clazz) {
                    this.e = entry;
                    this.valueType = clazz;
                }

                @Override
                public K getKey() {
                    return this.e.getKey();
                }

                @Override
                public V getValue() {
                    return this.e.getValue();
                }

                @Override
                public int hashCode() {
                    return this.e.hashCode();
                }

                public String toString() {
                    return this.e.toString();
                }

                @Override
                public V setValue(V v) {
                    if (v != null && !this.valueType.isInstance(v)) {
                        throw new ClassCastException(this.badValueMsg(v));
                    }
                    return this.e.setValue(v);
                }

                private String badValueMsg(Object object) {
                    return "Attempt to insert " + object.getClass() + " value into map with value type " + this.valueType;
                }

                @Override
                public boolean equals(Object object) {
                    if (object == this) {
                        return true;
                    }
                    if (!(object instanceof Map.Entry)) {
                        return false;
                    }
                    return this.e.equals(new AbstractMap.SimpleImmutableEntry((Map.Entry)object));
                }
            }
        }
    }

    static class CheckedRandomAccessList<E>
    extends CheckedList<E>
    implements RandomAccess {
        private static final long serialVersionUID = 1638200125423088369L;

        CheckedRandomAccessList(List<E> list, Class<E> clazz) {
            super(list, clazz);
        }

        @Override
        public List<E> subList(int n, int n2) {
            return new CheckedRandomAccessList(this.list.subList(n, n2), this.type);
        }
    }

    static class CheckedList<E>
    extends CheckedCollection<E>
    implements List<E> {
        private static final long serialVersionUID = 65247728283967356L;
        final List<E> list;

        CheckedList(List<E> list, Class<E> clazz) {
            super(list, clazz);
            this.list = list;
        }

        @Override
        public boolean equals(Object object) {
            return object == this || this.list.equals(object);
        }

        @Override
        public int hashCode() {
            return this.list.hashCode();
        }

        @Override
        public E get(int n) {
            return this.list.get(n);
        }

        @Override
        public E remove(int n) {
            return this.list.remove(n);
        }

        @Override
        public int indexOf(Object object) {
            return this.list.indexOf(object);
        }

        @Override
        public int lastIndexOf(Object object) {
            return this.list.lastIndexOf(object);
        }

        @Override
        public E set(int n, E e) {
            this.typeCheck(e);
            return this.list.set(n, e);
        }

        @Override
        public void add(int n, E e) {
            this.typeCheck(e);
            this.list.add(n, e);
        }

        @Override
        public boolean addAll(int n, Collection<? extends E> collection) {
            return this.list.addAll(n, this.checkedCopyOf(collection));
        }

        @Override
        public ListIterator<E> listIterator() {
            return this.listIterator(0);
        }

        @Override
        public ListIterator<E> listIterator(int n) {
            final ListIterator<E> listIterator = this.list.listIterator(n);
            return new ListIterator<E>(){

                @Override
                public boolean hasNext() {
                    return listIterator.hasNext();
                }

                @Override
                public E next() {
                    return listIterator.next();
                }

                @Override
                public boolean hasPrevious() {
                    return listIterator.hasPrevious();
                }

                @Override
                public E previous() {
                    return listIterator.previous();
                }

                @Override
                public int nextIndex() {
                    return listIterator.nextIndex();
                }

                @Override
                public int previousIndex() {
                    return listIterator.previousIndex();
                }

                @Override
                public void remove() {
                    listIterator.remove();
                }

                @Override
                public void set(E e) {
                    CheckedList.this.typeCheck(e);
                    listIterator.set(e);
                }

                @Override
                public void add(E e) {
                    CheckedList.this.typeCheck(e);
                    listIterator.add(e);
                }
            };
        }

        @Override
        public List<E> subList(int n, int n2) {
            return new CheckedList<E>(this.list.subList(n, n2), this.type);
        }
    }

    static class CheckedSortedSet<E>
    extends CheckedSet<E>
    implements SortedSet<E>,
    Serializable {
        private static final long serialVersionUID = 1599911165492914959L;
        private final SortedSet<E> ss;

        CheckedSortedSet(SortedSet<E> sortedSet, Class<E> clazz) {
            super(sortedSet, clazz);
            this.ss = sortedSet;
        }

        @Override
        public Comparator<? super E> comparator() {
            return this.ss.comparator();
        }

        @Override
        public E first() {
            return this.ss.first();
        }

        @Override
        public E last() {
            return this.ss.last();
        }

        @Override
        public SortedSet<E> subSet(E e, E e2) {
            return Collections.checkedSortedSet(this.ss.subSet(e, e2), this.type);
        }

        @Override
        public SortedSet<E> headSet(E e) {
            return Collections.checkedSortedSet(this.ss.headSet(e), this.type);
        }

        @Override
        public SortedSet<E> tailSet(E e) {
            return Collections.checkedSortedSet(this.ss.tailSet(e), this.type);
        }
    }

    static class CheckedSet<E>
    extends CheckedCollection<E>
    implements Set<E>,
    Serializable {
        private static final long serialVersionUID = 4694047833775013803L;

        CheckedSet(Set<E> set, Class<E> clazz) {
            super(set, clazz);
        }

        @Override
        public boolean equals(Object object) {
            return object == this || this.c.equals(object);
        }

        @Override
        public int hashCode() {
            return this.c.hashCode();
        }
    }

    static class CheckedCollection<E>
    implements Collection<E>,
    Serializable {
        private static final long serialVersionUID = 1578914078182001775L;
        final Collection<E> c;
        final Class<E> type;
        private E[] zeroLengthElementArray = null;

        void typeCheck(Object object) {
            if (object != null && !this.type.isInstance(object)) {
                throw new ClassCastException(this.badElementMsg(object));
            }
        }

        private String badElementMsg(Object object) {
            return "Attempt to insert " + object.getClass() + " element into collection with element type " + this.type;
        }

        CheckedCollection(Collection<E> collection, Class<E> clazz) {
            if (collection == null || clazz == null) {
                throw new NullPointerException();
            }
            this.c = collection;
            this.type = clazz;
        }

        @Override
        public int size() {
            return this.c.size();
        }

        @Override
        public boolean isEmpty() {
            return this.c.isEmpty();
        }

        @Override
        public boolean contains(Object object) {
            return this.c.contains(object);
        }

        @Override
        public Object[] toArray() {
            return this.c.toArray();
        }

        @Override
        public <T> T[] toArray(T[] TArray) {
            return this.c.toArray(TArray);
        }

        public String toString() {
            return this.c.toString();
        }

        @Override
        public boolean remove(Object object) {
            return this.c.remove(object);
        }

        @Override
        public void clear() {
            this.c.clear();
        }

        @Override
        public boolean containsAll(Collection<?> collection) {
            return this.c.containsAll(collection);
        }

        @Override
        public boolean removeAll(Collection<?> collection) {
            return this.c.removeAll(collection);
        }

        @Override
        public boolean retainAll(Collection<?> collection) {
            return this.c.retainAll(collection);
        }

        @Override
        public Iterator<E> iterator() {
            final Iterator<E> iterator = this.c.iterator();
            return new Iterator<E>(){

                @Override
                public boolean hasNext() {
                    return iterator.hasNext();
                }

                @Override
                public E next() {
                    return iterator.next();
                }

                @Override
                public void remove() {
                    iterator.remove();
                }
            };
        }

        @Override
        public boolean add(E e) {
            this.typeCheck(e);
            return this.c.add(e);
        }

        private E[] zeroLengthElementArray() {
            return this.zeroLengthElementArray != null ? this.zeroLengthElementArray : (this.zeroLengthElementArray = Collections.zeroLengthArray(this.type));
        }

        Collection<E> checkedCopyOf(Collection<? extends E> collection) {
            Object[] objectArray;
            block3: {
                objectArray = null;
                try {
                    E[] EArray = this.zeroLengthElementArray();
                    objectArray = collection.toArray(EArray);
                    if (objectArray.getClass() == EArray.getClass()) break block3;
                    objectArray = Arrays.copyOf(objectArray, objectArray.length, EArray.getClass());
                }
                catch (ArrayStoreException arrayStoreException) {
                    objectArray = (Object[])collection.toArray().clone();
                    for (E e : objectArray) {
                        this.typeCheck(e);
                    }
                }
            }
            return Arrays.asList(objectArray);
        }

        @Override
        public boolean addAll(Collection<? extends E> collection) {
            return this.c.addAll(this.checkedCopyOf(collection));
        }
    }

    static class SynchronizedSortedMap<K, V>
    extends SynchronizedMap<K, V>
    implements SortedMap<K, V> {
        private static final long serialVersionUID = -8798146769416483793L;
        private final SortedMap<K, V> sm;

        SynchronizedSortedMap(SortedMap<K, V> sortedMap) {
            super(sortedMap);
            this.sm = sortedMap;
        }

        SynchronizedSortedMap(SortedMap<K, V> sortedMap, Object object) {
            super(sortedMap, object);
            this.sm = sortedMap;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Comparator<? super K> comparator() {
            Object object = this.mutex;
            synchronized (object) {
                return this.sm.comparator();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public SortedMap<K, V> subMap(K k, K k2) {
            Object object = this.mutex;
            synchronized (object) {
                return new SynchronizedSortedMap<K, V>(this.sm.subMap(k, k2), this.mutex);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public SortedMap<K, V> headMap(K k) {
            Object object = this.mutex;
            synchronized (object) {
                return new SynchronizedSortedMap<K, V>(this.sm.headMap(k), this.mutex);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public SortedMap<K, V> tailMap(K k) {
            Object object = this.mutex;
            synchronized (object) {
                return new SynchronizedSortedMap<K, V>(this.sm.tailMap(k), this.mutex);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public K firstKey() {
            Object object = this.mutex;
            synchronized (object) {
                return this.sm.firstKey();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public K lastKey() {
            Object object = this.mutex;
            synchronized (object) {
                return this.sm.lastKey();
            }
        }
    }

    private static class SynchronizedMap<K, V>
    implements Map<K, V>,
    Serializable {
        private static final long serialVersionUID = 1978198479659022715L;
        private final Map<K, V> m;
        final Object mutex;
        private transient Set<K> keySet = null;
        private transient Set<Map.Entry<K, V>> entrySet = null;
        private transient Collection<V> values = null;

        SynchronizedMap(Map<K, V> map) {
            if (map == null) {
                throw new NullPointerException();
            }
            this.m = map;
            this.mutex = this;
        }

        SynchronizedMap(Map<K, V> map, Object object) {
            this.m = map;
            this.mutex = object;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int size() {
            Object object = this.mutex;
            synchronized (object) {
                return this.m.size();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean isEmpty() {
            Object object = this.mutex;
            synchronized (object) {
                return this.m.isEmpty();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean containsKey(Object object) {
            Object object2 = this.mutex;
            synchronized (object2) {
                return this.m.containsKey(object);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean containsValue(Object object) {
            Object object2 = this.mutex;
            synchronized (object2) {
                return this.m.containsValue(object);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public V get(Object object) {
            Object object2 = this.mutex;
            synchronized (object2) {
                return this.m.get(object);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public V put(K k, V v) {
            Object object = this.mutex;
            synchronized (object) {
                return this.m.put(k, v);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public V remove(Object object) {
            Object object2 = this.mutex;
            synchronized (object2) {
                return this.m.remove(object);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void putAll(Map<? extends K, ? extends V> map) {
            Object object = this.mutex;
            synchronized (object) {
                this.m.putAll(map);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void clear() {
            Object object = this.mutex;
            synchronized (object) {
                this.m.clear();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Set<K> keySet() {
            Object object = this.mutex;
            synchronized (object) {
                if (this.keySet == null) {
                    this.keySet = new SynchronizedSet<K>(this.m.keySet(), this.mutex);
                }
                return this.keySet;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Set<Map.Entry<K, V>> entrySet() {
            Object object = this.mutex;
            synchronized (object) {
                if (this.entrySet == null) {
                    this.entrySet = new SynchronizedSet<Map.Entry<K, V>>(this.m.entrySet(), this.mutex);
                }
                return this.entrySet;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Collection<V> values() {
            Object object = this.mutex;
            synchronized (object) {
                if (this.values == null) {
                    this.values = new SynchronizedCollection<V>(this.m.values(), this.mutex);
                }
                return this.values;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean equals(Object object) {
            Object object2 = this.mutex;
            synchronized (object2) {
                return this.m.equals(object);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int hashCode() {
            Object object = this.mutex;
            synchronized (object) {
                return this.m.hashCode();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String toString() {
            Object object = this.mutex;
            synchronized (object) {
                return this.m.toString();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
            Object object = this.mutex;
            synchronized (object) {
                objectOutputStream.defaultWriteObject();
            }
        }
    }

    static class SynchronizedRandomAccessList<E>
    extends SynchronizedList<E>
    implements RandomAccess {
        private static final long serialVersionUID = 1530674583602358482L;

        SynchronizedRandomAccessList(List<E> list) {
            super(list);
        }

        SynchronizedRandomAccessList(List<E> list, Object object) {
            super(list, object);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public List<E> subList(int n, int n2) {
            Object object = this.mutex;
            synchronized (object) {
                return new SynchronizedRandomAccessList(this.list.subList(n, n2), this.mutex);
            }
        }

        private Object writeReplace() {
            return new SynchronizedList(this.list);
        }
    }

    static class SynchronizedList<E>
    extends SynchronizedCollection<E>
    implements List<E> {
        private static final long serialVersionUID = -7754090372962971524L;
        final List<E> list;

        SynchronizedList(List<E> list) {
            super(list);
            this.list = list;
        }

        SynchronizedList(List<E> list, Object object) {
            super(list, object);
            this.list = list;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean equals(Object object) {
            Object object2 = this.mutex;
            synchronized (object2) {
                return this.list.equals(object);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int hashCode() {
            Object object = this.mutex;
            synchronized (object) {
                return this.list.hashCode();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public E get(int n) {
            Object object = this.mutex;
            synchronized (object) {
                return this.list.get(n);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public E set(int n, E e) {
            Object object = this.mutex;
            synchronized (object) {
                return this.list.set(n, e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void add(int n, E e) {
            Object object = this.mutex;
            synchronized (object) {
                this.list.add(n, e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public E remove(int n) {
            Object object = this.mutex;
            synchronized (object) {
                return this.list.remove(n);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int indexOf(Object object) {
            Object object2 = this.mutex;
            synchronized (object2) {
                return this.list.indexOf(object);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int lastIndexOf(Object object) {
            Object object2 = this.mutex;
            synchronized (object2) {
                return this.list.lastIndexOf(object);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean addAll(int n, Collection<? extends E> collection) {
            Object object = this.mutex;
            synchronized (object) {
                return this.list.addAll(n, collection);
            }
        }

        @Override
        public ListIterator<E> listIterator() {
            return this.list.listIterator();
        }

        @Override
        public ListIterator<E> listIterator(int n) {
            return this.list.listIterator(n);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public List<E> subList(int n, int n2) {
            Object object = this.mutex;
            synchronized (object) {
                return new SynchronizedList<E>(this.list.subList(n, n2), this.mutex);
            }
        }

        private Object readResolve() {
            return this.list instanceof RandomAccess ? new SynchronizedRandomAccessList<E>(this.list) : this;
        }
    }

    static class SynchronizedSortedSet<E>
    extends SynchronizedSet<E>
    implements SortedSet<E> {
        private static final long serialVersionUID = 8695801310862127406L;
        private final SortedSet<E> ss;

        SynchronizedSortedSet(SortedSet<E> sortedSet) {
            super(sortedSet);
            this.ss = sortedSet;
        }

        SynchronizedSortedSet(SortedSet<E> sortedSet, Object object) {
            super(sortedSet, object);
            this.ss = sortedSet;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Comparator<? super E> comparator() {
            Object object = this.mutex;
            synchronized (object) {
                return this.ss.comparator();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public SortedSet<E> subSet(E e, E e2) {
            Object object = this.mutex;
            synchronized (object) {
                return new SynchronizedSortedSet<E>(this.ss.subSet(e, e2), this.mutex);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public SortedSet<E> headSet(E e) {
            Object object = this.mutex;
            synchronized (object) {
                return new SynchronizedSortedSet<E>(this.ss.headSet(e), this.mutex);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public SortedSet<E> tailSet(E e) {
            Object object = this.mutex;
            synchronized (object) {
                return new SynchronizedSortedSet<E>(this.ss.tailSet(e), this.mutex);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public E first() {
            Object object = this.mutex;
            synchronized (object) {
                return this.ss.first();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public E last() {
            Object object = this.mutex;
            synchronized (object) {
                return this.ss.last();
            }
        }
    }

    static class SynchronizedSet<E>
    extends SynchronizedCollection<E>
    implements Set<E> {
        private static final long serialVersionUID = 487447009682186044L;

        SynchronizedSet(Set<E> set) {
            super(set);
        }

        SynchronizedSet(Set<E> set, Object object) {
            super(set, object);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean equals(Object object) {
            Object object2 = this.mutex;
            synchronized (object2) {
                return this.c.equals(object);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int hashCode() {
            Object object = this.mutex;
            synchronized (object) {
                return this.c.hashCode();
            }
        }
    }

    static class SynchronizedCollection<E>
    implements Collection<E>,
    Serializable {
        private static final long serialVersionUID = 3053995032091335093L;
        final Collection<E> c;
        final Object mutex;

        SynchronizedCollection(Collection<E> collection) {
            if (collection == null) {
                throw new NullPointerException();
            }
            this.c = collection;
            this.mutex = this;
        }

        SynchronizedCollection(Collection<E> collection, Object object) {
            this.c = collection;
            this.mutex = object;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int size() {
            Object object = this.mutex;
            synchronized (object) {
                return this.c.size();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean isEmpty() {
            Object object = this.mutex;
            synchronized (object) {
                return this.c.isEmpty();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean contains(Object object) {
            Object object2 = this.mutex;
            synchronized (object2) {
                return this.c.contains(object);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object[] toArray() {
            Object object = this.mutex;
            synchronized (object) {
                return this.c.toArray();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public <T> T[] toArray(T[] TArray) {
            Object object = this.mutex;
            synchronized (object) {
                return this.c.toArray(TArray);
            }
        }

        @Override
        public Iterator<E> iterator() {
            return this.c.iterator();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean add(E e) {
            Object object = this.mutex;
            synchronized (object) {
                return this.c.add(e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean remove(Object object) {
            Object object2 = this.mutex;
            synchronized (object2) {
                return this.c.remove(object);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean containsAll(Collection<?> collection) {
            Object object = this.mutex;
            synchronized (object) {
                return this.c.containsAll(collection);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean addAll(Collection<? extends E> collection) {
            Object object = this.mutex;
            synchronized (object) {
                return this.c.addAll(collection);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean removeAll(Collection<?> collection) {
            Object object = this.mutex;
            synchronized (object) {
                return this.c.removeAll(collection);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean retainAll(Collection<?> collection) {
            Object object = this.mutex;
            synchronized (object) {
                return this.c.retainAll(collection);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void clear() {
            Object object = this.mutex;
            synchronized (object) {
                this.c.clear();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String toString() {
            Object object = this.mutex;
            synchronized (object) {
                return this.c.toString();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
            Object object = this.mutex;
            synchronized (object) {
                objectOutputStream.defaultWriteObject();
            }
        }
    }

    static class UnmodifiableSortedMap<K, V>
    extends UnmodifiableMap<K, V>
    implements SortedMap<K, V>,
    Serializable {
        private static final long serialVersionUID = -8806743815996713206L;
        private final SortedMap<K, ? extends V> sm;

        UnmodifiableSortedMap(SortedMap<K, ? extends V> sortedMap) {
            super(sortedMap);
            this.sm = sortedMap;
        }

        @Override
        public Comparator<? super K> comparator() {
            return this.sm.comparator();
        }

        @Override
        public SortedMap<K, V> subMap(K k, K k2) {
            return new UnmodifiableSortedMap<K, V>(this.sm.subMap(k, k2));
        }

        @Override
        public SortedMap<K, V> headMap(K k) {
            return new UnmodifiableSortedMap<K, V>(this.sm.headMap(k));
        }

        @Override
        public SortedMap<K, V> tailMap(K k) {
            return new UnmodifiableSortedMap<K, V>(this.sm.tailMap(k));
        }

        @Override
        public K firstKey() {
            return this.sm.firstKey();
        }

        @Override
        public K lastKey() {
            return this.sm.lastKey();
        }
    }

    private static class UnmodifiableMap<K, V>
    implements Map<K, V>,
    Serializable {
        private static final long serialVersionUID = -1034234728574286014L;
        private final Map<? extends K, ? extends V> m;
        private transient Set<K> keySet = null;
        private transient Set<Map.Entry<K, V>> entrySet = null;
        private transient Collection<V> values = null;

        UnmodifiableMap(Map<? extends K, ? extends V> map) {
            if (map == null) {
                throw new NullPointerException();
            }
            this.m = map;
        }

        @Override
        public int size() {
            return this.m.size();
        }

        @Override
        public boolean isEmpty() {
            return this.m.isEmpty();
        }

        @Override
        public boolean containsKey(Object object) {
            return this.m.containsKey(object);
        }

        @Override
        public boolean containsValue(Object object) {
            return this.m.containsValue(object);
        }

        @Override
        public V get(Object object) {
            return this.m.get(object);
        }

        @Override
        public V put(K k, V v) {
            throw new UnsupportedOperationException();
        }

        @Override
        public V remove(Object object) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void putAll(Map<? extends K, ? extends V> map) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Set<K> keySet() {
            if (this.keySet == null) {
                this.keySet = Collections.unmodifiableSet(this.m.keySet());
            }
            return this.keySet;
        }

        @Override
        public Set<Map.Entry<K, V>> entrySet() {
            if (this.entrySet == null) {
                this.entrySet = new UnmodifiableEntrySet<K, V>(this.m.entrySet());
            }
            return this.entrySet;
        }

        @Override
        public Collection<V> values() {
            if (this.values == null) {
                this.values = Collections.unmodifiableCollection(this.m.values());
            }
            return this.values;
        }

        @Override
        public boolean equals(Object object) {
            return object == this || this.m.equals(object);
        }

        @Override
        public int hashCode() {
            return this.m.hashCode();
        }

        public String toString() {
            return this.m.toString();
        }

        static class UnmodifiableEntrySet<K, V>
        extends UnmodifiableSet<Map.Entry<K, V>> {
            private static final long serialVersionUID = 7854390611657943733L;

            UnmodifiableEntrySet(Set<? extends Map.Entry<? extends K, ? extends V>> set) {
                super(set);
            }

            @Override
            public Iterator<Map.Entry<K, V>> iterator() {
                return new Iterator<Map.Entry<K, V>>(){
                    private final Iterator<? extends Map.Entry<? extends K, ? extends V>> i;
                    {
                        this.i = UnmodifiableEntrySet.this.c.iterator();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.i.hasNext();
                    }

                    @Override
                    public Map.Entry<K, V> next() {
                        return new UnmodifiableEntry(this.i.next());
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }

            @Override
            public Object[] toArray() {
                Object[] objectArray = this.c.toArray();
                for (int i = 0; i < objectArray.length; ++i) {
                    objectArray[i] = new UnmodifiableEntry((Map.Entry)objectArray[i]);
                }
                return objectArray;
            }

            @Override
            public <T> T[] toArray(T[] TArray) {
                T[] TArray2 = this.c.toArray(TArray.length == 0 ? TArray : Arrays.copyOf(TArray, 0));
                for (int i = 0; i < TArray2.length; ++i) {
                    TArray2[i] = new UnmodifiableEntry((Map.Entry)TArray2[i]);
                }
                if (TArray2.length > TArray.length) {
                    return TArray2;
                }
                System.arraycopy(TArray2, 0, TArray, 0, TArray2.length);
                if (TArray.length > TArray2.length) {
                    TArray[TArray2.length] = null;
                }
                return TArray;
            }

            @Override
            public boolean contains(Object object) {
                if (!(object instanceof Map.Entry)) {
                    return false;
                }
                return this.c.contains(new UnmodifiableEntry((Map.Entry)object));
            }

            @Override
            public boolean containsAll(Collection<?> collection) {
                Iterator<?> iterator = collection.iterator();
                while (iterator.hasNext()) {
                    if (this.contains(iterator.next())) continue;
                    return false;
                }
                return true;
            }

            @Override
            public boolean equals(Object object) {
                if (object == this) {
                    return true;
                }
                if (!(object instanceof Set)) {
                    return false;
                }
                Set set = (Set)object;
                if (set.size() != this.c.size()) {
                    return false;
                }
                return this.containsAll(set);
            }

            private static class UnmodifiableEntry<K, V>
            implements Map.Entry<K, V> {
                private Map.Entry<? extends K, ? extends V> e;

                UnmodifiableEntry(Map.Entry<? extends K, ? extends V> entry) {
                    this.e = entry;
                }

                @Override
                public K getKey() {
                    return this.e.getKey();
                }

                @Override
                public V getValue() {
                    return this.e.getValue();
                }

                @Override
                public V setValue(V v) {
                    throw new UnsupportedOperationException();
                }

                @Override
                public int hashCode() {
                    return this.e.hashCode();
                }

                @Override
                public boolean equals(Object object) {
                    if (!(object instanceof Map.Entry)) {
                        return false;
                    }
                    Map.Entry entry = (Map.Entry)object;
                    return Collections.eq(this.e.getKey(), entry.getKey()) && Collections.eq(this.e.getValue(), entry.getValue());
                }

                public String toString() {
                    return this.e.toString();
                }
            }
        }
    }

    static class UnmodifiableRandomAccessList<E>
    extends UnmodifiableList<E>
    implements RandomAccess {
        private static final long serialVersionUID = -2542308836966382001L;

        UnmodifiableRandomAccessList(List<? extends E> list) {
            super(list);
        }

        @Override
        public List<E> subList(int n, int n2) {
            return new UnmodifiableRandomAccessList(this.list.subList(n, n2));
        }

        private Object writeReplace() {
            return new UnmodifiableList(this.list);
        }
    }

    static class UnmodifiableList<E>
    extends UnmodifiableCollection<E>
    implements List<E> {
        private static final long serialVersionUID = -283967356065247728L;
        final List<? extends E> list;

        UnmodifiableList(List<? extends E> list) {
            super(list);
            this.list = list;
        }

        @Override
        public boolean equals(Object object) {
            return object == this || this.list.equals(object);
        }

        @Override
        public int hashCode() {
            return this.list.hashCode();
        }

        @Override
        public E get(int n) {
            return this.list.get(n);
        }

        @Override
        public E set(int n, E e) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void add(int n, E e) {
            throw new UnsupportedOperationException();
        }

        @Override
        public E remove(int n) {
            throw new UnsupportedOperationException();
        }

        @Override
        public int indexOf(Object object) {
            return this.list.indexOf(object);
        }

        @Override
        public int lastIndexOf(Object object) {
            return this.list.lastIndexOf(object);
        }

        @Override
        public boolean addAll(int n, Collection<? extends E> collection) {
            throw new UnsupportedOperationException();
        }

        @Override
        public ListIterator<E> listIterator() {
            return this.listIterator(0);
        }

        @Override
        public ListIterator<E> listIterator(final int n) {
            return new ListIterator<E>(){
                private final ListIterator<? extends E> i;
                {
                    this.i = UnmodifiableList.this.list.listIterator(n);
                }

                @Override
                public boolean hasNext() {
                    return this.i.hasNext();
                }

                @Override
                public E next() {
                    return this.i.next();
                }

                @Override
                public boolean hasPrevious() {
                    return this.i.hasPrevious();
                }

                @Override
                public E previous() {
                    return this.i.previous();
                }

                @Override
                public int nextIndex() {
                    return this.i.nextIndex();
                }

                @Override
                public int previousIndex() {
                    return this.i.previousIndex();
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }

                @Override
                public void set(E e) {
                    throw new UnsupportedOperationException();
                }

                @Override
                public void add(E e) {
                    throw new UnsupportedOperationException();
                }
            };
        }

        @Override
        public List<E> subList(int n, int n2) {
            return new UnmodifiableList<E>(this.list.subList(n, n2));
        }

        private Object readResolve() {
            return this.list instanceof RandomAccess ? new UnmodifiableRandomAccessList<E>(this.list) : this;
        }
    }

    static class UnmodifiableSortedSet<E>
    extends UnmodifiableSet<E>
    implements SortedSet<E>,
    Serializable {
        private static final long serialVersionUID = -4929149591599911165L;
        private final SortedSet<E> ss;

        UnmodifiableSortedSet(SortedSet<E> sortedSet) {
            super(sortedSet);
            this.ss = sortedSet;
        }

        @Override
        public Comparator<? super E> comparator() {
            return this.ss.comparator();
        }

        @Override
        public SortedSet<E> subSet(E e, E e2) {
            return new UnmodifiableSortedSet<E>(this.ss.subSet(e, e2));
        }

        @Override
        public SortedSet<E> headSet(E e) {
            return new UnmodifiableSortedSet<E>(this.ss.headSet(e));
        }

        @Override
        public SortedSet<E> tailSet(E e) {
            return new UnmodifiableSortedSet<E>(this.ss.tailSet(e));
        }

        @Override
        public E first() {
            return this.ss.first();
        }

        @Override
        public E last() {
            return this.ss.last();
        }
    }

    static class UnmodifiableSet<E>
    extends UnmodifiableCollection<E>
    implements Set<E>,
    Serializable {
        private static final long serialVersionUID = -9215047833775013803L;

        UnmodifiableSet(Set<? extends E> set) {
            super(set);
        }

        @Override
        public boolean equals(Object object) {
            return object == this || this.c.equals(object);
        }

        @Override
        public int hashCode() {
            return this.c.hashCode();
        }
    }

    static class UnmodifiableCollection<E>
    implements Collection<E>,
    Serializable {
        private static final long serialVersionUID = 1820017752578914078L;
        final Collection<? extends E> c;

        UnmodifiableCollection(Collection<? extends E> collection) {
            if (collection == null) {
                throw new NullPointerException();
            }
            this.c = collection;
        }

        @Override
        public int size() {
            return this.c.size();
        }

        @Override
        public boolean isEmpty() {
            return this.c.isEmpty();
        }

        @Override
        public boolean contains(Object object) {
            return this.c.contains(object);
        }

        @Override
        public Object[] toArray() {
            return this.c.toArray();
        }

        @Override
        public <T> T[] toArray(T[] TArray) {
            return this.c.toArray(TArray);
        }

        public String toString() {
            return this.c.toString();
        }

        @Override
        public Iterator<E> iterator() {
            return new Iterator<E>(){
                private final Iterator<? extends E> i;
                {
                    this.i = UnmodifiableCollection.this.c.iterator();
                }

                @Override
                public boolean hasNext() {
                    return this.i.hasNext();
                }

                @Override
                public E next() {
                    return this.i.next();
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }

        @Override
        public boolean add(E e) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean remove(Object object) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean containsAll(Collection<?> collection) {
            return this.c.containsAll(collection);
        }

        @Override
        public boolean addAll(Collection<? extends E> collection) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean removeAll(Collection<?> collection) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean retainAll(Collection<?> collection) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException();
        }
    }

    private static interface SelfComparable
    extends Comparable<SelfComparable> {
    }
}

