/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import sun.util.calendar.BaseCalendar;
import sun.util.calendar.CalendarDate;
import sun.util.calendar.CalendarSystem;
import sun.util.calendar.CalendarUtils;
import sun.util.calendar.Era;
import sun.util.calendar.Gregorian;
import sun.util.calendar.JulianCalendar;
import sun.util.calendar.ZoneInfo;

public class GregorianCalendar
extends Calendar {
    public static final int BC = 0;
    static final int BCE = 0;
    public static final int AD = 1;
    static final int CE = 1;
    private static final int EPOCH_OFFSET = 719163;
    private static final int EPOCH_YEAR = 1970;
    static final int[] MONTH_LENGTH = new int[]{31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};
    static final int[] LEAP_MONTH_LENGTH = new int[]{31, 29, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};
    private static final int ONE_SECOND = 1000;
    private static final int ONE_MINUTE = 60000;
    private static final int ONE_HOUR = 3600000;
    private static final long ONE_DAY = 86400000L;
    private static final long ONE_WEEK = 604800000L;
    static final int[] MIN_VALUES = new int[]{0, 1, 0, 1, 0, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, -46800000, 0};
    static final int[] LEAST_MAX_VALUES = new int[]{1, 292269054, 11, 52, 4, 28, 365, 7, 4, 1, 11, 23, 59, 59, 999, 50400000, 1200000};
    static final int[] MAX_VALUES = new int[]{1, 292278994, 11, 53, 6, 31, 366, 7, 6, 1, 11, 23, 59, 59, 999, 50400000, 0x6DDD00};
    static final long serialVersionUID = -8125100834729963327L;
    private static final Gregorian gcal = CalendarSystem.getGregorianCalendar();
    private static JulianCalendar jcal;
    private static Era[] jeras;
    static final long DEFAULT_GREGORIAN_CUTOVER = -12219292800000L;
    private long gregorianCutover = -12219292800000L;
    private transient long gregorianCutoverDate = 577736L;
    private transient int gregorianCutoverYear = 1582;
    private transient int gregorianCutoverYearJulian = 1582;
    private transient BaseCalendar.Date gdate;
    private transient BaseCalendar.Date cdate;
    private transient BaseCalendar calsys;
    private transient int[] zoneOffsets;
    private transient int[] originalFields;
    private transient long cachedFixedDate = Long.MIN_VALUE;

    public GregorianCalendar() {
        this(TimeZone.getDefaultRef(), Locale.getDefault());
        this.setZoneShared(true);
    }

    public GregorianCalendar(TimeZone timeZone) {
        this(timeZone, Locale.getDefault());
    }

    public GregorianCalendar(Locale locale) {
        this(TimeZone.getDefaultRef(), locale);
        this.setZoneShared(true);
    }

    public GregorianCalendar(TimeZone timeZone, Locale locale) {
        super(timeZone, locale);
        this.gdate = gcal.newCalendarDate(timeZone);
        this.setTimeInMillis(System.currentTimeMillis());
    }

    public GregorianCalendar(int n, int n2, int n3) {
        this(n, n2, n3, 0, 0, 0, 0);
    }

    public GregorianCalendar(int n, int n2, int n3, int n4, int n5) {
        this(n, n2, n3, n4, n5, 0, 0);
    }

    public GregorianCalendar(int n, int n2, int n3, int n4, int n5, int n6) {
        this(n, n2, n3, n4, n5, n6, 0);
    }

    GregorianCalendar(int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        this.gdate = gcal.newCalendarDate(this.getZone());
        this.set(1, n);
        this.set(2, n2);
        this.set(5, n3);
        if (n4 >= 12 && n4 <= 23) {
            this.internalSet(9, 1);
            this.internalSet(10, n4 - 12);
        } else {
            this.internalSet(10, n4);
        }
        this.setFieldsComputed(1536);
        this.set(11, n4);
        this.set(12, n5);
        this.set(13, n6);
        this.internalSet(14, n7);
    }

    public void setGregorianChange(Date date) {
        long l = date.getTime();
        if (l == this.gregorianCutover) {
            return;
        }
        this.complete();
        this.setGregorianChange(l);
    }

    private void setGregorianChange(long l) {
        this.gregorianCutover = l;
        this.gregorianCutoverDate = CalendarUtils.floorDivide(l, 86400000L) + 719163L;
        if (l == Long.MAX_VALUE) {
            ++this.gregorianCutoverDate;
        }
        BaseCalendar.Date date = this.getGregorianCutoverDate();
        this.gregorianCutoverYear = date.getYear();
        BaseCalendar baseCalendar = GregorianCalendar.getJulianCalendarSystem();
        date = (BaseCalendar.Date)baseCalendar.newCalendarDate(TimeZone.NO_TIMEZONE);
        baseCalendar.getCalendarDateFromFixedDate(date, this.gregorianCutoverDate - 1L);
        this.gregorianCutoverYearJulian = date.getNormalizedYear();
        if (this.time < this.gregorianCutover) {
            this.setUnnormalized();
        }
    }

    public final Date getGregorianChange() {
        return new Date(this.gregorianCutover);
    }

    public boolean isLeapYear(int n) {
        boolean bl;
        if ((n & 3) != 0) {
            return false;
        }
        if (n > this.gregorianCutoverYear) {
            return n % 100 != 0 || n % 400 == 0;
        }
        if (n < this.gregorianCutoverYearJulian) {
            return true;
        }
        if (this.gregorianCutoverYear == this.gregorianCutoverYearJulian) {
            BaseCalendar.Date date = this.getCalendarDate(this.gregorianCutoverDate);
            bl = date.getMonth() < 3;
        } else {
            boolean bl2 = bl = n == this.gregorianCutoverYear;
        }
        return bl ? n % 100 != 0 || n % 400 == 0 : true;
    }

    @Override
    public boolean equals(Object object) {
        return object instanceof GregorianCalendar && super.equals(object) && this.gregorianCutover == ((GregorianCalendar)object).gregorianCutover;
    }

    @Override
    public int hashCode() {
        return super.hashCode() ^ (int)this.gregorianCutoverDate;
    }

    @Override
    public void add(int n, int n2) {
        if (n2 == 0) {
            return;
        }
        if (n < 0 || n >= 15) {
            throw new IllegalArgumentException();
        }
        this.complete();
        if (n == 1) {
            int n3 = this.internalGet(1);
            if (this.internalGetEra() == 1) {
                if ((n3 += n2) > 0) {
                    this.set(1, n3);
                } else {
                    this.set(1, 1 - n3);
                    this.set(0, 0);
                }
            } else if ((n3 -= n2) > 0) {
                this.set(1, n3);
            } else {
                this.set(1, 1 - n3);
                this.set(0, 1);
            }
            this.pinDayOfMonth();
        } else if (n == 2) {
            int n4 = this.internalGet(2) + n2;
            int n5 = this.internalGet(1);
            int n6 = n4 >= 0 ? n4 / 12 : (n4 + 1) / 12 - 1;
            if (n6 != 0) {
                if (this.internalGetEra() == 1) {
                    if ((n5 += n6) > 0) {
                        this.set(1, n5);
                    } else {
                        this.set(1, 1 - n5);
                        this.set(0, 0);
                    }
                } else if ((n5 -= n6) > 0) {
                    this.set(1, n5);
                } else {
                    this.set(1, 1 - n5);
                    this.set(0, 1);
                }
            }
            if (n4 >= 0) {
                this.set(2, n4 % 12);
            } else {
                if ((n4 %= 12) < 0) {
                    n4 += 12;
                }
                this.set(2, 0 + n4);
            }
            this.pinDayOfMonth();
        } else if (n == 0) {
            int n7 = this.internalGet(0) + n2;
            if (n7 < 0) {
                n7 = 0;
            }
            if (n7 > 1) {
                n7 = 1;
            }
            this.set(0, n7);
        } else {
            long l = n2;
            long l2 = 0L;
            switch (n) {
                case 10: 
                case 11: {
                    l *= 3600000L;
                    break;
                }
                case 12: {
                    l *= 60000L;
                    break;
                }
                case 13: {
                    l *= 1000L;
                    break;
                }
                case 14: {
                    break;
                }
                case 3: 
                case 4: 
                case 8: {
                    l *= 7L;
                    break;
                }
                case 5: 
                case 6: 
                case 7: {
                    break;
                }
                case 9: {
                    l = n2 / 2;
                    l2 = 12 * (n2 % 2);
                }
            }
            if (n >= 10) {
                this.setTimeInMillis(this.time + l);
                return;
            }
            long l3 = this.getCurrentFixedDate();
            l2 += (long)this.internalGet(11);
            l2 *= 60L;
            l2 += (long)this.internalGet(12);
            l2 *= 60L;
            l2 += (long)this.internalGet(13);
            l2 *= 1000L;
            if ((l2 += (long)this.internalGet(14)) >= 86400000L) {
                ++l3;
                l2 -= 86400000L;
            } else if (l2 < 0L) {
                --l3;
                l2 += 86400000L;
            }
            int n8 = this.internalGet(15) + this.internalGet(16);
            this.setTimeInMillis(((l3 += l) - 719163L) * 86400000L + l2 - (long)n8);
            if ((n8 -= this.internalGet(15) + this.internalGet(16)) != 0) {
                this.setTimeInMillis(this.time + (long)n8);
                long l4 = this.getCurrentFixedDate();
                if (l4 != l3) {
                    this.setTimeInMillis(this.time - (long)n8);
                }
            }
        }
    }

    @Override
    public void roll(int n, boolean bl) {
        this.roll(n, bl ? 1 : -1);
    }

    @Override
    public void roll(int n, int n2) {
        if (n2 == 0) {
            return;
        }
        if (n < 0 || n >= 15) {
            throw new IllegalArgumentException();
        }
        this.complete();
        int n3 = this.getMinimum(n);
        int n4 = this.getMaximum(n);
        switch (n) {
            case 0: 
            case 1: 
            case 9: 
            case 12: 
            case 13: 
            case 14: {
                break;
            }
            case 10: 
            case 11: {
                int n5 = n4 + 1;
                int n6 = this.internalGet(n);
                int n7 = (n6 + n2) % n5;
                if (n7 < 0) {
                    n7 += n5;
                }
                this.time += (long)(3600000 * (n7 - n6));
                CalendarDate calendarDate = this.calsys.getCalendarDate(this.time, this.getZone());
                if (this.internalGet(5) != calendarDate.getDayOfMonth()) {
                    calendarDate.setDate(this.internalGet(1), this.internalGet(2) + 1, this.internalGet(5));
                    if (n == 10) {
                        assert (this.internalGet(9) == 1);
                        calendarDate.addHours(12);
                    }
                    this.time = this.calsys.getTime(calendarDate);
                }
                int n8 = calendarDate.getHours();
                this.internalSet(n, n8 % n5);
                if (n == 10) {
                    this.internalSet(11, n8);
                } else {
                    this.internalSet(9, n8 / 12);
                    this.internalSet(10, n8 % 12);
                }
                int n9 = calendarDate.getZoneOffset();
                int n10 = calendarDate.getDaylightSaving();
                this.internalSet(15, n9 - n10);
                this.internalSet(16, n10);
                return;
            }
            case 2: {
                if (!this.isCutoverYear(this.cdate.getNormalizedYear())) {
                    int n11 = (this.internalGet(2) + n2) % 12;
                    if (n11 < 0) {
                        n11 += 12;
                    }
                    this.set(2, n11);
                    int n12 = this.monthLength(n11);
                    if (this.internalGet(5) > n12) {
                        this.set(5, n12);
                    }
                } else {
                    int n13 = this.getActualMaximum(2) + 1;
                    int n14 = (this.internalGet(2) + n2) % n13;
                    if (n14 < 0) {
                        n14 += n13;
                    }
                    this.set(2, n14);
                    int n15 = this.getActualMaximum(5);
                    if (this.internalGet(5) > n15) {
                        this.set(5, n15);
                    }
                }
                return;
            }
            case 3: {
                long l;
                long l2;
                int n16 = this.cdate.getNormalizedYear();
                n4 = this.getActualMaximum(3);
                this.set(7, this.internalGet(7));
                int n17 = this.internalGet(3);
                int n18 = n17 + n2;
                if (!this.isCutoverYear(n16)) {
                    if (n18 > n3 && n18 < n4) {
                        this.set(3, n18);
                        return;
                    }
                    long l3 = this.getCurrentFixedDate();
                    long l4 = l3 - (long)(7 * (n17 - n3));
                    if (this.calsys.getYearFromFixedDate(l4) != n16) {
                        ++n3;
                    }
                    if (this.calsys.getYearFromFixedDate(l3 += (long)(7 * (n4 - this.internalGet(3)))) == n16) break;
                    --n4;
                    break;
                }
                BaseCalendar baseCalendar = this.gregorianCutoverYear == this.gregorianCutoverYearJulian ? this.getCutoverCalendarSystem() : (n16 == this.gregorianCutoverYear ? gcal : GregorianCalendar.getJulianCalendarSystem());
                if (baseCalendar.getYearFromFixedDate(l2 = (l = this.getCurrentFixedDate()) - (long)(7 * (n17 - n3))) != n16) {
                    ++n3;
                }
                BaseCalendar baseCalendar2 = baseCalendar = (l += (long)(7 * (n4 - n17))) >= this.gregorianCutoverDate ? gcal : GregorianCalendar.getJulianCalendarSystem();
                if (baseCalendar.getYearFromFixedDate(l) != n16) {
                    --n4;
                }
                n18 = GregorianCalendar.getRolledValue(n17, n2, n3, n4) - 1;
                BaseCalendar.Date date = this.getCalendarDate(l2 + (long)(n18 * 7));
                this.set(2, date.getMonth() - 1);
                this.set(5, date.getDayOfMonth());
                return;
            }
            case 4: {
                int n19;
                int n20;
                long l;
                boolean bl = this.isCutoverYear(this.cdate.getNormalizedYear());
                int n21 = this.internalGet(7) - this.getFirstDayOfWeek();
                if (n21 < 0) {
                    n21 += 7;
                }
                long l5 = this.getCurrentFixedDate();
                if (bl) {
                    l = this.getFixedDateMonth1(this.cdate, l5);
                    n20 = this.actualMonthLength();
                } else {
                    l = l5 - (long)this.internalGet(5) + 1L;
                    n20 = this.calsys.getMonthLength(this.cdate);
                }
                long l6 = BaseCalendar.getDayOfWeekDateOnOrBefore(l + 6L, this.getFirstDayOfWeek());
                if ((int)(l6 - l) >= this.getMinimalDaysInFirstWeek()) {
                    l6 -= 7L;
                }
                n4 = this.getActualMaximum(n);
                int n22 = GregorianCalendar.getRolledValue(this.internalGet(n), n2, 1, n4) - 1;
                long l7 = l6 + (long)(n22 * 7) + (long)n21;
                if (l7 < l) {
                    l7 = l;
                } else if (l7 >= l + (long)n20) {
                    l7 = l + (long)n20 - 1L;
                }
                if (bl) {
                    BaseCalendar.Date date = this.getCalendarDate(l7);
                    n19 = date.getDayOfMonth();
                } else {
                    n19 = (int)(l7 - l) + 1;
                }
                this.set(5, n19);
                return;
            }
            case 5: {
                if (!this.isCutoverYear(this.cdate.getNormalizedYear())) {
                    n4 = this.calsys.getMonthLength(this.cdate);
                    break;
                }
                long l = this.getCurrentFixedDate();
                long l8 = this.getFixedDateMonth1(this.cdate, l);
                int n23 = GregorianCalendar.getRolledValue((int)(l - l8), n2, 0, this.actualMonthLength() - 1);
                BaseCalendar.Date date = this.getCalendarDate(l8 + (long)n23);
                assert (date.getMonth() - 1 == this.internalGet(2));
                this.set(5, date.getDayOfMonth());
                return;
            }
            case 6: {
                n4 = this.getActualMaximum(n);
                if (!this.isCutoverYear(this.cdate.getNormalizedYear())) break;
                long l = this.getCurrentFixedDate();
                long l9 = l - (long)this.internalGet(6) + 1L;
                int n24 = GregorianCalendar.getRolledValue((int)(l - l9) + 1, n2, n3, n4);
                BaseCalendar.Date date = this.getCalendarDate(l9 + (long)n24 - 1L);
                this.set(2, date.getMonth() - 1);
                this.set(5, date.getDayOfMonth());
                return;
            }
            case 7: {
                long l;
                int n25;
                if (!this.isCutoverYear(this.cdate.getNormalizedYear()) && (n25 = this.internalGet(3)) > 1 && n25 < 52) {
                    this.set(3, n25);
                    n4 = 7;
                    break;
                }
                if ((n2 %= 7) == 0) {
                    return;
                }
                long l10 = this.getCurrentFixedDate();
                if ((l10 += (long)n2) < (l = BaseCalendar.getDayOfWeekDateOnOrBefore(l10, this.getFirstDayOfWeek()))) {
                    l10 += 7L;
                } else if (l10 >= l + 7L) {
                    l10 -= 7L;
                }
                BaseCalendar.Date date = this.getCalendarDate(l10);
                this.set(0, date.getNormalizedYear() <= 0 ? 0 : 1);
                this.set(date.getYear(), date.getMonth() - 1, date.getDayOfMonth());
                return;
            }
            case 8: {
                int n26;
                n3 = 1;
                if (!this.isCutoverYear(this.cdate.getNormalizedYear())) {
                    int n27 = this.internalGet(5);
                    int n28 = this.calsys.getMonthLength(this.cdate);
                    int n29 = n28 % 7;
                    n4 = n28 / 7;
                    int n30 = (n27 - 1) % 7;
                    if (n30 < n29) {
                        ++n4;
                    }
                    this.set(7, this.internalGet(7));
                    break;
                }
                long l = this.getCurrentFixedDate();
                long l11 = this.getFixedDateMonth1(this.cdate, l);
                int n31 = this.actualMonthLength();
                int n32 = n31 % 7;
                n4 = n31 / 7;
                int n33 = (int)(l - l11) % 7;
                if (n33 < n32) {
                    ++n4;
                }
                BaseCalendar baseCalendar = (l = l11 + (long)((n26 = GregorianCalendar.getRolledValue(this.internalGet(n), n2, n3, n4) - 1) * 7) + (long)n33) >= this.gregorianCutoverDate ? gcal : GregorianCalendar.getJulianCalendarSystem();
                BaseCalendar.Date date = (BaseCalendar.Date)baseCalendar.newCalendarDate(TimeZone.NO_TIMEZONE);
                baseCalendar.getCalendarDateFromFixedDate(date, l);
                this.set(5, date.getDayOfMonth());
                return;
            }
        }
        this.set(n, GregorianCalendar.getRolledValue(this.internalGet(n), n2, n3, n4));
    }

    @Override
    public int getMinimum(int n) {
        return MIN_VALUES[n];
    }

    @Override
    public int getMaximum(int n) {
        switch (n) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: {
                if (this.gregorianCutoverYear > 200) break;
                GregorianCalendar gregorianCalendar = (GregorianCalendar)this.clone();
                gregorianCalendar.setLenient(true);
                gregorianCalendar.setTimeInMillis(this.gregorianCutover);
                int n2 = gregorianCalendar.getActualMaximum(n);
                gregorianCalendar.setTimeInMillis(this.gregorianCutover - 1L);
                int n3 = gregorianCalendar.getActualMaximum(n);
                return Math.max(MAX_VALUES[n], Math.max(n2, n3));
            }
        }
        return MAX_VALUES[n];
    }

    @Override
    public int getGreatestMinimum(int n) {
        if (n == 5) {
            BaseCalendar.Date date = this.getGregorianCutoverDate();
            long l = this.getFixedDateMonth1(date, this.gregorianCutoverDate);
            date = this.getCalendarDate(l);
            return Math.max(MIN_VALUES[n], date.getDayOfMonth());
        }
        return MIN_VALUES[n];
    }

    @Override
    public int getLeastMaximum(int n) {
        switch (n) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: {
                GregorianCalendar gregorianCalendar = (GregorianCalendar)this.clone();
                gregorianCalendar.setLenient(true);
                gregorianCalendar.setTimeInMillis(this.gregorianCutover);
                int n2 = gregorianCalendar.getActualMaximum(n);
                gregorianCalendar.setTimeInMillis(this.gregorianCutover - 1L);
                int n3 = gregorianCalendar.getActualMaximum(n);
                return Math.min(LEAST_MAX_VALUES[n], Math.min(n2, n3));
            }
        }
        return LEAST_MAX_VALUES[n];
    }

    @Override
    public int getActualMinimum(int n) {
        if (n == 5) {
            GregorianCalendar gregorianCalendar = this.getNormalizedCalendar();
            int n2 = gregorianCalendar.cdate.getNormalizedYear();
            if (n2 == this.gregorianCutoverYear || n2 == this.gregorianCutoverYearJulian) {
                long l = this.getFixedDateMonth1(gregorianCalendar.cdate, gregorianCalendar.calsys.getFixedDate(gregorianCalendar.cdate));
                BaseCalendar.Date date = this.getCalendarDate(l);
                return date.getDayOfMonth();
            }
        }
        return this.getMinimum(n);
    }

    @Override
    public int getActualMaximum(int n) {
        if ((0x1FE81 & 1 << n) != 0) {
            return this.getMaximum(n);
        }
        GregorianCalendar gregorianCalendar = this.getNormalizedCalendar();
        BaseCalendar.Date date = gregorianCalendar.cdate;
        BaseCalendar baseCalendar = gregorianCalendar.calsys;
        int n2 = date.getNormalizedYear();
        int n3 = -1;
        switch (n) {
            case 2: {
                long l;
                if (!gregorianCalendar.isCutoverYear(n2)) {
                    n3 = 11;
                    break;
                }
                while ((l = gcal.getFixedDate(++n2, 1, 1, null)) < this.gregorianCutoverDate) {
                }
                BaseCalendar.Date date2 = (BaseCalendar.Date)date.clone();
                baseCalendar.getCalendarDateFromFixedDate(date2, l - 1L);
                n3 = date2.getMonth() - 1;
                break;
            }
            case 5: {
                long l;
                n3 = baseCalendar.getMonthLength(date);
                if (!gregorianCalendar.isCutoverYear(n2) || date.getDayOfMonth() == n3 || (l = gregorianCalendar.getCurrentFixedDate()) >= this.gregorianCutoverDate) break;
                int n4 = gregorianCalendar.actualMonthLength();
                long l2 = gregorianCalendar.getFixedDateMonth1(gregorianCalendar.cdate, l) + (long)n4 - 1L;
                BaseCalendar.Date date3 = gregorianCalendar.getCalendarDate(l2);
                n3 = date3.getDayOfMonth();
                break;
            }
            case 6: {
                long l;
                if (!gregorianCalendar.isCutoverYear(n2)) {
                    n3 = baseCalendar.getYearLength(date);
                    break;
                }
                if (this.gregorianCutoverYear == this.gregorianCutoverYearJulian) {
                    BaseCalendar baseCalendar2 = gregorianCalendar.getCutoverCalendarSystem();
                    l = baseCalendar2.getFixedDate(n2, 1, 1, null);
                } else {
                    l = n2 == this.gregorianCutoverYearJulian ? baseCalendar.getFixedDate(n2, 1, 1, null) : this.gregorianCutoverDate;
                }
                long l3 = gcal.getFixedDate(++n2, 1, 1, null);
                if (l3 < this.gregorianCutoverDate) {
                    l3 = this.gregorianCutoverDate;
                }
                assert (l <= baseCalendar.getFixedDate(date.getNormalizedYear(), date.getMonth(), date.getDayOfMonth(), date));
                assert (l3 >= baseCalendar.getFixedDate(date.getNormalizedYear(), date.getMonth(), date.getDayOfMonth(), date));
                n3 = (int)(l3 - l);
                break;
            }
            case 3: {
                if (!gregorianCalendar.isCutoverYear(n2)) {
                    CalendarDate calendarDate = baseCalendar.newCalendarDate(TimeZone.NO_TIMEZONE);
                    calendarDate.setDate(date.getYear(), 1, 1);
                    int n5 = baseCalendar.getDayOfWeek(calendarDate);
                    if ((n5 -= this.getFirstDayOfWeek()) < 0) {
                        n5 += 7;
                    }
                    n3 = 52;
                    int n6 = n5 + this.getMinimalDaysInFirstWeek() - 1;
                    if (n6 != 6 && (!date.isLeapYear() || n6 != 5 && n6 != 12)) break;
                    ++n3;
                    break;
                }
                if (gregorianCalendar == this) {
                    gregorianCalendar = (GregorianCalendar)gregorianCalendar.clone();
                }
                gregorianCalendar.set(6, this.getActualMaximum(6));
                n3 = gregorianCalendar.get(3);
                break;
            }
            case 4: {
                if (!gregorianCalendar.isCutoverYear(n2)) {
                    CalendarDate calendarDate = baseCalendar.newCalendarDate(null);
                    calendarDate.setDate(date.getYear(), date.getMonth(), 1);
                    int n7 = baseCalendar.getDayOfWeek(calendarDate);
                    int n8 = baseCalendar.getMonthLength(calendarDate);
                    if ((n7 -= this.getFirstDayOfWeek()) < 0) {
                        n7 += 7;
                    }
                    int n9 = 7 - n7;
                    n3 = 3;
                    if (n9 >= this.getMinimalDaysInFirstWeek()) {
                        ++n3;
                    }
                    if ((n8 -= n9 + 21) <= 0) break;
                    ++n3;
                    if (n8 <= 7) break;
                    ++n3;
                    break;
                }
                if (gregorianCalendar == this) {
                    gregorianCalendar = (GregorianCalendar)gregorianCalendar.clone();
                }
                int n10 = gregorianCalendar.internalGet(1);
                int n11 = gregorianCalendar.internalGet(2);
                do {
                    n3 = gregorianCalendar.get(4);
                    gregorianCalendar.add(4, 1);
                } while (gregorianCalendar.get(1) == n10 && gregorianCalendar.get(2) == n11);
                break;
            }
            case 8: {
                int n12;
                int n13;
                int n14 = date.getDayOfWeek();
                if (!gregorianCalendar.isCutoverYear(n2)) {
                    BaseCalendar.Date date4 = (BaseCalendar.Date)date.clone();
                    n13 = baseCalendar.getMonthLength(date4);
                    date4.setDayOfMonth(1);
                    baseCalendar.normalize(date4);
                    n12 = date4.getDayOfWeek();
                } else {
                    if (gregorianCalendar == this) {
                        gregorianCalendar = (GregorianCalendar)this.clone();
                    }
                    n13 = gregorianCalendar.actualMonthLength();
                    gregorianCalendar.set(5, gregorianCalendar.getActualMinimum(5));
                    n12 = gregorianCalendar.get(7);
                }
                int n15 = n14 - n12;
                if (n15 < 0) {
                    n15 += 7;
                }
                n3 = ((n13 -= n15) + 6) / 7;
                break;
            }
            case 1: {
                if (gregorianCalendar == this) {
                    gregorianCalendar = (GregorianCalendar)this.clone();
                }
                long l = gregorianCalendar.getYearOffsetInMillis();
                if (gregorianCalendar.internalGetEra() == 1) {
                    gregorianCalendar.setTimeInMillis(Long.MAX_VALUE);
                    n3 = gregorianCalendar.get(1);
                    long l4 = gregorianCalendar.getYearOffsetInMillis();
                    if (l <= l4) break;
                    --n3;
                    break;
                }
                BaseCalendar baseCalendar3 = gregorianCalendar.getTimeInMillis() >= this.gregorianCutover ? gcal : GregorianCalendar.getJulianCalendarSystem();
                CalendarDate calendarDate = ((CalendarSystem)baseCalendar3).getCalendarDate(Long.MIN_VALUE, this.getZone());
                long l5 = (baseCalendar.getDayOfYear(calendarDate) - 1L) * 24L + (long)calendarDate.getHours();
                l5 *= 60L;
                l5 += (long)calendarDate.getMinutes();
                l5 *= 60L;
                l5 += (long)calendarDate.getSeconds();
                l5 *= 1000L;
                l5 += (long)calendarDate.getMillis();
                n3 = calendarDate.getYear();
                if (n3 <= 0) {
                    assert (baseCalendar3 == gcal);
                    n3 = 1 - n3;
                }
                if (l >= l5) break;
                --n3;
                break;
            }
            default: {
                throw new ArrayIndexOutOfBoundsException(n);
            }
        }
        return n3;
    }

    private final long getYearOffsetInMillis() {
        long l = (this.internalGet(6) - 1) * 24;
        l += (long)this.internalGet(11);
        l *= 60L;
        l += (long)this.internalGet(12);
        l *= 60L;
        l += (long)this.internalGet(13);
        return (l *= 1000L) + (long)this.internalGet(14) - (long)(this.internalGet(15) + this.internalGet(16));
    }

    @Override
    public Object clone() {
        GregorianCalendar gregorianCalendar = (GregorianCalendar)super.clone();
        gregorianCalendar.gdate = (BaseCalendar.Date)this.gdate.clone();
        if (this.cdate != null) {
            gregorianCalendar.cdate = this.cdate != this.gdate ? (BaseCalendar.Date)this.cdate.clone() : gregorianCalendar.gdate;
        }
        gregorianCalendar.originalFields = null;
        gregorianCalendar.zoneOffsets = null;
        return gregorianCalendar;
    }

    @Override
    public TimeZone getTimeZone() {
        TimeZone timeZone = super.getTimeZone();
        this.gdate.setZone(timeZone);
        if (this.cdate != null && this.cdate != this.gdate) {
            this.cdate.setZone(timeZone);
        }
        return timeZone;
    }

    @Override
    public void setTimeZone(TimeZone timeZone) {
        super.setTimeZone(timeZone);
        this.gdate.setZone(timeZone);
        if (this.cdate != null && this.cdate != this.gdate) {
            this.cdate.setZone(timeZone);
        }
    }

    @Override
    protected void computeFields() {
        int n = 0;
        if (this.isPartiallyNormalized()) {
            n = this.getSetStateFields();
            int n2 = ~n & 0x1FFFF;
            if (n2 != 0 || this.calsys == null) {
                n |= this.computeFields(n2, n & 0x18000);
                assert (n == 131071);
            }
        } else {
            n = 131071;
            this.computeFields(n, 0);
        }
        this.setFieldsComputed(n);
    }

    private int computeFields(int n, int n2) {
        int n3;
        int n4;
        int n5 = 0;
        TimeZone timeZone = this.getZone();
        if (this.zoneOffsets == null) {
            this.zoneOffsets = new int[2];
        }
        if (n2 != 98304) {
            if (timeZone instanceof ZoneInfo) {
                n5 = ((ZoneInfo)timeZone).getOffsets(this.time, this.zoneOffsets);
            } else {
                n5 = timeZone.getOffset(this.time);
                this.zoneOffsets[0] = timeZone.getRawOffset();
                this.zoneOffsets[1] = n5 - this.zoneOffsets[0];
            }
        }
        if (n2 != 0) {
            if (GregorianCalendar.isFieldSet(n2, 15)) {
                this.zoneOffsets[0] = this.internalGet(15);
            }
            if (GregorianCalendar.isFieldSet(n2, 16)) {
                this.zoneOffsets[1] = this.internalGet(16);
            }
            n5 = this.zoneOffsets[0] + this.zoneOffsets[1];
        }
        long l = (long)n5 / 86400000L;
        int n6 = n5 % 86400000;
        l += this.time / 86400000L;
        if ((long)(n6 += (int)(this.time % 86400000L)) >= 86400000L) {
            n6 = (int)((long)n6 - 86400000L);
            ++l;
        } else {
            while (n6 < 0) {
                n6 = (int)((long)n6 + 86400000L);
                --l;
            }
        }
        int n7 = 1;
        if ((l += 719163L) >= this.gregorianCutoverDate) {
            assert (this.cachedFixedDate == Long.MIN_VALUE || this.gdate.isNormalized()) : "cache control: not normalized";
            assert (this.cachedFixedDate == Long.MIN_VALUE || gcal.getFixedDate(this.gdate.getNormalizedYear(), this.gdate.getMonth(), this.gdate.getDayOfMonth(), this.gdate) == this.cachedFixedDate) : "cache control: inconsictency, cachedFixedDate=" + this.cachedFixedDate + ", computed=" + gcal.getFixedDate(this.gdate.getNormalizedYear(), this.gdate.getMonth(), this.gdate.getDayOfMonth(), this.gdate) + ", date=" + this.gdate;
            if (l != this.cachedFixedDate) {
                gcal.getCalendarDateFromFixedDate(this.gdate, l);
                this.cachedFixedDate = l;
            }
            if ((n4 = this.gdate.getYear()) <= 0) {
                n4 = 1 - n4;
                n7 = 0;
            }
            this.calsys = gcal;
            this.cdate = this.gdate;
            assert (this.cdate.getDayOfWeek() > 0) : "dow=" + this.cdate.getDayOfWeek() + ", date=" + this.cdate;
        } else {
            this.calsys = GregorianCalendar.getJulianCalendarSystem();
            this.cdate = jcal.newCalendarDate(this.getZone());
            jcal.getCalendarDateFromFixedDate(this.cdate, l);
            Era era = this.cdate.getEra();
            if (era == jeras[0]) {
                n7 = 0;
            }
            n4 = this.cdate.getYear();
        }
        this.internalSet(0, n7);
        this.internalSet(1, n4);
        int n8 = n | 3;
        int n9 = this.cdate.getMonth() - 1;
        int n10 = this.cdate.getDayOfMonth();
        if ((n & 0xA4) != 0) {
            this.internalSet(2, n9);
            this.internalSet(5, n10);
            this.internalSet(7, this.cdate.getDayOfWeek());
            n8 |= 0xA4;
        }
        if ((n & 0x7E00) != 0) {
            if (n6 != 0) {
                n3 = n6 / 3600000;
                this.internalSet(11, n3);
                this.internalSet(9, n3 / 12);
                this.internalSet(10, n3 % 12);
                int n11 = n6 % 3600000;
                this.internalSet(12, n11 / 60000);
                this.internalSet(13, (n11 %= 60000) / 1000);
                this.internalSet(14, n11 % 1000);
            } else {
                this.internalSet(11, 0);
                this.internalSet(9, 0);
                this.internalSet(10, 0);
                this.internalSet(12, 0);
                this.internalSet(13, 0);
                this.internalSet(14, 0);
            }
            n8 |= 0x7E00;
        }
        if ((n & 0x18000) != 0) {
            this.internalSet(15, this.zoneOffsets[0]);
            this.internalSet(16, this.zoneOffsets[1]);
            n8 |= 0x18000;
        }
        if ((n & 0x158) != 0) {
            int n12;
            n3 = this.cdate.getNormalizedYear();
            long l2 = this.calsys.getFixedDate(n3, 1, 1, this.cdate);
            int n13 = (int)(l - l2) + 1;
            long l3 = l - (long)n10 + 1L;
            int n14 = 0;
            int n15 = this.calsys == gcal ? this.gregorianCutoverYear : this.gregorianCutoverYearJulian;
            int n16 = n10 - 1;
            if (n3 == n15) {
                if (this.getCutoverCalendarSystem() == jcal) {
                    l2 = this.getFixedDateJan1(this.cdate, l);
                    if (l >= this.gregorianCutoverDate) {
                        l3 = this.getFixedDateMonth1(this.cdate, l);
                    }
                }
                n12 = (int)(l - l2) + 1;
                n14 = n13 - n12;
                n13 = n12;
                n16 = (int)(l - l3);
            }
            this.internalSet(6, n13);
            this.internalSet(8, n16 / 7 + 1);
            n12 = this.getWeekNumber(l2, l);
            if (n12 == 0) {
                long l4;
                long l5 = l2 - 1L;
                if (n3 > n15 + 1) {
                    l4 = l2 - 365L;
                    if (CalendarUtils.isGregorianLeapYear(n3 - 1)) {
                        --l4;
                    }
                } else {
                    BaseCalendar baseCalendar = this.calsys;
                    int n17 = n3 - 1;
                    if (n17 == n15) {
                        baseCalendar = this.getCutoverCalendarSystem();
                    }
                    l4 = baseCalendar.getFixedDate(n17, 1, 1, null);
                    while (l4 > l5) {
                        l4 = GregorianCalendar.getJulianCalendarSystem().getFixedDate(--n17, 1, 1, null);
                    }
                }
                n12 = this.getWeekNumber(l4, l5);
            } else if (n3 > this.gregorianCutoverYear || n3 < this.gregorianCutoverYearJulian - 1) {
                if (n12 >= 52) {
                    long l6;
                    int n18;
                    long l7 = l2 + 365L;
                    if (this.cdate.isLeapYear()) {
                        ++l7;
                    }
                    if ((n18 = (int)((l6 = BaseCalendar.getDayOfWeekDateOnOrBefore(l7 + 6L, this.getFirstDayOfWeek())) - l7)) >= this.getMinimalDaysInFirstWeek() && l >= l6 - 7L) {
                        n12 = 1;
                    }
                }
            } else {
                long l8;
                int n19;
                long l9;
                BaseCalendar baseCalendar = this.calsys;
                int n20 = n3 + 1;
                if (n20 == this.gregorianCutoverYearJulian + 1 && n20 < this.gregorianCutoverYear) {
                    n20 = this.gregorianCutoverYear;
                }
                if (n20 == this.gregorianCutoverYear) {
                    baseCalendar = this.getCutoverCalendarSystem();
                }
                if ((l9 = baseCalendar.getFixedDate(n20, 1, 1, null)) < l) {
                    l9 = this.gregorianCutoverDate;
                    baseCalendar = gcal;
                }
                if ((n19 = (int)((l8 = BaseCalendar.getDayOfWeekDateOnOrBefore(l9 + 6L, this.getFirstDayOfWeek())) - l9)) >= this.getMinimalDaysInFirstWeek() && l >= l8 - 7L) {
                    n12 = 1;
                }
            }
            this.internalSet(3, n12);
            this.internalSet(4, this.getWeekNumber(l3, l));
            n8 |= 0x158;
        }
        return n8;
    }

    private final int getWeekNumber(long l, long l2) {
        int n;
        long l3 = Gregorian.getDayOfWeekDateOnOrBefore(l + 6L, this.getFirstDayOfWeek());
        int n2 = (int)(l3 - l);
        assert (n2 <= 7);
        if (n2 >= this.getMinimalDaysInFirstWeek()) {
            l3 -= 7L;
        }
        if ((n = (int)(l2 - l3)) >= 0) {
            return n / 7 + 1;
        }
        return CalendarUtils.floorDivide(n, 7) + 1;
    }

    @Override
    protected void computeTime() {
        int n;
        int n2;
        long l;
        long l2;
        long l3;
        int n3;
        block28: {
            long l4;
            block29: {
                int n4;
                block30: {
                    block31: {
                        block26: {
                            block27: {
                                if (!this.isLenient()) {
                                    if (this.originalFields == null) {
                                        this.originalFields = new int[17];
                                    }
                                    for (n3 = 0; n3 < 17; ++n3) {
                                        n4 = this.internalGet(n3);
                                        if (this.isExternallySet(n3) && (n4 < this.getMinimum(n3) || n4 > this.getMaximum(n3))) {
                                            throw new IllegalArgumentException(GregorianCalendar.getFieldName(n3));
                                        }
                                        this.originalFields[n3] = n4;
                                    }
                                }
                                n3 = this.selectFields();
                                n4 = this.isSet(1) ? this.internalGet(1) : 1970;
                                int n5 = this.internalGetEra();
                                if (n5 == 0) {
                                    n4 = 1 - n4;
                                } else if (n5 != 1) {
                                    throw new IllegalArgumentException("Invalid era");
                                }
                                if (n4 <= 0 && !this.isSet(0)) {
                                    n3 |= 1;
                                    this.setFieldsComputed(1);
                                }
                                l3 = 0L;
                                if (GregorianCalendar.isFieldSet(n3, 11)) {
                                    l3 += (long)this.internalGet(11);
                                } else {
                                    l3 += (long)this.internalGet(10);
                                    if (GregorianCalendar.isFieldSet(n3, 9)) {
                                        l3 += (long)(12 * this.internalGet(9));
                                    }
                                }
                                l3 *= 60L;
                                l3 += (long)this.internalGet(12);
                                l3 *= 60L;
                                l3 += (long)this.internalGet(13);
                                l3 *= 1000L;
                                l2 = (l3 += (long)this.internalGet(14)) / 86400000L;
                                l3 %= 86400000L;
                                while (l3 < 0L) {
                                    l3 += 86400000L;
                                    --l2;
                                }
                                if (n4 <= this.gregorianCutoverYear || n4 <= this.gregorianCutoverYearJulian) break block26;
                                l = l2 + this.getFixedDate(gcal, n4, n3);
                                if (l < this.gregorianCutoverDate) break block27;
                                l2 = l;
                                break block28;
                            }
                            l4 = l2 + this.getFixedDate(GregorianCalendar.getJulianCalendarSystem(), n4, n3);
                            break block29;
                        }
                        if (n4 >= this.gregorianCutoverYear || n4 >= this.gregorianCutoverYearJulian) break block30;
                        l4 = l2 + this.getFixedDate(GregorianCalendar.getJulianCalendarSystem(), n4, n3);
                        if (l4 >= this.gregorianCutoverDate) break block31;
                        l2 = l4;
                        break block28;
                    }
                    l = l4;
                    break block29;
                }
                l = l2 + this.getFixedDate(gcal, n4, n3);
                l4 = l2 + this.getFixedDate(GregorianCalendar.getJulianCalendarSystem(), n4, n3);
            }
            if (l >= this.gregorianCutoverDate) {
                l2 = l4 >= this.gregorianCutoverDate ? l : (this.calsys == gcal || this.calsys == null ? l : l4);
            } else if (l4 < this.gregorianCutoverDate) {
                l2 = l4;
            } else {
                if (!this.isLenient()) {
                    throw new IllegalArgumentException("the specified date doesn't exist");
                }
                l2 = l4;
            }
        }
        l = (l2 - 719163L) * 86400000L + l3;
        TimeZone timeZone = this.getZone();
        if (this.zoneOffsets == null) {
            this.zoneOffsets = new int[2];
        }
        if ((n2 = n3 & 0x18000) != 98304) {
            if (timeZone instanceof ZoneInfo) {
                ((ZoneInfo)timeZone).getOffsetsByWall(l, this.zoneOffsets);
            } else {
                n = GregorianCalendar.isFieldSet(n3, 15) ? this.internalGet(15) : timeZone.getRawOffset();
                timeZone.getOffsets(l - (long)n, this.zoneOffsets);
            }
        }
        if (n2 != 0) {
            if (GregorianCalendar.isFieldSet(n2, 15)) {
                this.zoneOffsets[0] = this.internalGet(15);
            }
            if (GregorianCalendar.isFieldSet(n2, 16)) {
                this.zoneOffsets[1] = this.internalGet(16);
            }
        }
        this.time = l -= (long)(this.zoneOffsets[0] + this.zoneOffsets[1]);
        n = this.computeFields(n3 | this.getSetStateFields(), n2);
        if (!this.isLenient()) {
            for (int i = 0; i < 17; ++i) {
                if (!this.isExternallySet(i) || this.originalFields[i] == this.internalGet(i)) continue;
                System.arraycopy(this.originalFields, 0, this.fields, 0, this.fields.length);
                throw new IllegalArgumentException(GregorianCalendar.getFieldName(i));
            }
        }
        this.setFieldsNormalized(n);
    }

    private long getFixedDate(BaseCalendar baseCalendar, int n, int n2) {
        int n3 = 0;
        if (GregorianCalendar.isFieldSet(n2, 2)) {
            n3 = this.internalGet(2);
            if (n3 > 11) {
                n += n3 / 12;
                n3 %= 12;
            } else if (n3 < 0) {
                int[] nArray = new int[1];
                n += CalendarUtils.floorDivide(n3, 12, nArray);
                n3 = nArray[0];
            }
        }
        long l = baseCalendar.getFixedDate(n, n3 + 1, 1, baseCalendar == gcal ? this.gdate : null);
        if (GregorianCalendar.isFieldSet(n2, 2)) {
            if (GregorianCalendar.isFieldSet(n2, 5)) {
                if (this.isSet(5)) {
                    l += (long)this.internalGet(5);
                    --l;
                }
            } else if (GregorianCalendar.isFieldSet(n2, 4)) {
                long l2 = BaseCalendar.getDayOfWeekDateOnOrBefore(l + 6L, this.getFirstDayOfWeek());
                if (l2 - l >= (long)this.getMinimalDaysInFirstWeek()) {
                    l2 -= 7L;
                }
                if (GregorianCalendar.isFieldSet(n2, 7)) {
                    l2 = BaseCalendar.getDayOfWeekDateOnOrBefore(l2 + 6L, this.internalGet(7));
                }
                l = l2 + (long)(7 * (this.internalGet(4) - 1));
            } else {
                int n4 = GregorianCalendar.isFieldSet(n2, 7) ? this.internalGet(7) : this.getFirstDayOfWeek();
                int n5 = GregorianCalendar.isFieldSet(n2, 8) ? this.internalGet(8) : 1;
                if (n5 >= 0) {
                    l = BaseCalendar.getDayOfWeekDateOnOrBefore(l + (long)(7 * n5) - 1L, n4);
                } else {
                    int n6 = this.monthLength(n3, n) + 7 * (n5 + 1);
                    l = BaseCalendar.getDayOfWeekDateOnOrBefore(l + (long)n6 - 1L, n4);
                }
            }
        } else {
            if (n == this.gregorianCutoverYear && baseCalendar == gcal && l < this.gregorianCutoverDate && this.gregorianCutoverYear != this.gregorianCutoverYearJulian) {
                l = this.gregorianCutoverDate;
            }
            if (GregorianCalendar.isFieldSet(n2, 6)) {
                l += (long)this.internalGet(6);
                --l;
            } else {
                int n7;
                long l3 = BaseCalendar.getDayOfWeekDateOnOrBefore(l + 6L, this.getFirstDayOfWeek());
                if (l3 - l >= (long)this.getMinimalDaysInFirstWeek()) {
                    l3 -= 7L;
                }
                if (GregorianCalendar.isFieldSet(n2, 7) && (n7 = this.internalGet(7)) != this.getFirstDayOfWeek()) {
                    l3 = BaseCalendar.getDayOfWeekDateOnOrBefore(l3 + 6L, n7);
                }
                l = l3 + 7L * ((long)this.internalGet(3) - 1L);
            }
        }
        return l;
    }

    private final GregorianCalendar getNormalizedCalendar() {
        GregorianCalendar gregorianCalendar;
        if (this.isFullyNormalized()) {
            gregorianCalendar = this;
        } else {
            gregorianCalendar = (GregorianCalendar)this.clone();
            gregorianCalendar.setLenient(true);
            gregorianCalendar.complete();
        }
        return gregorianCalendar;
    }

    private static final synchronized BaseCalendar getJulianCalendarSystem() {
        if (jcal == null) {
            jcal = (JulianCalendar)CalendarSystem.forName("julian");
            jeras = jcal.getEras();
        }
        return jcal;
    }

    private BaseCalendar getCutoverCalendarSystem() {
        BaseCalendar.Date date = this.getGregorianCutoverDate();
        if (date.getMonth() == 1 && date.getDayOfMonth() == 1) {
            return gcal;
        }
        return GregorianCalendar.getJulianCalendarSystem();
    }

    private final boolean isCutoverYear(int n) {
        int n2 = this.calsys == gcal ? this.gregorianCutoverYear : this.gregorianCutoverYearJulian;
        return n == n2;
    }

    private final long getFixedDateJan1(BaseCalendar.Date date, long l) {
        assert (date.getNormalizedYear() == this.gregorianCutoverYear || date.getNormalizedYear() == this.gregorianCutoverYearJulian);
        if (this.gregorianCutoverYear != this.gregorianCutoverYearJulian && l >= this.gregorianCutoverDate) {
            return this.gregorianCutoverDate;
        }
        BaseCalendar baseCalendar = GregorianCalendar.getJulianCalendarSystem();
        return baseCalendar.getFixedDate(date.getNormalizedYear(), 1, 1, null);
    }

    private final long getFixedDateMonth1(BaseCalendar.Date date, long l) {
        long l2;
        assert (date.getNormalizedYear() == this.gregorianCutoverYear || date.getNormalizedYear() == this.gregorianCutoverYearJulian);
        BaseCalendar.Date date2 = this.getGregorianCutoverDate();
        if (date2.getMonth() == 1 && date2.getDayOfMonth() == 1) {
            return l - (long)date.getDayOfMonth() + 1L;
        }
        if (date.getMonth() == date2.getMonth()) {
            BaseCalendar.Date date3 = this.getLastJulianDate();
            l2 = this.gregorianCutoverYear == this.gregorianCutoverYearJulian && date2.getMonth() == date3.getMonth() ? jcal.getFixedDate(date.getNormalizedYear(), date.getMonth(), 1, null) : this.gregorianCutoverDate;
        } else {
            l2 = l - (long)date.getDayOfMonth() + 1L;
        }
        return l2;
    }

    private final BaseCalendar.Date getCalendarDate(long l) {
        BaseCalendar baseCalendar = l >= this.gregorianCutoverDate ? gcal : GregorianCalendar.getJulianCalendarSystem();
        BaseCalendar.Date date = (BaseCalendar.Date)baseCalendar.newCalendarDate(TimeZone.NO_TIMEZONE);
        baseCalendar.getCalendarDateFromFixedDate(date, l);
        return date;
    }

    private final BaseCalendar.Date getGregorianCutoverDate() {
        return this.getCalendarDate(this.gregorianCutoverDate);
    }

    private final BaseCalendar.Date getLastJulianDate() {
        return this.getCalendarDate(this.gregorianCutoverDate - 1L);
    }

    private final int monthLength(int n, int n2) {
        return this.isLeapYear(n2) ? LEAP_MONTH_LENGTH[n] : MONTH_LENGTH[n];
    }

    private final int monthLength(int n) {
        int n2 = this.internalGet(1);
        if (this.internalGetEra() == 0) {
            n2 = 1 - n2;
        }
        return this.monthLength(n, n2);
    }

    private final int actualMonthLength() {
        long l;
        int n = this.cdate.getNormalizedYear();
        if (n != this.gregorianCutoverYear && n != this.gregorianCutoverYearJulian) {
            return this.calsys.getMonthLength(this.cdate);
        }
        BaseCalendar.Date date = (BaseCalendar.Date)this.cdate.clone();
        long l2 = this.getFixedDateMonth1(date, l = this.calsys.getFixedDate(date));
        long l3 = l2 + (long)this.calsys.getMonthLength(date);
        if (l3 < this.gregorianCutoverDate) {
            return (int)(l3 - l2);
        }
        if (this.cdate != this.gdate) {
            date = gcal.newCalendarDate(TimeZone.NO_TIMEZONE);
        }
        gcal.getCalendarDateFromFixedDate(date, l3);
        l3 = this.getFixedDateMonth1(date, l3);
        return (int)(l3 - l2);
    }

    private final int yearLength(int n) {
        return this.isLeapYear(n) ? 366 : 365;
    }

    private final int yearLength() {
        int n = this.internalGet(1);
        if (this.internalGetEra() == 0) {
            n = 1 - n;
        }
        return this.yearLength(n);
    }

    private final void pinDayOfMonth() {
        int n;
        int n2 = this.internalGet(1);
        if (n2 > this.gregorianCutoverYear || n2 < this.gregorianCutoverYearJulian) {
            n = this.monthLength(this.internalGet(2));
        } else {
            GregorianCalendar gregorianCalendar = this.getNormalizedCalendar();
            n = gregorianCalendar.getActualMaximum(5);
        }
        int n3 = this.internalGet(5);
        if (n3 > n) {
            this.set(5, n);
        }
    }

    private final long getCurrentFixedDate() {
        return this.calsys == gcal ? this.cachedFixedDate : this.calsys.getFixedDate(this.cdate);
    }

    private static final int getRolledValue(int n, int n2, int n3, int n4) {
        assert (n >= n3 && n <= n4);
        int n5 = n4 - n3 + 1;
        int n6 = n + (n2 %= n5);
        if (n6 > n4) {
            n6 -= n5;
        } else if (n6 < n3) {
            n6 += n5;
        }
        assert (n6 >= n3 && n6 <= n4);
        return n6;
    }

    private final int internalGetEra() {
        return this.isSet(0) ? this.internalGet(0) : 1;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        if (this.gdate == null) {
            this.gdate = gcal.newCalendarDate(this.getZone());
            this.cachedFixedDate = Long.MIN_VALUE;
        }
        this.setGregorianChange(this.gregorianCutover);
    }
}

