/*
 * Decompiled with CFR 0.152.
 */
package java.util.zip;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.Deflater;

public class DeflaterOutputStream
extends FilterOutputStream {
    protected Deflater def;
    protected byte[] buf;
    private boolean closed = false;
    boolean usesDefaultDeflater = false;

    public DeflaterOutputStream(OutputStream outputStream, Deflater deflater, int n) {
        super(outputStream);
        if (outputStream == null || deflater == null) {
            throw new NullPointerException();
        }
        if (n <= 0) {
            throw new IllegalArgumentException("buffer size <= 0");
        }
        this.def = deflater;
        this.buf = new byte[n];
    }

    public DeflaterOutputStream(OutputStream outputStream, Deflater deflater) {
        this(outputStream, deflater, 512);
    }

    public DeflaterOutputStream(OutputStream outputStream) {
        this(outputStream, new Deflater());
        this.usesDefaultDeflater = true;
    }

    @Override
    public void write(int n) throws IOException {
        byte[] byArray = new byte[]{(byte)(n & 0xFF)};
        this.write(byArray, 0, 1);
    }

    @Override
    public void write(byte[] byArray, int n, int n2) throws IOException {
        if (this.def.finished()) {
            throw new IOException("write beyond end of stream");
        }
        if ((n | n2 | n + n2 | byArray.length - (n + n2)) < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (n2 == 0) {
            return;
        }
        if (!this.def.finished()) {
            int n3 = this.buf.length;
            for (int i = 0; i < n2; i += n3) {
                this.def.setInput(byArray, n + i, Math.min(n3, n2 - i));
                while (!this.def.needsInput()) {
                    this.deflate();
                }
            }
        }
    }

    public void finish() throws IOException {
        if (!this.def.finished()) {
            this.def.finish();
            while (!this.def.finished()) {
                this.deflate();
            }
        }
    }

    @Override
    public void close() throws IOException {
        if (!this.closed) {
            this.finish();
            if (this.usesDefaultDeflater) {
                this.def.end();
            }
            this.out.close();
            this.closed = true;
        }
    }

    protected void deflate() throws IOException {
        int n = this.def.deflate(this.buf, 0, this.buf.length);
        if (n > 0) {
            this.out.write(this.buf, 0, n);
        }
    }
}

