/*
 * Decompiled with CFR 0.152.
 */
package javax.management;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.management.Attribute;
import javax.management.RuntimeOperationsException;

public class AttributeList
extends ArrayList<Object> {
    private volatile transient boolean typeSafe;
    private volatile transient boolean tainted;
    private static final long serialVersionUID = -4077085769279709076L;

    public AttributeList() {
    }

    public AttributeList(int n) {
        super(n);
    }

    public AttributeList(AttributeList attributeList) {
        super(attributeList);
    }

    public AttributeList(List<Attribute> list) {
        if (list == null) {
            throw new IllegalArgumentException("Null parameter");
        }
        this.adding(list);
        super.addAll(list);
    }

    public AttributeList(Map<String, ?> map) {
        for (Map.Entry<String, ?> entry : map.entrySet()) {
            this.add(new Attribute(entry.getKey(), entry.getValue()));
        }
        this.typeSafe = true;
    }

    public Map<String, Object> toMap() {
        LinkedHashMap<String, Object> linkedHashMap = new LinkedHashMap<String, Object>();
        if (this.tainted) {
            throw new IllegalArgumentException("AttributeList contains non-Attribute");
        }
        for (Object e : this) {
            Attribute attribute = (Attribute)e;
            linkedHashMap.put(attribute.getName(), attribute.getValue());
        }
        return linkedHashMap;
    }

    public List<Attribute> asList() {
        this.typeSafe = true;
        if (this.tainted) {
            this.adding(this);
        }
        return this;
    }

    public void add(Attribute attribute) {
        super.add(attribute);
    }

    @Override
    public void add(int n, Attribute attribute) {
        try {
            super.add(n, attribute);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new RuntimeOperationsException(indexOutOfBoundsException, "The specified index is out of range");
        }
    }

    @Override
    public void set(int n, Attribute attribute) {
        try {
            super.set(n, attribute);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new RuntimeOperationsException(indexOutOfBoundsException, "The specified index is out of range");
        }
    }

    public boolean addAll(AttributeList attributeList) {
        return super.addAll(attributeList);
    }

    public boolean addAll(int n, AttributeList attributeList) {
        try {
            return super.addAll(n, attributeList);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new RuntimeOperationsException(indexOutOfBoundsException, "The specified index is out of range");
        }
    }

    @Override
    public boolean add(Object object) {
        this.adding(object);
        return super.add(object);
    }

    @Override
    public void add(int n, Object object) {
        this.adding(object);
        super.add(n, object);
    }

    @Override
    public boolean addAll(Collection<?> collection) {
        this.adding(collection);
        return super.addAll(collection);
    }

    @Override
    public boolean addAll(int n, Collection<?> collection) {
        this.adding(collection);
        return super.addAll(n, collection);
    }

    @Override
    public Object set(int n, Object object) {
        this.adding(object);
        return super.set(n, object);
    }

    private void adding(Object object) {
        if (object == null || object instanceof Attribute) {
            return;
        }
        if (this.typeSafe) {
            throw new IllegalArgumentException("Not an Attribute: " + object);
        }
        this.tainted = true;
    }

    private void adding(Collection<?> collection) {
        for (Object obj : collection) {
            this.adding(obj);
        }
    }
}

