/*
 * Decompiled with CFR 0.152.
 */
package javax.management.modelmbean;

import com.sun.jmx.defaults.JmxProperties;
import com.sun.jmx.mbeanserver.GetPropertyAction;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamField;
import java.security.AccessController;
import java.util.logging.Level;
import javax.management.Descriptor;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanConstructorInfo;
import javax.management.MBeanException;
import javax.management.MBeanFeatureInfo;
import javax.management.MBeanInfo;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanOperationInfo;
import javax.management.RuntimeOperationsException;
import javax.management.modelmbean.DescriptorSupport;
import javax.management.modelmbean.ModelMBeanAttributeInfo;
import javax.management.modelmbean.ModelMBeanConstructorInfo;
import javax.management.modelmbean.ModelMBeanInfo;
import javax.management.modelmbean.ModelMBeanNotificationInfo;
import javax.management.modelmbean.ModelMBeanOperationInfo;

public class ModelMBeanInfoSupport
extends MBeanInfo
implements ModelMBeanInfo {
    private static final long oldSerialVersionUID = -3944083498453227709L;
    private static final long newSerialVersionUID = -1935722590756516193L;
    private static final ObjectStreamField[] oldSerialPersistentFields = new ObjectStreamField[]{new ObjectStreamField("modelMBeanDescriptor", Descriptor.class), new ObjectStreamField("mmbAttributes", MBeanAttributeInfo[].class), new ObjectStreamField("mmbConstructors", MBeanConstructorInfo[].class), new ObjectStreamField("mmbNotifications", MBeanNotificationInfo[].class), new ObjectStreamField("mmbOperations", MBeanOperationInfo[].class), new ObjectStreamField("currClass", String.class)};
    private static final ObjectStreamField[] newSerialPersistentFields = new ObjectStreamField[]{new ObjectStreamField("modelMBeanDescriptor", Descriptor.class), new ObjectStreamField("modelMBeanAttributes", MBeanAttributeInfo[].class), new ObjectStreamField("modelMBeanConstructors", MBeanConstructorInfo[].class), new ObjectStreamField("modelMBeanNotifications", MBeanNotificationInfo[].class), new ObjectStreamField("modelMBeanOperations", MBeanOperationInfo[].class)};
    private static final long serialVersionUID;
    private static final ObjectStreamField[] serialPersistentFields;
    private static boolean compat;
    private Descriptor modelMBeanDescriptor;
    private MBeanAttributeInfo[] modelMBeanAttributes;
    private MBeanConstructorInfo[] modelMBeanConstructors;
    private MBeanNotificationInfo[] modelMBeanNotifications;
    private MBeanOperationInfo[] modelMBeanOperations;
    private static final String ATTR = "attribute";
    private static final String OPER = "operation";
    private static final String NOTF = "notification";
    private static final String CONS = "constructor";
    private static final String MMB = "mbean";
    private static final String ALL = "all";
    private static final String currClass = "ModelMBeanInfoSupport";
    private static final ModelMBeanAttributeInfo[] NO_ATTRIBUTES;
    private static final ModelMBeanConstructorInfo[] NO_CONSTRUCTORS;
    private static final ModelMBeanNotificationInfo[] NO_NOTIFICATIONS;
    private static final ModelMBeanOperationInfo[] NO_OPERATIONS;

    public ModelMBeanInfoSupport(ModelMBeanInfo modelMBeanInfo) {
        block3: {
            super(modelMBeanInfo.getClassName(), modelMBeanInfo.getDescription(), modelMBeanInfo.getAttributes(), modelMBeanInfo.getConstructors(), modelMBeanInfo.getOperations(), modelMBeanInfo.getNotifications());
            this.modelMBeanDescriptor = null;
            this.modelMBeanAttributes = modelMBeanInfo.getAttributes();
            this.modelMBeanConstructors = modelMBeanInfo.getConstructors();
            this.modelMBeanOperations = modelMBeanInfo.getOperations();
            this.modelMBeanNotifications = modelMBeanInfo.getNotifications();
            try {
                Descriptor descriptor = modelMBeanInfo.getMBeanDescriptor();
                this.modelMBeanDescriptor = this.validDescriptor(descriptor);
            }
            catch (MBeanException mBeanException) {
                this.modelMBeanDescriptor = this.validDescriptor(null);
                if (!JmxProperties.MODELMBEAN_LOGGER.isLoggable(Level.FINER)) break block3;
                JmxProperties.MODELMBEAN_LOGGER.logp(Level.FINER, ModelMBeanInfoSupport.class.getName(), "ModelMBeanInfo(ModelMBeanInfo)", "Could not get a valid modelMBeanDescriptor, setting a default Descriptor");
            }
        }
        if (JmxProperties.MODELMBEAN_LOGGER.isLoggable(Level.FINER)) {
            JmxProperties.MODELMBEAN_LOGGER.logp(Level.FINER, ModelMBeanInfoSupport.class.getName(), "ModelMBeanInfo(ModelMBeanInfo)", "Exit");
        }
    }

    public ModelMBeanInfoSupport(String string, String string2, ModelMBeanAttributeInfo[] modelMBeanAttributeInfoArray, ModelMBeanConstructorInfo[] modelMBeanConstructorInfoArray, ModelMBeanOperationInfo[] modelMBeanOperationInfoArray, ModelMBeanNotificationInfo[] modelMBeanNotificationInfoArray) {
        this(string, string2, modelMBeanAttributeInfoArray, modelMBeanConstructorInfoArray, modelMBeanOperationInfoArray, modelMBeanNotificationInfoArray, (Descriptor)null);
    }

    public ModelMBeanInfoSupport(String string, String string2, ModelMBeanAttributeInfo[] modelMBeanAttributeInfoArray, ModelMBeanConstructorInfo[] modelMBeanConstructorInfoArray, ModelMBeanOperationInfo[] modelMBeanOperationInfoArray, ModelMBeanNotificationInfo[] modelMBeanNotificationInfoArray, Descriptor descriptor) {
        super(string, string2, modelMBeanAttributeInfoArray != null ? modelMBeanAttributeInfoArray : NO_ATTRIBUTES, modelMBeanConstructorInfoArray != null ? modelMBeanConstructorInfoArray : NO_CONSTRUCTORS, modelMBeanOperationInfoArray != null ? modelMBeanOperationInfoArray : NO_OPERATIONS, modelMBeanNotificationInfoArray != null ? modelMBeanNotificationInfoArray : NO_NOTIFICATIONS);
        this.modelMBeanDescriptor = null;
        this.modelMBeanAttributes = modelMBeanAttributeInfoArray;
        this.modelMBeanConstructors = modelMBeanConstructorInfoArray;
        this.modelMBeanOperations = modelMBeanOperationInfoArray;
        this.modelMBeanNotifications = modelMBeanNotificationInfoArray;
        this.modelMBeanDescriptor = this.validDescriptor(descriptor);
        if (JmxProperties.MODELMBEAN_LOGGER.isLoggable(Level.FINER)) {
            JmxProperties.MODELMBEAN_LOGGER.logp(Level.FINER, ModelMBeanInfoSupport.class.getName(), "ModelMBeanInfoSupport(String,String,ModelMBeanAttributeInfo[],ModelMBeanConstructorInfo[],ModelMBeanOperationInfo[],ModelMBeanNotificationInfo[],Descriptor)", "Exit");
        }
    }

    @Override
    public Object clone() {
        return new ModelMBeanInfoSupport(this);
    }

    @Override
    public Descriptor[] getDescriptors(String string) throws MBeanException, RuntimeOperationsException {
        Descriptor[] descriptorArray;
        if (JmxProperties.MODELMBEAN_LOGGER.isLoggable(Level.FINER)) {
            JmxProperties.MODELMBEAN_LOGGER.logp(Level.FINER, ModelMBeanInfoSupport.class.getName(), "getDescriptors(String)", "Entry");
        }
        if (string == null || string.equals("")) {
            string = ALL;
        }
        if (string.equalsIgnoreCase(MMB)) {
            descriptorArray = new Descriptor[]{this.modelMBeanDescriptor};
        } else if (string.equalsIgnoreCase(ATTR)) {
            MBeanAttributeInfo[] mBeanAttributeInfoArray = this.modelMBeanAttributes;
            int n = 0;
            if (mBeanAttributeInfoArray != null) {
                n = mBeanAttributeInfoArray.length;
            }
            descriptorArray = new Descriptor[n];
            for (int i = 0; i < n; ++i) {
                descriptorArray[i] = ((ModelMBeanAttributeInfo)mBeanAttributeInfoArray[i]).getDescriptor();
            }
        } else if (string.equalsIgnoreCase(OPER)) {
            MBeanOperationInfo[] mBeanOperationInfoArray = this.modelMBeanOperations;
            int n = 0;
            if (mBeanOperationInfoArray != null) {
                n = mBeanOperationInfoArray.length;
            }
            descriptorArray = new Descriptor[n];
            for (int i = 0; i < n; ++i) {
                descriptorArray[i] = ((ModelMBeanOperationInfo)mBeanOperationInfoArray[i]).getDescriptor();
            }
        } else if (string.equalsIgnoreCase(CONS)) {
            MBeanConstructorInfo[] mBeanConstructorInfoArray = this.modelMBeanConstructors;
            int n = 0;
            if (mBeanConstructorInfoArray != null) {
                n = mBeanConstructorInfoArray.length;
            }
            descriptorArray = new Descriptor[n];
            for (int i = 0; i < n; ++i) {
                descriptorArray[i] = ((ModelMBeanConstructorInfo)mBeanConstructorInfoArray[i]).getDescriptor();
            }
        } else if (string.equalsIgnoreCase(NOTF)) {
            MBeanNotificationInfo[] mBeanNotificationInfoArray = this.modelMBeanNotifications;
            int n = 0;
            if (mBeanNotificationInfoArray != null) {
                n = mBeanNotificationInfoArray.length;
            }
            descriptorArray = new Descriptor[n];
            for (int i = 0; i < n; ++i) {
                descriptorArray[i] = ((ModelMBeanNotificationInfo)mBeanNotificationInfoArray[i]).getDescriptor();
            }
        } else if (string.equalsIgnoreCase(ALL)) {
            int n;
            MBeanAttributeInfo[] mBeanAttributeInfoArray = this.modelMBeanAttributes;
            int n2 = 0;
            if (mBeanAttributeInfoArray != null) {
                n2 = mBeanAttributeInfoArray.length;
            }
            MBeanOperationInfo[] mBeanOperationInfoArray = this.modelMBeanOperations;
            int n3 = 0;
            if (mBeanOperationInfoArray != null) {
                n3 = mBeanOperationInfoArray.length;
            }
            MBeanConstructorInfo[] mBeanConstructorInfoArray = this.modelMBeanConstructors;
            int n4 = 0;
            if (mBeanConstructorInfoArray != null) {
                n4 = mBeanConstructorInfoArray.length;
            }
            MBeanNotificationInfo[] mBeanNotificationInfoArray = this.modelMBeanNotifications;
            int n5 = 0;
            if (mBeanNotificationInfoArray != null) {
                n5 = mBeanNotificationInfoArray.length;
            }
            int n6 = n2 + n4 + n3 + n5 + 1;
            descriptorArray = new Descriptor[n6];
            descriptorArray[n6 - 1] = this.modelMBeanDescriptor;
            int n7 = 0;
            for (n = 0; n < n2; ++n) {
                descriptorArray[n7] = ((ModelMBeanAttributeInfo)mBeanAttributeInfoArray[n]).getDescriptor();
                ++n7;
            }
            for (n = 0; n < n4; ++n) {
                descriptorArray[n7] = ((ModelMBeanConstructorInfo)mBeanConstructorInfoArray[n]).getDescriptor();
                ++n7;
            }
            for (n = 0; n < n3; ++n) {
                descriptorArray[n7] = ((ModelMBeanOperationInfo)mBeanOperationInfoArray[n]).getDescriptor();
                ++n7;
            }
            for (n = 0; n < n5; ++n) {
                descriptorArray[n7] = ((ModelMBeanNotificationInfo)mBeanNotificationInfoArray[n]).getDescriptor();
                ++n7;
            }
        } else {
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException("Descriptor Type is invalid");
            throw new RuntimeOperationsException(illegalArgumentException, "Exception occurred trying to find the descriptors of the MBean");
        }
        if (JmxProperties.MODELMBEAN_LOGGER.isLoggable(Level.FINER)) {
            JmxProperties.MODELMBEAN_LOGGER.logp(Level.FINER, ModelMBeanInfoSupport.class.getName(), "getDescriptors(String)", "Exit");
        }
        return descriptorArray;
    }

    @Override
    public void setDescriptors(Descriptor[] descriptorArray) throws MBeanException, RuntimeOperationsException {
        if (JmxProperties.MODELMBEAN_LOGGER.isLoggable(Level.FINER)) {
            JmxProperties.MODELMBEAN_LOGGER.logp(Level.FINER, ModelMBeanInfoSupport.class.getName(), "setDescriptors(Descriptor[])", "Entry");
        }
        if (descriptorArray == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException("Descriptor list is invalid"), "Exception occurred trying to set the descriptors of the MBeanInfo");
        }
        if (descriptorArray.length == 0) {
            return;
        }
        for (int i = 0; i < descriptorArray.length; ++i) {
            this.setDescriptor(descriptorArray[i], null);
        }
        if (JmxProperties.MODELMBEAN_LOGGER.isLoggable(Level.FINER)) {
            JmxProperties.MODELMBEAN_LOGGER.logp(Level.FINER, ModelMBeanInfoSupport.class.getName(), "setDescriptors(Descriptor[])", "Exit");
        }
    }

    public Descriptor getDescriptor(String string) throws MBeanException, RuntimeOperationsException {
        if (JmxProperties.MODELMBEAN_LOGGER.isLoggable(Level.FINER)) {
            JmxProperties.MODELMBEAN_LOGGER.logp(Level.FINER, ModelMBeanInfoSupport.class.getName(), "getDescriptor(String)", "Entry");
        }
        return this.getDescriptor(string, null);
    }

    @Override
    public Descriptor getDescriptor(String string, String string2) throws MBeanException, RuntimeOperationsException {
        MBeanFeatureInfo mBeanFeatureInfo;
        if (string == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException("Descriptor is invalid"), "Exception occurred trying to set the descriptors of the MBeanInfo");
        }
        if (MMB.equalsIgnoreCase(string2)) {
            return (Descriptor)this.modelMBeanDescriptor.clone();
        }
        if (ATTR.equalsIgnoreCase(string2) || string2 == null) {
            mBeanFeatureInfo = this.getAttribute(string);
            if (mBeanFeatureInfo != null) {
                return ((ModelMBeanAttributeInfo)mBeanFeatureInfo).getDescriptor();
            }
            if (string2 != null) {
                return null;
            }
        }
        if (OPER.equalsIgnoreCase(string2) || string2 == null) {
            mBeanFeatureInfo = this.getOperation(string);
            if (mBeanFeatureInfo != null) {
                return ((ModelMBeanOperationInfo)mBeanFeatureInfo).getDescriptor();
            }
            if (string2 != null) {
                return null;
            }
        }
        if (CONS.equalsIgnoreCase(string2) || string2 == null) {
            mBeanFeatureInfo = this.getConstructor(string);
            if (mBeanFeatureInfo != null) {
                return ((ModelMBeanConstructorInfo)mBeanFeatureInfo).getDescriptor();
            }
            if (string2 != null) {
                return null;
            }
        }
        if (NOTF.equalsIgnoreCase(string2) || string2 == null) {
            mBeanFeatureInfo = this.getNotification(string);
            if (mBeanFeatureInfo != null) {
                return ((ModelMBeanNotificationInfo)mBeanFeatureInfo).getDescriptor();
            }
            if (string2 != null) {
                return null;
            }
        }
        if (string2 == null) {
            return null;
        }
        throw new RuntimeOperationsException(new IllegalArgumentException("Descriptor Type is invalid"), "Exception occurred trying to find the descriptors of the MBean");
    }

    @Override
    public void setDescriptor(Descriptor descriptor, String string) throws MBeanException, RuntimeOperationsException {
        Object object;
        String string2;
        if (JmxProperties.MODELMBEAN_LOGGER.isLoggable(Level.FINER)) {
            JmxProperties.MODELMBEAN_LOGGER.logp(Level.FINER, ModelMBeanInfoSupport.class.getName(), "setDescriptor(Descriptor,String)", "Entry");
        }
        if (descriptor == null) {
            descriptor = new DescriptorSupport();
        }
        if ((string == null || string.equals("")) && (string = (String)descriptor.getFieldValue("descriptorType")) == null) {
            JmxProperties.MODELMBEAN_LOGGER.logp(Level.FINER, ModelMBeanInfoSupport.class.getName(), "setDescriptor(Descriptor,String)", "descriptorType null in both String parameter and Descriptor, defaulting to mbean");
            string = MMB;
        }
        if ((string2 = (String)descriptor.getFieldValue("name")) == null) {
            JmxProperties.MODELMBEAN_LOGGER.logp(Level.FINER, ModelMBeanInfoSupport.class.getName(), "setDescriptor(Descriptor,String)", "descriptor name null, defaulting to " + this.getClassName());
            string2 = this.getClassName();
        }
        boolean bl = false;
        if (string.equalsIgnoreCase(MMB)) {
            this.setMBeanDescriptor(descriptor);
            bl = true;
        } else if (string.equalsIgnoreCase(ATTR)) {
            object = this.modelMBeanAttributes;
            int n = 0;
            if (object != null) {
                n = ((MBeanFeatureInfo[])object).length;
            }
            for (int i = 0; i < n; ++i) {
                if (!string2.equals(object[i].getName())) continue;
                bl = true;
                ModelMBeanAttributeInfo modelMBeanAttributeInfo = (ModelMBeanAttributeInfo)object[i];
                modelMBeanAttributeInfo.setDescriptor(descriptor);
                if (!JmxProperties.MODELMBEAN_LOGGER.isLoggable(Level.FINER)) continue;
                StringBuilder stringBuilder = new StringBuilder().append("Setting descriptor to ").append(descriptor).append("\t\n local: AttributeInfo descriptor is ").append(modelMBeanAttributeInfo.getDescriptor()).append("\t\n modelMBeanInfo: AttributeInfo descriptor is ").append(this.getDescriptor(string2, ATTR));
                JmxProperties.MODELMBEAN_LOGGER.logp(Level.FINER, ModelMBeanInfoSupport.class.getName(), "setDescriptor(Descriptor,String)", stringBuilder.toString());
            }
        } else if (string.equalsIgnoreCase(OPER)) {
            object = this.modelMBeanOperations;
            int n = 0;
            if (object != null) {
                n = ((MBeanFeatureInfo[])object).length;
            }
            for (int i = 0; i < n; ++i) {
                if (!string2.equals(object[i].getName())) continue;
                bl = true;
                ModelMBeanOperationInfo modelMBeanOperationInfo = (ModelMBeanOperationInfo)object[i];
                modelMBeanOperationInfo.setDescriptor(descriptor);
            }
        } else if (string.equalsIgnoreCase(CONS)) {
            object = this.modelMBeanConstructors;
            int n = 0;
            if (object != null) {
                n = ((MBeanFeatureInfo[])object).length;
            }
            for (int i = 0; i < n; ++i) {
                if (!string2.equals(object[i].getName())) continue;
                bl = true;
                ModelMBeanConstructorInfo modelMBeanConstructorInfo = (ModelMBeanConstructorInfo)object[i];
                modelMBeanConstructorInfo.setDescriptor(descriptor);
            }
        } else if (string.equalsIgnoreCase(NOTF)) {
            object = this.modelMBeanNotifications;
            int n = 0;
            if (object != null) {
                n = ((MBeanFeatureInfo[])object).length;
            }
            for (int i = 0; i < n; ++i) {
                if (!string2.equals(object[i].getName())) continue;
                bl = true;
                ModelMBeanNotificationInfo modelMBeanNotificationInfo = (ModelMBeanNotificationInfo)object[i];
                modelMBeanNotificationInfo.setDescriptor(descriptor);
            }
        } else {
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException("Invalid descriptor type: " + string);
            throw new RuntimeOperationsException(illegalArgumentException, "Exception occurred trying to set the descriptors of the MBean");
        }
        if (!bl) {
            object = new IllegalArgumentException("Descriptor name is invalid: type=" + string + "; name=" + string2);
            throw new RuntimeOperationsException((RuntimeException)object, "Exception occurred trying to set the descriptors of the MBean");
        }
        if (JmxProperties.MODELMBEAN_LOGGER.isLoggable(Level.FINER)) {
            JmxProperties.MODELMBEAN_LOGGER.logp(Level.FINER, ModelMBeanInfoSupport.class.getName(), "setDescriptor(Descriptor,String)", "Exit");
        }
    }

    @Override
    public ModelMBeanAttributeInfo getAttribute(String string) throws MBeanException, RuntimeOperationsException {
        ModelMBeanAttributeInfo modelMBeanAttributeInfo = null;
        if (JmxProperties.MODELMBEAN_LOGGER.isLoggable(Level.FINER)) {
            JmxProperties.MODELMBEAN_LOGGER.logp(Level.FINER, ModelMBeanInfoSupport.class.getName(), "getAttribute(String)", "Entry");
        }
        if (string == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException("Attribute Name is null"), "Exception occurred trying to get the ModelMBeanAttributeInfo of the MBean");
        }
        MBeanAttributeInfo[] mBeanAttributeInfoArray = this.modelMBeanAttributes;
        int n = 0;
        if (mBeanAttributeInfoArray != null) {
            n = mBeanAttributeInfoArray.length;
        }
        for (int i = 0; i < n && modelMBeanAttributeInfo == null; ++i) {
            if (JmxProperties.MODELMBEAN_LOGGER.isLoggable(Level.FINER)) {
                StringBuilder stringBuilder = new StringBuilder().append("\t\n this.getAttributes() MBeanAttributeInfo Array ").append(i).append(":").append(((ModelMBeanAttributeInfo)mBeanAttributeInfoArray[i]).getDescriptor()).append("\t\n this.modelMBeanAttributes MBeanAttributeInfo Array ").append(i).append(":").append(((ModelMBeanAttributeInfo)this.modelMBeanAttributes[i]).getDescriptor());
                JmxProperties.MODELMBEAN_LOGGER.logp(Level.FINER, ModelMBeanInfoSupport.class.getName(), "getAttribute(String)", stringBuilder.toString());
            }
            if (!string.equals(mBeanAttributeInfoArray[i].getName())) continue;
            modelMBeanAttributeInfo = (ModelMBeanAttributeInfo)mBeanAttributeInfoArray[i].clone();
        }
        if (JmxProperties.MODELMBEAN_LOGGER.isLoggable(Level.FINER)) {
            JmxProperties.MODELMBEAN_LOGGER.logp(Level.FINER, ModelMBeanInfoSupport.class.getName(), "getAttribute(String)", "Exit");
        }
        return modelMBeanAttributeInfo;
    }

    @Override
    public ModelMBeanOperationInfo getOperation(String string) throws MBeanException, RuntimeOperationsException {
        ModelMBeanOperationInfo modelMBeanOperationInfo = null;
        if (JmxProperties.MODELMBEAN_LOGGER.isLoggable(Level.FINER)) {
            JmxProperties.MODELMBEAN_LOGGER.logp(Level.FINER, ModelMBeanInfoSupport.class.getName(), "getOperation(String)", "Entry");
        }
        if (string == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException("inName is null"), "Exception occurred trying to get the ModelMBeanOperationInfo of the MBean");
        }
        MBeanOperationInfo[] mBeanOperationInfoArray = this.modelMBeanOperations;
        int n = 0;
        if (mBeanOperationInfoArray != null) {
            n = mBeanOperationInfoArray.length;
        }
        for (int i = 0; i < n && modelMBeanOperationInfo == null; ++i) {
            if (!string.equals(mBeanOperationInfoArray[i].getName())) continue;
            modelMBeanOperationInfo = (ModelMBeanOperationInfo)mBeanOperationInfoArray[i].clone();
        }
        if (JmxProperties.MODELMBEAN_LOGGER.isLoggable(Level.FINER)) {
            JmxProperties.MODELMBEAN_LOGGER.logp(Level.FINER, ModelMBeanInfoSupport.class.getName(), "getOperation(String)", "Exit");
        }
        return modelMBeanOperationInfo;
    }

    public ModelMBeanConstructorInfo getConstructor(String string) throws MBeanException, RuntimeOperationsException {
        ModelMBeanConstructorInfo modelMBeanConstructorInfo = null;
        if (JmxProperties.MODELMBEAN_LOGGER.isLoggable(Level.FINER)) {
            JmxProperties.MODELMBEAN_LOGGER.logp(Level.FINER, ModelMBeanInfoSupport.class.getName(), "getConstructor(String)", "Entry");
        }
        if (string == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException("Constructor name is null"), "Exception occurred trying to get the ModelMBeanConstructorInfo of the MBean");
        }
        MBeanConstructorInfo[] mBeanConstructorInfoArray = this.modelMBeanConstructors;
        int n = 0;
        if (mBeanConstructorInfoArray != null) {
            n = mBeanConstructorInfoArray.length;
        }
        for (int i = 0; i < n && modelMBeanConstructorInfo == null; ++i) {
            if (!string.equals(mBeanConstructorInfoArray[i].getName())) continue;
            modelMBeanConstructorInfo = (ModelMBeanConstructorInfo)mBeanConstructorInfoArray[i].clone();
        }
        if (JmxProperties.MODELMBEAN_LOGGER.isLoggable(Level.FINER)) {
            JmxProperties.MODELMBEAN_LOGGER.logp(Level.FINER, ModelMBeanInfoSupport.class.getName(), "getConstructor(String)", "Exit");
        }
        return modelMBeanConstructorInfo;
    }

    @Override
    public ModelMBeanNotificationInfo getNotification(String string) throws MBeanException, RuntimeOperationsException {
        ModelMBeanNotificationInfo modelMBeanNotificationInfo = null;
        if (JmxProperties.MODELMBEAN_LOGGER.isLoggable(Level.FINER)) {
            JmxProperties.MODELMBEAN_LOGGER.logp(Level.FINER, ModelMBeanInfoSupport.class.getName(), "getNotification(String)", "Entry");
        }
        if (string == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException("Notification name is null"), "Exception occurred trying to get the ModelMBeanNotificationInfo of the MBean");
        }
        MBeanNotificationInfo[] mBeanNotificationInfoArray = this.modelMBeanNotifications;
        int n = 0;
        if (mBeanNotificationInfoArray != null) {
            n = mBeanNotificationInfoArray.length;
        }
        for (int i = 0; i < n && modelMBeanNotificationInfo == null; ++i) {
            if (!string.equals(mBeanNotificationInfoArray[i].getName())) continue;
            modelMBeanNotificationInfo = (ModelMBeanNotificationInfo)mBeanNotificationInfoArray[i].clone();
        }
        if (JmxProperties.MODELMBEAN_LOGGER.isLoggable(Level.FINER)) {
            JmxProperties.MODELMBEAN_LOGGER.logp(Level.FINER, ModelMBeanInfoSupport.class.getName(), "getNotification(String)", "Exit");
        }
        return modelMBeanNotificationInfo;
    }

    @Override
    public Descriptor getDescriptor() {
        return this.getMBeanDescriptorNoException();
    }

    @Override
    public Descriptor getMBeanDescriptor() throws MBeanException {
        return this.getMBeanDescriptorNoException();
    }

    private Descriptor getMBeanDescriptorNoException() {
        if (JmxProperties.MODELMBEAN_LOGGER.isLoggable(Level.FINER)) {
            JmxProperties.MODELMBEAN_LOGGER.logp(Level.FINER, ModelMBeanInfoSupport.class.getName(), "getMBeanDescriptorNoException()", "Entry");
        }
        if (this.modelMBeanDescriptor == null) {
            this.modelMBeanDescriptor = this.validDescriptor(null);
        }
        if (JmxProperties.MODELMBEAN_LOGGER.isLoggable(Level.FINER)) {
            JmxProperties.MODELMBEAN_LOGGER.logp(Level.FINER, ModelMBeanInfoSupport.class.getName(), "getMBeanDescriptorNoException()", "Exit, returning: " + this.modelMBeanDescriptor);
        }
        return (Descriptor)this.modelMBeanDescriptor.clone();
    }

    @Override
    public void setMBeanDescriptor(Descriptor descriptor) throws MBeanException, RuntimeOperationsException {
        if (JmxProperties.MODELMBEAN_LOGGER.isLoggable(Level.FINER)) {
            JmxProperties.MODELMBEAN_LOGGER.logp(Level.FINER, ModelMBeanInfoSupport.class.getName(), "setMBeanDescriptor(Descriptor)", "Entry");
        }
        this.modelMBeanDescriptor = this.validDescriptor(descriptor);
    }

    private Descriptor validDescriptor(Descriptor descriptor) throws RuntimeOperationsException {
        Descriptor descriptor2;
        if (descriptor == null) {
            descriptor2 = new DescriptorSupport();
            JmxProperties.MODELMBEAN_LOGGER.finer("Null Descriptor, creating new.");
        } else {
            descriptor2 = (Descriptor)descriptor.clone();
        }
        if (descriptor2.getFieldValue("name") == null) {
            descriptor2.setField("name", this.getClassName());
            JmxProperties.MODELMBEAN_LOGGER.finer("Defaulting Descriptor name to " + this.getClassName());
        }
        if (descriptor2.getFieldValue("descriptorType") == null) {
            descriptor2.setField("descriptorType", MMB);
            JmxProperties.MODELMBEAN_LOGGER.finer("Defaulting descriptorType to \"mbean\"");
        }
        if (descriptor2.getFieldValue("displayName") == null) {
            descriptor2.setField("displayName", this.getClassName());
            JmxProperties.MODELMBEAN_LOGGER.finer("Defaulting Descriptor displayName to " + this.getClassName());
        }
        if (descriptor2.getFieldValue("persistPolicy") == null) {
            descriptor2.setField("persistPolicy", "never");
            JmxProperties.MODELMBEAN_LOGGER.finer("Defaulting Descriptor persistPolicy to \"never\"");
        }
        if (descriptor2.getFieldValue("log") == null) {
            descriptor2.setField("log", "F");
            JmxProperties.MODELMBEAN_LOGGER.finer("Defaulting Descriptor \"log\" field to \"F\"");
        }
        if (descriptor2.getFieldValue("visibility") == null) {
            descriptor2.setField("visibility", "1");
            JmxProperties.MODELMBEAN_LOGGER.finer("Defaulting Descriptor visibility to 1");
        }
        if (!descriptor2.isValid()) {
            throw new RuntimeOperationsException(new IllegalArgumentException("Invalid Descriptor argument"), "The isValid() method of the Descriptor object itself returned false,one or more required fields are invalid. Descriptor:" + descriptor2.toString());
        }
        if (!((String)descriptor2.getFieldValue("descriptorType")).equalsIgnoreCase(MMB)) {
            throw new RuntimeOperationsException(new IllegalArgumentException("Invalid Descriptor argument"), "The Descriptor \"descriptorType\" field does not match the object described.  Expected: mbean , was: " + descriptor2.getFieldValue("descriptorType"));
        }
        return descriptor2;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        if (compat) {
            ObjectInputStream.GetField getField = objectInputStream.readFields();
            this.modelMBeanDescriptor = (Descriptor)getField.get("modelMBeanDescriptor", null);
            if (getField.defaulted("modelMBeanDescriptor")) {
                throw new NullPointerException("modelMBeanDescriptor");
            }
            this.modelMBeanAttributes = (MBeanAttributeInfo[])getField.get("mmbAttributes", null);
            if (getField.defaulted("mmbAttributes")) {
                throw new NullPointerException("mmbAttributes");
            }
            this.modelMBeanConstructors = (MBeanConstructorInfo[])getField.get("mmbConstructors", null);
            if (getField.defaulted("mmbConstructors")) {
                throw new NullPointerException("mmbConstructors");
            }
            this.modelMBeanNotifications = (MBeanNotificationInfo[])getField.get("mmbNotifications", null);
            if (getField.defaulted("mmbNotifications")) {
                throw new NullPointerException("mmbNotifications");
            }
            this.modelMBeanOperations = (MBeanOperationInfo[])getField.get("mmbOperations", null);
            if (getField.defaulted("mmbOperations")) {
                throw new NullPointerException("mmbOperations");
            }
        } else {
            objectInputStream.defaultReadObject();
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        if (compat) {
            ObjectOutputStream.PutField putField = objectOutputStream.putFields();
            putField.put("modelMBeanDescriptor", this.modelMBeanDescriptor);
            putField.put("mmbAttributes", this.modelMBeanAttributes);
            putField.put("mmbConstructors", this.modelMBeanConstructors);
            putField.put("mmbNotifications", this.modelMBeanNotifications);
            putField.put("mmbOperations", this.modelMBeanOperations);
            putField.put("currClass", currClass);
            objectOutputStream.writeFields();
        } else {
            objectOutputStream.defaultWriteObject();
        }
    }

    static {
        compat = false;
        try {
            GetPropertyAction getPropertyAction = new GetPropertyAction("jmx.serial.form");
            String string = AccessController.doPrivileged(getPropertyAction);
            compat = string != null && string.equals("1.0");
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (compat) {
            serialPersistentFields = oldSerialPersistentFields;
            serialVersionUID = -3944083498453227709L;
        } else {
            serialPersistentFields = newSerialPersistentFields;
            serialVersionUID = -1935722590756516193L;
        }
        NO_ATTRIBUTES = new ModelMBeanAttributeInfo[0];
        NO_CONSTRUCTORS = new ModelMBeanConstructorInfo[0];
        NO_NOTIFICATIONS = new ModelMBeanNotificationInfo[0];
        NO_OPERATIONS = new ModelMBeanOperationInfo[0];
    }
}

