/*
 * Decompiled with CFR 0.152.
 */
package javax.management.namespace;

import com.sun.jmx.defaults.JmxProperties;
import com.sun.jmx.namespace.ObjectNameRouter;
import com.sun.jmx.namespace.RoutingConnectionProxy;
import com.sun.jmx.namespace.RoutingServerProxy;
import com.sun.jmx.namespace.serial.RewritingProcessor;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.MBeanServer;
import javax.management.MBeanServerConnection;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;

public class JMXNamespaces {
    private static final Logger LOG = JmxProperties.NAMESPACE_LOGGER;
    public static final String NAMESPACE_SEPARATOR = "//";
    private static final int NAMESPACE_SEPARATOR_LENGTH = "//".length();

    private JMXNamespaces() {
    }

    public static MBeanServerConnection narrowToNamespace(MBeanServerConnection mBeanServerConnection, String string) {
        if (LOG.isLoggable(Level.FINER)) {
            LOG.finer("Making MBeanServerConnection for: " + string);
        }
        return RoutingConnectionProxy.cd(mBeanServerConnection, string, true);
    }

    public static MBeanServer narrowToNamespace(MBeanServer mBeanServer, String string) {
        if (LOG.isLoggable(Level.FINER)) {
            LOG.finer("Making MBeanServer for: " + string);
        }
        return RoutingServerProxy.cd(mBeanServer, string, true);
    }

    public static <T> T deepReplaceHeadNamespace(T t, String string, String string2) {
        RewritingProcessor rewritingProcessor = RewritingProcessor.newRewritingProcessor(string2, string);
        return rewritingProcessor.rewriteOutput(t);
    }

    public static String concat(String string, String string2) {
        if (string == null || string2 == null) {
            throw new IllegalArgumentException("Null argument");
        }
        JMXNamespaces.checkTrailingSlashes(string);
        JMXNamespaces.checkTrailingSlashes(string2);
        String string3 = string.equals("") ? string2 : (string2.equals("") ? string : string + NAMESPACE_SEPARATOR + string2);
        return ObjectNameRouter.normalizeNamespacePath(string3, false, true, false);
    }

    public static String normalizeNamespaceName(String string) {
        if (string == null) {
            throw new IllegalArgumentException("Null namespace");
        }
        String string2 = ObjectNameRouter.normalizeNamespacePath(string, false, true, false);
        if (string2.equals("")) {
            return string2;
        }
        JMXNamespaces.getNamespaceObjectName(string2);
        return string2;
    }

    public static ObjectName getNamespaceObjectName(String string) {
        if (string == null || string.equals("")) {
            throw new IllegalArgumentException("Null or empty namespace");
        }
        String string2 = ObjectNameRouter.normalizeNamespacePath(string, false, true, false);
        try {
            return ObjectName.getInstance(string2 + NAMESPACE_SEPARATOR + ":" + "type=JMXNamespace");
        }
        catch (MalformedObjectNameException malformedObjectNameException) {
            throw new IllegalArgumentException("Invalid namespace: " + string, malformedObjectNameException);
        }
    }

    public static ObjectName getWildcardFor(String string) {
        return JMXNamespaces.insertPath(string, ObjectName.WILDCARD);
    }

    public static ObjectName insertPath(String string, ObjectName objectName) {
        if (string == null || objectName == null) {
            throw new IllegalArgumentException("Null argument");
        }
        JMXNamespaces.checkTrailingSlashes(string);
        String string2 = string;
        if (!string2.equals("")) {
            string2 = ObjectNameRouter.normalizeNamespacePath(string2 + NAMESPACE_SEPARATOR, false, false, false);
        }
        return objectName.withDomain(ObjectNameRouter.normalizeDomain(string2 + objectName.getDomain(), false));
    }

    public static String getContainingNamespace(ObjectName objectName) {
        return JMXNamespaces.getNormalizedPath(objectName, true);
    }

    static String getNormalizedPath(ObjectName objectName, boolean bl) {
        int n;
        if (objectName == null) {
            throw new IllegalArgumentException("Null name");
        }
        String string = ObjectNameRouter.normalizeDomain(objectName.getDomain(), bl);
        int n2 = string.length();
        if (string.endsWith("///")) {
            return string.substring(0, n2 - NAMESPACE_SEPARATOR_LENGTH - 1);
        }
        if (string.endsWith(NAMESPACE_SEPARATOR)) {
            string = string.substring(0, n2 - NAMESPACE_SEPARATOR_LENGTH);
        }
        if ((n = string.lastIndexOf(NAMESPACE_SEPARATOR)) < 0) {
            return "";
        }
        if (n == 0) {
            return string;
        }
        if (string.charAt(n - 1) == '/') {
            --n;
        }
        return string.substring(0, n);
    }

    private static void checkTrailingSlashes(String string) {
        int n;
        for (n = string.length() - 1; n >= 0 && string.charAt(n) == '/'; --n) {
        }
        if (string.length() - n % 2 == 0) {
            throw new IllegalArgumentException("Path ends with odd number of /");
        }
    }
}

