/*
 * Decompiled with CFR 0.152.
 */
package javax.management.namespace;

import com.sun.jmx.remote.util.ClassLogger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.management.InstanceNotFoundException;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanNotificationInfo;
import javax.management.Notification;
import javax.management.NotificationEmitter;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import javax.management.event.EventConsumer;

public class VirtualEventManager
implements EventConsumer {
    private final Map<ObjectName, List<ListenerInfo>> exactSubscriptionMap = new HashMap<ObjectName, List<ListenerInfo>>();
    private final Map<ObjectName, List<ListenerInfo>> patternSubscriptionMap = new HashMap<ObjectName, List<ListenerInfo>>();
    private static final ClassLogger logger = new ClassLogger("javax.management.event", "EventManager");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void subscribe(ObjectName objectName, NotificationListener notificationListener, NotificationFilter notificationFilter, Object object) {
        if (logger.traceOn()) {
            logger.trace("subscribe", "" + objectName);
        }
        if (objectName == null) {
            throw new IllegalArgumentException("Null MBean name");
        }
        if (notificationListener == null) {
            throw new IllegalArgumentException("Null listener");
        }
        Map<ObjectName, List<ListenerInfo>> map = objectName.isPattern() ? this.patternSubscriptionMap : this.exactSubscriptionMap;
        ListenerInfo listenerInfo = new ListenerInfo(notificationListener, notificationFilter, object);
        Map<ObjectName, List<ListenerInfo>> map2 = map;
        synchronized (map2) {
            List<ListenerInfo> list = map.get(objectName);
            if (list == null) {
                list = new ArrayList<ListenerInfo>();
                map.put(objectName, list);
            }
            list.add(listenerInfo);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unsubscribe(ObjectName objectName, NotificationListener notificationListener) throws ListenerNotFoundException {
        if (logger.traceOn()) {
            logger.trace("unsubscribe2", "" + objectName);
        }
        if (objectName == null) {
            throw new IllegalArgumentException("Null MBean name");
        }
        if (notificationListener == null) {
            throw new ListenerNotFoundException();
        }
        Map<ObjectName, List<ListenerInfo>> map = objectName.isPattern() ? this.patternSubscriptionMap : this.exactSubscriptionMap;
        ListenerInfo listenerInfo = new ListenerInfo(notificationListener, null, null);
        Map<ObjectName, List<ListenerInfo>> map2 = map;
        synchronized (map2) {
            List<ListenerInfo> list = map.get(objectName);
            if (list == null || !list.remove(listenerInfo)) {
                throw new ListenerNotFoundException();
            }
            if (list.isEmpty()) {
                map.remove(objectName);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unsubscribe(ObjectName objectName, NotificationListener notificationListener, NotificationFilter notificationFilter, Object object) throws ListenerNotFoundException {
        Map<ObjectName, List<ListenerInfo>> map;
        if (logger.traceOn()) {
            logger.trace("unsubscribe4", "" + objectName);
        }
        if (objectName == null) {
            throw new IllegalArgumentException("Null MBean name");
        }
        if (notificationListener == null) {
            throw new ListenerNotFoundException();
        }
        Map<ObjectName, List<ListenerInfo>> map2 = map = objectName.isPattern() ? this.patternSubscriptionMap : this.exactSubscriptionMap;
        synchronized (map2) {
            List<ListenerInfo> list = map.get(objectName);
            boolean bl = false;
            Iterator<ListenerInfo> iterator = list.iterator();
            while (iterator.hasNext()) {
                ListenerInfo listenerInfo = iterator.next();
                if (!listenerInfo.equals(notificationListener, notificationFilter, object)) continue;
                iterator.remove();
                bl = true;
                break;
            }
            if (!bl) {
                throw new ListenerNotFoundException();
            }
            if (list.isEmpty()) {
                map.remove(objectName);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void publish(ObjectName objectName, Notification notification) {
        if (logger.traceOn()) {
            logger.trace("publish", "" + objectName);
        }
        if (notification == null) {
            throw new IllegalArgumentException("Null notification");
        }
        if (objectName == null) {
            throw new IllegalArgumentException("Null emitter name");
        }
        if (objectName.isPattern()) {
            throw new IllegalArgumentException("The emitter must not be an ObjectName pattern");
        }
        ArrayList<ListenerInfo> arrayList = new ArrayList<ListenerInfo>();
        Map<ObjectName, List<ListenerInfo>> map = this.exactSubscriptionMap;
        synchronized (map) {
            List<ListenerInfo> list = this.exactSubscriptionMap.get(objectName);
            if (list != null) {
                arrayList.addAll(list);
            }
        }
        map = this.patternSubscriptionMap;
        synchronized (map) {
            for (ObjectName objectName2 : this.patternSubscriptionMap.keySet()) {
                if (!objectName2.apply(objectName)) continue;
                arrayList.addAll((Collection<ListenerInfo>)this.patternSubscriptionMap.get(objectName2));
            }
        }
        VirtualEventManager.sendNotif(arrayList, notification);
    }

    public NotificationEmitter getNotificationEmitterFor(final ObjectName objectName) throws InstanceNotFoundException {
        NotificationEmitter notificationEmitter = new NotificationEmitter(){

            @Override
            public void addNotificationListener(NotificationListener notificationListener, NotificationFilter notificationFilter, Object object) throws IllegalArgumentException {
                VirtualEventManager.this.subscribe(objectName, notificationListener, notificationFilter, object);
            }

            @Override
            public void removeNotificationListener(NotificationListener notificationListener) throws ListenerNotFoundException {
                VirtualEventManager.this.unsubscribe(objectName, notificationListener);
            }

            @Override
            public void removeNotificationListener(NotificationListener notificationListener, NotificationFilter notificationFilter, Object object) throws ListenerNotFoundException {
                VirtualEventManager.this.unsubscribe(objectName, notificationListener, notificationFilter, object);
            }

            @Override
            public MBeanNotificationInfo[] getNotificationInfo() {
                return null;
            }
        };
        return notificationEmitter;
    }

    private static void sendNotif(List<ListenerInfo> list, Notification notification) {
        for (ListenerInfo listenerInfo : list) {
            if (listenerInfo.filter != null && !listenerInfo.filter.isNotificationEnabled(notification)) continue;
            try {
                listenerInfo.listener.handleNotification(notification, listenerInfo.handback);
            }
            catch (Exception exception) {
                logger.trace("sendNotif", "handleNotification", exception);
            }
        }
    }

    private static class ListenerInfo {
        public final NotificationListener listener;
        public final NotificationFilter filter;
        public final Object handback;

        public ListenerInfo(NotificationListener notificationListener, NotificationFilter notificationFilter, Object object) {
            if (notificationListener == null) {
                throw new IllegalArgumentException("Null listener.");
            }
            this.listener = notificationListener;
            this.filter = notificationFilter;
            this.handback = object;
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (!(object instanceof ListenerInfo)) {
                return false;
            }
            return this.listener.equals(((ListenerInfo)object).listener);
        }

        boolean equals(NotificationListener notificationListener, NotificationFilter notificationFilter, Object object) {
            return this.listener == notificationListener && ListenerInfo.same(this.filter, notificationFilter) && ListenerInfo.same(this.handback, object);
        }

        private static boolean same(Object object, Object object2) {
            if (object == object2) {
                return true;
            }
            if (object == null) {
                return false;
            }
            return object.equals(object2);
        }

        public int hashCode() {
            return this.listener.hashCode();
        }
    }
}

