/*
 * Decompiled with CFR 0.152.
 */
package javax.management.openmbean;

import java.io.InvalidObjectException;
import java.lang.reflect.Type;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.OpenType;

public abstract class MXBeanMapping {
    private final Type javaType;
    private final OpenType<?> openType;
    private final Class<?> openClass;

    protected MXBeanMapping(Type type, OpenType<?> openType) {
        if (type == null || openType == null) {
            throw new NullPointerException("Null argument");
        }
        this.javaType = type;
        this.openType = openType;
        this.openClass = MXBeanMapping.makeOpenClass(type, openType);
    }

    public final Type getJavaType() {
        return this.javaType;
    }

    public final OpenType<?> getOpenType() {
        return this.openType;
    }

    public final Class<?> getOpenClass() {
        return this.openClass;
    }

    private static Class<?> makeOpenClass(Type type, OpenType<?> openType) {
        if (type instanceof Class && ((Class)type).isPrimitive()) {
            return (Class)type;
        }
        try {
            String string = OpenType.validClassName(openType.getClassName());
            return Class.forName(string, false, null);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new RuntimeException(classNotFoundException);
        }
        catch (OpenDataException openDataException) {
            throw new IllegalArgumentException("Bad OpenType: " + openType, openDataException);
        }
    }

    public abstract Object fromOpenValue(Object var1) throws InvalidObjectException;

    public abstract Object toOpenValue(Object var1) throws OpenDataException;

    public void checkReconstructible() throws InvalidObjectException {
    }
}

