/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.filechooser;

import java.io.File;
import java.io.IOException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.text.MessageFormat;
import javax.swing.UIManager;
import javax.swing.filechooser.FileSystemView;

class WindowsFileSystemView
extends FileSystemView {
    private static final String newFolderString = UIManager.getString("FileChooser.win32.newFolder");
    private static final String newFolderNextString = UIManager.getString("FileChooser.win32.newFolder.subsequent");

    WindowsFileSystemView() {
    }

    @Override
    public Boolean isTraversable(File file) {
        return this.isFileSystemRoot(file) || this.isComputerNode(file) || file.isDirectory();
    }

    @Override
    public File getChild(File file, String string) {
        String string2;
        if (string.startsWith("\\") && !string.startsWith("\\\\") && this.isFileSystem(file) && (string2 = file.getAbsolutePath()).length() >= 2 && string2.charAt(1) == ':' && Character.isLetter(string2.charAt(0))) {
            return this.createFileObject(string2.substring(0, 2) + string);
        }
        return super.getChild(file, string);
    }

    @Override
    public String getSystemTypeDescription(File file) {
        if (file != null) {
            return this.getShellFolder(file).getFolderType();
        }
        return null;
    }

    @Override
    public File getHomeDirectory() {
        return this.getRoots()[0];
    }

    @Override
    public File createNewFolder(File file) throws IOException {
        if (file == null) {
            throw new IOException("Containing directory is null:");
        }
        File file2 = this.createFileObject(file, newFolderString);
        for (int i = 2; file2.exists() && i < 100; ++i) {
            file2 = this.createFileObject(file, MessageFormat.format(newFolderNextString, new Integer(i)));
        }
        if (file2.exists()) {
            throw new IOException("Directory already exists:" + file2.getAbsolutePath());
        }
        file2.mkdirs();
        return file2;
    }

    @Override
    public boolean isDrive(File file) {
        return this.isFileSystemRoot(file);
    }

    @Override
    public boolean isFloppyDrive(final File file) {
        String string = AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                return file.getAbsolutePath();
            }
        });
        return string != null && (string.equals("A:\\") || string.equals("B:\\"));
    }

    @Override
    public File createFileObject(String string) {
        if (string.length() >= 2 && string.charAt(1) == ':' && Character.isLetter(string.charAt(0))) {
            if (string.length() == 2) {
                string = string + "\\";
            } else if (string.charAt(2) != '\\') {
                string = string.substring(0, 2) + "\\" + string.substring(2);
            }
        }
        return super.createFileObject(string);
    }

    @Override
    protected File createFileSystemRoot(File file) {
        return new FileSystemView.FileSystemRoot(file){

            @Override
            public boolean exists() {
                return true;
            }
        };
    }
}

